// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.FrameSlotTypeException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64ReadRegisterNode#readI64}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link LLVMAMD64ReadRegisterNode#readAddress}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMAMD64ReadRegisterNode#readObject}
 *     Activation probability: 0.18333
 *     With/without class size: 6/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64ReadRegisterNode.class)
@SuppressWarnings("javadoc")
public final class LLVMAMD64ReadRegisterNodeGen extends LLVMAMD64ReadRegisterNode implements GenerateAOT.Provider {

    private final int slot;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64ReadRegisterNode#readI64}
     *   2: SpecializationExcluded {@link LLVMAMD64ReadRegisterNode#readI64}
     *   3: SpecializationActive {@link LLVMAMD64ReadRegisterNode#readAddress}
     *   4: SpecializationExcluded {@link LLVMAMD64ReadRegisterNode#readAddress}
     *   5: SpecializationActive {@link LLVMAMD64ReadRegisterNode#readObject}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMAMD64ReadRegisterNodeGen(int slot) {
        this.slot = slot;
    }

    @Override
    protected int getSlot() {
        return this.slot;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue);
        }
        if ((state_0 & 0b101010) != 0 /* is SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] || SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] || SpecializationActive[LLVMAMD64ReadRegisterNode.readObject(VirtualFrame)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] */) {
                try {
                    return readI64(frameValue);
                } catch (FrameSlotTypeException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] */;
                    state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(frameValue);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] */) {
                try {
                    return readAddress(frameValue);
                } catch (FrameSlotTypeException ex) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    state_0 = this.state_0_;
                    state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] */;
                    state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                    this.state_0_ = state_0;
                    return executeAndSpecialize(frameValue);
                }
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAMD64ReadRegisterNode.readObject(VirtualFrame)] */) {
                return readObject(frameValue);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue);
    }

    @Override
    public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
        int state_0 = this.state_0_;
        if ((state_0 & 0b101000) != 0 /* is SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] || SpecializationActive[LLVMAMD64ReadRegisterNode.readObject(VirtualFrame)] */) {
            return LLVMTypesGen.expectLong(executeGeneric(frameValue));
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return LLVMTypesGen.expectLong(executeAndSpecialize(frameValue));
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] */) {
            try {
                return readI64(frameValue);
            } catch (FrameSlotTypeException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] */;
                state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                return LLVMTypesGen.expectLong(executeAndSpecialize(frameValue));
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return LLVMTypesGen.expectLong(executeAndSpecialize(frameValue));
    }

    private Object executeAndSpecialize(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b101000)) == 0 /* is-not SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] && SpecializationActive[LLVMAMD64ReadRegisterNode.readObject(VirtualFrame)] */ && ((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */) {
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] */;
            this.state_0_ = state_0;
            try {
                return readI64(frameValue);
            } catch (FrameSlotTypeException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] */;
                state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                return executeAndSpecialize(frameValue);
            }
        }
        if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[LLVMAMD64ReadRegisterNode.readObject(VirtualFrame)] */ && ((state_0 & 0b10000)) == 0 /* is-not SpecializationExcluded  */) {
            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)] */;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] */;
            this.state_0_ = state_0;
            try {
                return readAddress(frameValue);
            } catch (FrameSlotTypeException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                state_0 = this.state_0_;
                state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] */;
                state_0 = state_0 | 0b10000 /* add SpecializationExcluded  */;
                this.state_0_ = state_0;
                return executeAndSpecialize(frameValue);
            }
        }
        state_0 = state_0 & 0xfffffff5 /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)], SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] */;
        state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMAMD64ReadRegisterNode.readObject(VirtualFrame)] */;
        this.state_0_ = state_0;
        return readObject(frameValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ & 0xfffffff5 /* remove SpecializationActive[LLVMAMD64ReadRegisterNode.readI64(VirtualFrame)], SpecializationActive[LLVMAMD64ReadRegisterNode.readAddress(VirtualFrame)] */;
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMAMD64ReadRegisterNode.readObject(VirtualFrame)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64ReadRegisterNode create(int slot) {
        return new LLVMAMD64ReadRegisterNodeGen(slot);
    }

}
