// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.asm.support;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMAMD64WriteNode#doI8}
 *     Activation probability: 0.27381
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMAMD64WriteNode#doI16}
 *     Activation probability: 0.23095
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMAMD64WriteNode#doI32}
 *     Activation probability: 0.18810
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMAMD64WriteNode#doI64}
 *     Activation probability: 0.14524
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMAMD64WriteNode#doNativePointer}
 *     Activation probability: 0.10238
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMAMD64WriteNode#doMemoryWrite}
 *     Activation probability: 0.05952
 *     With/without class size: 5/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMAMD64WriteNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMAMD64WriteNodeGen extends LLVMAMD64WriteNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMAMD64WriteNode#doI8}
     *   2: SpecializationActive {@link LLVMAMD64WriteNode#doI16}
     *   3: SpecializationActive {@link LLVMAMD64WriteNode#doI32}
     *   4: SpecializationActive {@link LLVMAMD64WriteNode#doI64}
     *   5: SpecializationActive {@link LLVMAMD64WriteNode#doNativePointer}
     *   6: SpecializationActive {@link LLVMAMD64WriteNode#doMemoryWrite}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private MemoryWriteData memoryWrite_cache;

    private LLVMAMD64WriteNodeGen() {
    }

    private LLVMAMD64WriteNodeGen(int shift) {
        super(shift);
    }

    @Override
    public void execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(frameValue, arg0Value, arg1Value);
            return;
        }
        if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doI8(VirtualFrame, int, byte)] || SpecializationActive[LLVMAMD64WriteNode.doI16(VirtualFrame, int, short)] || SpecializationActive[LLVMAMD64WriteNode.doI32(VirtualFrame, int, int)] || SpecializationActive[LLVMAMD64WriteNode.doI64(VirtualFrame, int, long)] || SpecializationActive[LLVMAMD64WriteNode.doNativePointer(VirtualFrame, int, LLVMNativePointer)] || SpecializationActive[LLVMAMD64WriteNode.doMemoryWrite(LLVMPointer, Object, LLVMAMD64MemWriteNode)] */) {
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doI8(VirtualFrame, int, byte)] || SpecializationActive[LLVMAMD64WriteNode.doI16(VirtualFrame, int, short)] || SpecializationActive[LLVMAMD64WriteNode.doI32(VirtualFrame, int, int)] || SpecializationActive[LLVMAMD64WriteNode.doI64(VirtualFrame, int, long)] || SpecializationActive[LLVMAMD64WriteNode.doNativePointer(VirtualFrame, int, LLVMNativePointer)] */ && arg0Value instanceof Integer) {
                int arg0Value_ = (int) arg0Value;
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doI8(VirtualFrame, int, byte)] */ && arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    doI8(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doI16(VirtualFrame, int, short)] */ && arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    doI16(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doI32(VirtualFrame, int, int)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    doI32(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doI64(VirtualFrame, int, long)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    doI64(frameValue, arg0Value_, arg1Value_);
                    return;
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doNativePointer(VirtualFrame, int, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(arg1Value)) {
                    LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                    doNativePointer(frameValue, arg0Value_, arg1Value_);
                    return;
                }
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.doMemoryWrite(LLVMPointer, Object, LLVMAMD64MemWriteNode)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                MemoryWriteData s5_ = this.memoryWrite_cache;
                if (s5_ != null) {
                    doMemoryWrite(arg0Value_, arg1Value, s5_.writeNode_);
                    return;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(frameValue, arg0Value, arg1Value);
        return;
    }

    private void executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (int) arg0Value;
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (byte) arg1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64WriteNode.doI8(VirtualFrame, int, byte)] */;
                this.state_0_ = state_0;
                doI8(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (short) arg1Value;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64WriteNode.doI16(VirtualFrame, int, short)] */;
                this.state_0_ = state_0;
                doI16(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64WriteNode.doI32(VirtualFrame, int, int)] */;
                this.state_0_ = state_0;
                doI32(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64WriteNode.doI64(VirtualFrame, int, long)] */;
                this.state_0_ = state_0;
                doI64(frameValue, arg0Value_, arg1Value_);
                return;
            }
            if (LLVMTypes.isNativePointer(arg1Value)) {
                LLVMNativePointer arg1Value_ = LLVMTypes.asNativePointer(arg1Value);
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMAMD64WriteNode.doNativePointer(VirtualFrame, int, LLVMNativePointer)] */;
                this.state_0_ = state_0;
                doNativePointer(frameValue, arg0Value_, arg1Value_);
                return;
            }
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            MemoryWriteData s5_ = this.insert(new MemoryWriteData());
            s5_.writeNode_ = s5_.insert((LLVMAMD64WriteNode.createMemoryWriteNode()));
            VarHandle.storeStoreFence();
            this.memoryWrite_cache = s5_;
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMAMD64WriteNode.doMemoryWrite(LLVMPointer, Object, LLVMAMD64MemWriteNode)] */;
            this.state_0_ = state_0;
            doMemoryWrite(arg0Value_, arg1Value, s5_.writeNode_);
            return;
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64WriteNode.doI8(VirtualFrame, int, byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64WriteNode.doI16(VirtualFrame, int, short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64WriteNode.doI32(VirtualFrame, int, int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64WriteNode.doI64(VirtualFrame, int, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMAMD64WriteNode.doNativePointer(VirtualFrame, int, LLVMNativePointer)] */;
        }
        {
            MemoryWriteData s5_ = this.insert(new MemoryWriteData());
            s5_.writeNode_ = s5_.insert((LLVMAMD64WriteNode.createMemoryWriteNode()));
            VarHandle.storeStoreFence();
            this.memoryWrite_cache = s5_;
            assert NodeUtil.assertRecursion(s5_.writeNode_, 1);
            ((GenerateAOT.Provider) s5_.writeNode_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMAMD64WriteNode.doMemoryWrite(LLVMPointer, Object, LLVMAMD64MemWriteNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.memoryWrite_cache = null;
    }

    @NeverDefault
    public static LLVMAMD64WriteNode create() {
        return new LLVMAMD64WriteNodeGen();
    }

    @NeverDefault
    public static LLVMAMD64WriteNode create(int shift) {
        return new LLVMAMD64WriteNodeGen(shift);
    }

    @GeneratedBy(LLVMAMD64WriteNode.class)
    @DenyReplace
    private static final class MemoryWriteData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMAMD64WriteNode#doMemoryWrite}
         *   Parameter: {@link LLVMAMD64MemWriteNode} writeNode</pre>
         */
        @Child LLVMAMD64MemWriteNode writeNode_;

        MemoryWriteData() {
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMAMD64MemWriteNode#doI8}
     *     Activation probability: 0.32000
     *     With/without class size: 10/4 bytes
     *   Specialization {@link LLVMAMD64MemWriteNode#doI16}
     *     Activation probability: 0.26000
     *     With/without class size: 9/4 bytes
     *   Specialization {@link LLVMAMD64MemWriteNode#doI32}
     *     Activation probability: 0.20000
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMAMD64MemWriteNode#doI64}
     *     Activation probability: 0.14000
     *     With/without class size: 6/4 bytes
     *   Specialization {@link LLVMAMD64MemWriteNode#doObject}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMAMD64MemWriteNode.class)
    @SuppressWarnings("javadoc")
    static final class LLVMAMD64MemWriteNodeGen extends LLVMAMD64MemWriteNode implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMAMD64MemWriteNode#doI8}
         *   2: SpecializationActive {@link LLVMAMD64MemWriteNode#doI16}
         *   3: SpecializationActive {@link LLVMAMD64MemWriteNode#doI32}
         *   4: SpecializationActive {@link LLVMAMD64MemWriteNode#doI64}
         *   5: SpecializationActive {@link LLVMAMD64MemWriteNode#doObject}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private I8Data i8_cache;
        @Child private I16Data i16_cache;
        @Child private I32Data i32_cache;
        @Child private I64Data i64_cache;

        private LLVMAMD64MemWriteNodeGen() {
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, LLVMPointer arg0Value, Object arg1Value) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI8(LLVMPointer, byte, LLVMI8StoreNode)] */) && arg1Value instanceof Byte) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI16(LLVMPointer, short, LLVMI16StoreNode)] */) && arg1Value instanceof Short) {
                return false;
            }
            if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI32(LLVMPointer, int, LLVMI32StoreNode)] */) && arg1Value instanceof Integer) {
                return false;
            }
            if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI64(LLVMPointer, long, LLVMI64StoreNode)] */) && arg1Value instanceof Long) {
                return false;
            }
            return true;
        }

        @Override
        public void executeWithTarget(LLVMPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                executeAndSpecialize(arg0Value, arg1Value);
                return;
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI8(LLVMPointer, byte, LLVMI8StoreNode)] || SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI16(LLVMPointer, short, LLVMI16StoreNode)] || SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI32(LLVMPointer, int, LLVMI32StoreNode)] || SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI64(LLVMPointer, long, LLVMI64StoreNode)] || SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doObject(LLVMPointer, Object)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI8(LLVMPointer, byte, LLVMI8StoreNode)] */ && arg1Value instanceof Byte) {
                    byte arg1Value_ = (byte) arg1Value;
                    I8Data s0_ = this.i8_cache;
                    if (s0_ != null) {
                        doI8(arg0Value, arg1Value_, s0_.store_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI16(LLVMPointer, short, LLVMI16StoreNode)] */ && arg1Value instanceof Short) {
                    short arg1Value_ = (short) arg1Value;
                    I16Data s1_ = this.i16_cache;
                    if (s1_ != null) {
                        doI16(arg0Value, arg1Value_, s1_.store_);
                        return;
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI32(LLVMPointer, int, LLVMI32StoreNode)] */ && arg1Value instanceof Integer) {
                    int arg1Value_ = (int) arg1Value;
                    I32Data s2_ = this.i32_cache;
                    if (s2_ != null) {
                        doI32(arg0Value, arg1Value_, s2_.store_);
                        return;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI64(LLVMPointer, long, LLVMI64StoreNode)] */ && arg1Value instanceof Long) {
                    long arg1Value_ = (long) arg1Value;
                    I64Data s3_ = this.i64_cache;
                    if (s3_ != null) {
                        doI64(arg0Value, arg1Value_, s3_.store_);
                        return;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doObject(LLVMPointer, Object)] */) {
                    if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                        doObject(arg0Value, arg1Value);
                        return;
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            executeAndSpecialize(arg0Value, arg1Value);
            return;
        }

        private void executeAndSpecialize(LLVMPointer arg0Value, Object arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (arg1Value instanceof Byte) {
                byte arg1Value_ = (byte) arg1Value;
                I8Data s0_ = this.insert(new I8Data());
                s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i8_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI8(LLVMPointer, byte, LLVMI8StoreNode)] */;
                this.state_0_ = state_0;
                doI8(arg0Value, arg1Value_, s0_.store_);
                return;
            }
            if (arg1Value instanceof Short) {
                short arg1Value_ = (short) arg1Value;
                I16Data s1_ = this.insert(new I16Data());
                s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i16_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI16(LLVMPointer, short, LLVMI16StoreNode)] */;
                this.state_0_ = state_0;
                doI16(arg0Value, arg1Value_, s1_.store_);
                return;
            }
            if (arg1Value instanceof Integer) {
                int arg1Value_ = (int) arg1Value;
                I32Data s2_ = this.insert(new I32Data());
                s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i32_cache = s2_;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI32(LLVMPointer, int, LLVMI32StoreNode)] */;
                this.state_0_ = state_0;
                doI32(arg0Value, arg1Value_, s2_.store_);
                return;
            }
            if (arg1Value instanceof Long) {
                long arg1Value_ = (long) arg1Value;
                I64Data s3_ = this.insert(new I64Data());
                s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i64_cache = s3_;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI64(LLVMPointer, long, LLVMI64StoreNode)] */;
                this.state_0_ = state_0;
                doI64(arg0Value, arg1Value_, s3_.store_);
                return;
            }
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doObject(LLVMPointer, Object)] */;
            this.state_0_ = state_0;
            doObject(arg0Value, arg1Value);
            return;
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                I8Data s0_ = this.insert(new I8Data());
                s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i8_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.store_, 1);
                ((GenerateAOT.Provider) s0_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI8(LLVMPointer, byte, LLVMI8StoreNode)] */;
            }
            {
                I16Data s1_ = this.insert(new I16Data());
                s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i16_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI16(LLVMPointer, short, LLVMI16StoreNode)] */;
            }
            {
                I32Data s2_ = this.insert(new I32Data());
                s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i32_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.store_, 1);
                ((GenerateAOT.Provider) s2_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI32(LLVMPointer, int, LLVMI32StoreNode)] */;
            }
            {
                I64Data s3_ = this.insert(new I64Data());
                s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                VarHandle.storeStoreFence();
                this.i64_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.store_, 1);
                ((GenerateAOT.Provider) s3_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doI64(LLVMPointer, long, LLVMI64StoreNode)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMAMD64WriteNode.LLVMAMD64MemWriteNode.doObject(LLVMPointer, Object)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i8_cache = null;
            this.i16_cache = null;
            this.i32_cache = null;
            this.i64_cache = null;
        }

        @NeverDefault
        public static LLVMAMD64MemWriteNode create() {
            return new LLVMAMD64MemWriteNodeGen();
        }

        @GeneratedBy(LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I8Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMAMD64MemWriteNode#doI8}
             *   Parameter: {@link LLVMI8StoreNode} store</pre>
             */
            @Child LLVMI8StoreNode store_;

            I8Data() {
            }

        }
        @GeneratedBy(LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I16Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMAMD64MemWriteNode#doI16}
             *   Parameter: {@link LLVMI16StoreNode} store</pre>
             */
            @Child LLVMI16StoreNode store_;

            I16Data() {
            }

        }
        @GeneratedBy(LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I32Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMAMD64MemWriteNode#doI32}
             *   Parameter: {@link LLVMI32StoreNode} store</pre>
             */
            @Child LLVMI32StoreNode store_;

            I32Data() {
            }

        }
        @GeneratedBy(LLVMAMD64MemWriteNode.class)
        @DenyReplace
        private static final class I64Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMAMD64MemWriteNode#doI64}
             *   Parameter: {@link LLVMI64StoreNode} store</pre>
             */
            @Child LLVMI64StoreNode store_;

            I64Data() {
            }

        }
    }
}
