// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMTo128BitFloatingNode#doPointer}
 *     Activation probability: 1.00000
 *     With/without class size: 28/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMTo128BitFloatingNode.class)
@SuppressWarnings("javadoc")
public final class LLVMTo128BitFloatingNodeGen extends LLVMTo128BitFloatingNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMTo128BitFloatingNode#doPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private PointerData pointer_cache;

    private LLVMTo128BitFloatingNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    private LLVMTo128BitFloatingNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
        super(isRecursive);
        this.fromNode_ = fromNode;
    }

    @Override
    protected LLVM128BitFloat executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            PointerData s0_ = this.pointer_cache;
            if (s0_ != null) {
                assert DSLSupport.assertIdempotence((!(isRecursive)));
                return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    private LLVM128BitFloat executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if ((!(isRecursive))) {
                PointerData s0_ = this.insert(new PointerData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s0_.recursive_ = s0_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */;
                this.state_0_ = state_0;
                return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            if ((!(isRecursive))) {
                PointerData s0_ = this.insert(new PointerData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s0_.recursive_ = s0_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
    }

    @NeverDefault
    public static LLVMTo128BitFloatingNode create(LLVMExpressionNode fromNode) {
        return new LLVMTo128BitFloatingNodeGen(fromNode);
    }

    @NeverDefault
    public static LLVMTo128BitFloatingNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
        return new LLVMTo128BitFloatingNodeGen(isRecursive, fromNode);
    }

    @GeneratedBy(LLVMTo128BitFloatingNode.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMTo128BitFloatingNode#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMTo128BitFloatingNode#doPointer}
         *   Parameter: {@link LLVMTo128BitFloatingNode} recursive</pre>
         */
        @Child LLVMTo128BitFloatingNode recursive_;

        PointerData() {
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMTo128BitFloatingNode#doPointer}
     *     Activation probability: 0.23929
     *     With/without class size: 9/8 bytes
     *   Specialization {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(long)}
     *     Activation probability: 0.20714
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(double)}
     *     Activation probability: 0.17500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(int)}
     *     Activation probability: 0.14286
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(float)}
     *     Activation probability: 0.11071
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVM128BitFloat)}
     *     Activation probability: 0.07857
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVMIVarBitLarge)}
     *     Activation probability: 0.04643
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToLLVM128BitFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToLLVM128BitFloatNodeGen extends LLVMSignedCastToLLVM128BitFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMTo128BitFloatingNode#doPointer}
         *   2: SpecializationActive {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(long)}
         *   3: SpecializationActive {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(double)}
         *   4: SpecializationActive {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(int)}
         *   5: SpecializationActive {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(float)}
         *   6: SpecializationActive {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVM128BitFloat)}
         *   7: SpecializationActive {@link LLVMSignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVMIVarBitLarge)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMSignedCastToLLVM128BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMSignedCastToLLVM128BitFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected LLVM128BitFloat executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] */) {
                return doLLVM128BitFloatNode(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111010) == 0 /* only-active SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_long0(state_0, frameValue);
            } else if ((state_0 & 0b11110110) == 0 /* only-active SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_double1(state_0, frameValue);
            } else if ((state_0 & 0b11101110) == 0 /* only-active SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_int2(state_0, frameValue);
            } else if ((state_0 & 0b11011110) == 0 /* only-active SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */ && ((state_0 & 0b11111110) != 0  /* is-not SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_float3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] */;
            return doLLVM128BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */;
            return doLLVM128BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_int2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] */;
            return doLLVM128BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_float3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */;
            return doLLVM128BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111110) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */ && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVM128BitFloat executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMSignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMSignedCastToLLVM128BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToLLVM128BitFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMSignedCastToLLVM128BitFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToLLVM128BitFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMSignedCastToLLVM128BitFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo128BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo128BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMTo128BitFloatingNode} recursive</pre>
             */
            @Child LLVMTo128BitFloatingNode recursive_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMTo128BitFloatingNode#doPointer}
     *     Activation probability: 0.32000
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(float)}
     *     Activation probability: 0.26000
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(double)}
     *     Activation probability: 0.20000
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVM128BitFloat)}
     *     Activation probability: 0.14000
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVMIVarBitLarge)}
     *     Activation probability: 0.08000
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMUnsignedCastToLLVM128BitFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMUnsignedCastToLLVM128BitFloatNodeGen extends LLVMUnsignedCastToLLVM128BitFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMTo128BitFloatingNode#doPointer}
         *   2: SpecializationActive {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(float)}
         *   3: SpecializationActive {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(double)}
         *   4: SpecializationActive {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVM128BitFloat)}
         *   5: SpecializationActive {@link LLVMUnsignedCastToLLVM128BitFloatNode#doLLVM128BitFloatNode(LLVMIVarBitLarge)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMUnsignedCastToLLVM128BitFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMUnsignedCastToLLVM128BitFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected LLVM128BitFloat executeWith(long fromNodeValue) {
            throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111010) == 0 /* only-active SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_float0(state_0, frameValue);
            } else if ((state_0 & 0b110110) == 0 /* only-active SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] && SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */)) {
                return executeGeneric_double1(state_0, frameValue);
            } else {
                return executeGeneric_generic2(state_0, frameValue);
            }
        }

        private Object executeGeneric_float0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */;
            return doLLVM128BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_double1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */;
            return doLLVM128BitFloatNode(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] || SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */ && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return doLLVM128BitFloatNode(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVM128BitFloat executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */;
                this.state_0_ = state_0;
                return doLLVM128BitFloatNode(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTo128BitFloatingNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMTo128BitFloatingNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVM128BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMTo128BitFloatingNode.LLVMUnsignedCastToLLVM128BitFloatNode.doLLVM128BitFloatNode(LLVMIVarBitLarge)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMUnsignedCastToLLVM128BitFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToLLVM128BitFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMUnsignedCastToLLVM128BitFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToLLVM128BitFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMUnsignedCastToLLVM128BitFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo128BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMTo128BitFloatingNode#doPointer}
             *   Parameter: {@link LLVMTo128BitFloatingNode} recursive</pre>
             */
            @Child LLVMTo128BitFloatingNode recursive_;

            PointerData() {
            }

        }
    }
}
