// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToAddressNode#doI1}
 *     Activation probability: 0.21250
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMToAddressNode#doI8}
 *     Activation probability: 0.18750
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMToAddressNode#doI16}
 *     Activation probability: 0.16250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMToAddressNode#doI32}
 *     Activation probability: 0.13750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMToAddressNode#doI64}
 *     Activation probability: 0.11250
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMToAddressNode#doLLVMPointer}
 *     Activation probability: 0.08750
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMToAddressNode#doInteropType}
 *     Activation probability: 0.06250
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMToAddressNode#doString}
 *     Activation probability: 0.03750
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMToAddressNode.class)
@SuppressWarnings("javadoc")
public final class LLVMToAddressNodeGen extends LLVMToAddressNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToAddressNode#doI1}
     *   2: SpecializationActive {@link LLVMToAddressNode#doI8}
     *   3: SpecializationActive {@link LLVMToAddressNode#doI16}
     *   4: SpecializationActive {@link LLVMToAddressNode#doI32}
     *   5: SpecializationActive {@link LLVMToAddressNode#doI64}
     *   6: SpecializationActive {@link LLVMToAddressNode#doLLVMPointer}
     *   7: SpecializationActive {@link LLVMToAddressNode#doInteropType}
     *   8: SpecializationActive {@link LLVMToAddressNode#doString}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMToAddressNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    @Override
    public Object executeWithTarget(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue);
        }
        if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMToAddressNode.doI1(boolean)] || SpecializationActive[LLVMToAddressNode.doI8(byte)] || SpecializationActive[LLVMToAddressNode.doI16(short)] || SpecializationActive[LLVMToAddressNode.doI32(int)] || SpecializationActive[LLVMToAddressNode.doI64(long)] || SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] || SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] || SpecializationActive[LLVMToAddressNode.doString(String)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToAddressNode.doI1(boolean)] */ && fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                return doI1(fromNodeValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToAddressNode.doI8(byte)] */ && fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                return doI8(fromNodeValue_);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI16(short)] */ && fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                return doI16(fromNodeValue_);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI32(int)] */ && fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                return doI32(fromNodeValue_);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI64(long)] */ && fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                return doI64(fromNodeValue_);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] */ && LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                return doLLVMPointer(fromNodeValue_);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] */ && fromNodeValue instanceof LLVMInteropType) {
                LLVMInteropType fromNodeValue_ = (LLVMInteropType) fromNodeValue;
                return doInteropType(fromNodeValue_);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToAddressNode.doString(String)] */ && fromNodeValue instanceof String) {
                String fromNodeValue_ = (String) fromNodeValue;
                return doString(fromNodeValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b111111100) == 0 /* only-active SpecializationActive[LLVMToAddressNode.doI1(boolean)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToAddressNode.doI1(boolean)] && SpecializationActive[LLVMToAddressNode.doI8(byte)] && SpecializationActive[LLVMToAddressNode.doI16(short)] && SpecializationActive[LLVMToAddressNode.doI32(int)] && SpecializationActive[LLVMToAddressNode.doI64(long)] && SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] && SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] && SpecializationActive[LLVMToAddressNode.doString(String)] */)) {
            return executeGeneric_boolean0(state_0, frameValue);
        } else if ((state_0 & 0b111111010) == 0 /* only-active SpecializationActive[LLVMToAddressNode.doI8(byte)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToAddressNode.doI1(boolean)] && SpecializationActive[LLVMToAddressNode.doI8(byte)] && SpecializationActive[LLVMToAddressNode.doI16(short)] && SpecializationActive[LLVMToAddressNode.doI32(int)] && SpecializationActive[LLVMToAddressNode.doI64(long)] && SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] && SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] && SpecializationActive[LLVMToAddressNode.doString(String)] */)) {
            return executeGeneric_byte1(state_0, frameValue);
        } else if ((state_0 & 0b111110110) == 0 /* only-active SpecializationActive[LLVMToAddressNode.doI16(short)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToAddressNode.doI1(boolean)] && SpecializationActive[LLVMToAddressNode.doI8(byte)] && SpecializationActive[LLVMToAddressNode.doI16(short)] && SpecializationActive[LLVMToAddressNode.doI32(int)] && SpecializationActive[LLVMToAddressNode.doI64(long)] && SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] && SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] && SpecializationActive[LLVMToAddressNode.doString(String)] */)) {
            return executeGeneric_short2(state_0, frameValue);
        } else if ((state_0 & 0b111101110) == 0 /* only-active SpecializationActive[LLVMToAddressNode.doI32(int)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToAddressNode.doI1(boolean)] && SpecializationActive[LLVMToAddressNode.doI8(byte)] && SpecializationActive[LLVMToAddressNode.doI16(short)] && SpecializationActive[LLVMToAddressNode.doI32(int)] && SpecializationActive[LLVMToAddressNode.doI64(long)] && SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] && SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] && SpecializationActive[LLVMToAddressNode.doString(String)] */)) {
            return executeGeneric_int3(state_0, frameValue);
        } else if ((state_0 & 0b111011110) == 0 /* only-active SpecializationActive[LLVMToAddressNode.doI64(long)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToAddressNode.doI1(boolean)] && SpecializationActive[LLVMToAddressNode.doI8(byte)] && SpecializationActive[LLVMToAddressNode.doI16(short)] && SpecializationActive[LLVMToAddressNode.doI32(int)] && SpecializationActive[LLVMToAddressNode.doI64(long)] && SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] && SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] && SpecializationActive[LLVMToAddressNode.doString(String)] */)) {
            return executeGeneric_long4(state_0, frameValue);
        } else {
            return executeGeneric_generic5(state_0, frameValue);
        }
    }

    private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        boolean fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToAddressNode.doI1(boolean)] */;
        return doI1(fromNodeValue_);
    }

    private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        byte fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI8(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToAddressNode.doI8(byte)] */;
        return doI8(fromNodeValue_);
    }

    private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        short fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI16(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI16(short)] */;
        return doI16(fromNodeValue_);
    }

    private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        int fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI32(int)] */;
        return doI32(fromNodeValue_);
    }

    private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        long fromNodeValue_;
        try {
            fromNodeValue_ = this.fromNode_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI64(long)] */;
        return doI64(fromNodeValue_);
    }

    private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMToAddressNode.doI1(boolean)] || SpecializationActive[LLVMToAddressNode.doI8(byte)] || SpecializationActive[LLVMToAddressNode.doI16(short)] || SpecializationActive[LLVMToAddressNode.doI32(int)] || SpecializationActive[LLVMToAddressNode.doI64(long)] || SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] || SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] || SpecializationActive[LLVMToAddressNode.doString(String)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToAddressNode.doI1(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                boolean fromNodeValue__ = (boolean) fromNodeValue_;
                return doI1(fromNodeValue__);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToAddressNode.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                byte fromNodeValue__ = (byte) fromNodeValue_;
                return doI8(fromNodeValue__);
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI16(short)] */ && fromNodeValue_ instanceof Short) {
                short fromNodeValue__ = (short) fromNodeValue_;
                return doI16(fromNodeValue__);
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI32(int)] */ && fromNodeValue_ instanceof Integer) {
                int fromNodeValue__ = (int) fromNodeValue_;
                return doI32(fromNodeValue__);
            }
            if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToAddressNode.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                long fromNodeValue__ = (long) fromNodeValue_;
                return doI64(fromNodeValue__);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                return doLLVMPointer(fromNodeValue__);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] */ && fromNodeValue_ instanceof LLVMInteropType) {
                LLVMInteropType fromNodeValue__ = (LLVMInteropType) fromNodeValue_;
                return doInteropType(fromNodeValue__);
            }
            if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToAddressNode.doString(String)] */ && fromNodeValue_ instanceof String) {
                String fromNodeValue__ = (String) fromNodeValue_;
                return doString(fromNodeValue__);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    private Object executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (fromNodeValue instanceof Boolean) {
            boolean fromNodeValue_ = (boolean) fromNodeValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToAddressNode.doI1(boolean)] */;
            this.state_0_ = state_0;
            return doI1(fromNodeValue_);
        }
        if (fromNodeValue instanceof Byte) {
            byte fromNodeValue_ = (byte) fromNodeValue;
            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToAddressNode.doI8(byte)] */;
            this.state_0_ = state_0;
            return doI8(fromNodeValue_);
        }
        if (fromNodeValue instanceof Short) {
            short fromNodeValue_ = (short) fromNodeValue;
            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToAddressNode.doI16(short)] */;
            this.state_0_ = state_0;
            return doI16(fromNodeValue_);
        }
        if (fromNodeValue instanceof Integer) {
            int fromNodeValue_ = (int) fromNodeValue;
            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToAddressNode.doI32(int)] */;
            this.state_0_ = state_0;
            return doI32(fromNodeValue_);
        }
        if (fromNodeValue instanceof Long) {
            long fromNodeValue_ = (long) fromNodeValue;
            state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToAddressNode.doI64(long)] */;
            this.state_0_ = state_0;
            return doI64(fromNodeValue_);
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] */;
            this.state_0_ = state_0;
            return doLLVMPointer(fromNodeValue_);
        }
        if (fromNodeValue instanceof LLVMInteropType) {
            LLVMInteropType fromNodeValue_ = (LLVMInteropType) fromNodeValue;
            state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] */;
            this.state_0_ = state_0;
            return doInteropType(fromNodeValue_);
        }
        if (fromNodeValue instanceof String) {
            String fromNodeValue_ = (String) fromNodeValue;
            state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToAddressNode.doString(String)] */;
            this.state_0_ = state_0;
            return doString(fromNodeValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToAddressNode.doI1(boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToAddressNode.doI8(byte)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToAddressNode.doI16(short)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToAddressNode.doI32(int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToAddressNode.doI64(long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToAddressNode.doLLVMPointer(LLVMPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToAddressNode.doInteropType(LLVMInteropType)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToAddressNode.doString(String)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMToAddressNode create(LLVMExpressionNode fromNode) {
        return new LLVMToAddressNodeGen(fromNode);
    }

}
