// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.interop.convert.ForeignToLLVM;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToFloatNode#doManagedPointer}
 *     Activation probability: 0.65000
 *     With/without class size: 24/16 bytes
 *   Specialization {@link LLVMToFloatNode#doPointer}
 *     Activation probability: 0.35000
 *     With/without class size: 12/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMToFloatNode.class)
@SuppressWarnings("javadoc")
public final class LLVMToFloatNodeGen extends LLVMToFloatNode implements GenerateAOT.Provider {

    private static final LibraryFactory<LLVMAsForeignLibrary> L_L_V_M_AS_FOREIGN_LIBRARY_ = LibraryFactory.resolve(LLVMAsForeignLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToFloatNode#doManagedPointer}
     *   2: SpecializationActive {@link LLVMToFloatNode#doPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private ManagedPointerData managedPointer_cache;
    @Child private PointerData pointer_cache;

    private LLVMToFloatNodeGen(LLVMExpressionNode fromNode) {
        this.fromNode_ = fromNode;
    }

    private LLVMToFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
        super(isRecursive);
        this.fromNode_ = fromNode;
    }

    @Override
    protected float executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    assert DSLSupport.assertIdempotence((!(isRecursive)));
                    return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @Override
    public float executeFloat(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                ManagedPointerData s0_ = this.managedPointer_cache;
                if (s0_ != null) {
                    if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                        return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                PointerData s1_ = this.pointer_cache;
                if (s1_ != null) {
                    assert DSLSupport.assertIdempotence((!(isRecursive)));
                    return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    @SuppressWarnings("unused")
    private float executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(fromNodeValue)) {
            LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
            {
                LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                if ((LLVMToFloatNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                    ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                    s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.foreigns_ = foreigns__;
                    Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    s0_.interop_ = interop__;
                    VarHandle.storeStoreFence();
                    this.managedPointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                    this.state_0_ = state_0;
                    return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                }
            }
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if ((!(isRecursive))) {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s1_.recursive_ = s1_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
                this.state_0_ = state_0;
                return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            if ((!(isRecursive))) {
                PointerData s1_ = this.insert(new PointerData());
                s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s1_.recursive_ = s1_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
    }

    @NeverDefault
    public static LLVMToFloatNode create(LLVMExpressionNode fromNode) {
        return new LLVMToFloatNodeGen(fromNode);
    }

    @NeverDefault
    public static LLVMToFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
        return new LLVMToFloatNodeGen(isRecursive, fromNode);
    }

    @GeneratedBy(LLVMToFloatNode.class)
    @DenyReplace
    private static final class ManagedPointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
         *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
         */
        @Child ForeignToLLVM toLLVM_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
         *   Parameter: {@link LLVMToFloatNode} recursive</pre>
         */
        @Child LLVMToFloatNode recursive_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
         *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
         */
        @Child LLVMAsForeignLibrary foreigns_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
         *   Parameter: {@link InteropLibrary} interop</pre>
         */
        @Child InteropLibrary interop_;

        ManagedPointerData() {
        }

    }
    @GeneratedBy(LLVMToFloatNode.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToFloatNode#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToFloatNode#doPointer}
         *   Parameter: {@link LLVMToFloatNode} recursive</pre>
         */
        @Child LLVMToFloatNode recursive_;

        PointerData() {
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToFloatNode#doManagedPointer}
     *     Activation probability: 0.15909
     *     With/without class size: 9/16 bytes
     *   Specialization {@link LLVMToFloatNode#doPointer}
     *     Activation probability: 0.14545
     *     With/without class size: 7/8 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(boolean)}
     *     Activation probability: 0.13182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(byte)}
     *     Activation probability: 0.11818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(short)}
     *     Activation probability: 0.10455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(int)}
     *     Activation probability: 0.09091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(long)}
     *     Activation probability: 0.07727
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(float)}
     *     Activation probability: 0.06364
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(double)}
     *     Activation probability: 0.05000
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(LLVM80BitFloat)}
     *     Activation probability: 0.03636
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToFloatNode#doFloat(LLVM128BitFloat)}
     *     Activation probability: 0.02273
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToFloatNodeGen extends LLVMSignedCastToFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToFloatNode#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToFloatNode#doPointer}
         *   3: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(boolean)}
         *   4: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(byte)}
         *   5: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(short)}
         *   6: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(int)}
         *   7: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(long)}
         *   8: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(float)}
         *   9: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(double)}
         *   10: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(LLVM80BitFloat)}
         *   11: SpecializationActive {@link LLVMSignedCastToFloatNode#doFloat(LLVM128BitFloat)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;

        private LLVMSignedCastToFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMSignedCastToFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected float executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */) {
                return doFloat(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b111111101110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b111111011110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b111110111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b111101111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b111011111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b110111111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111110110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeFloat_boolean8(state_0, frameValue);
            } else if ((state_0 & 0b111111101110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeFloat_byte9(state_0, frameValue);
            } else if ((state_0 & 0b111111011110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeFloat_short10(state_0, frameValue);
            } else if ((state_0 & 0b111110111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeFloat_int11(state_0, frameValue);
            } else if ((state_0 & 0b111101111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeFloat_long12(state_0, frameValue);
            } else if ((state_0 & 0b111011111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeFloat_float13(state_0, frameValue);
            } else if ((state_0 & 0b110111111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */ && ((state_0 & 0b111111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */)) {
                return executeFloat_double14(state_0, frameValue);
            } else {
                return executeFloat_generic15(state_0, frameValue);
            }
        }

        private float executeFloat_boolean8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_byte9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_short10(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_int11(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_long12(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_float13(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_double14(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_generic15(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111111110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] || SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private float executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToFloatNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        s0_.recursive_ = s0_.insert((createRecursive()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                    ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                    ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMSignedCastToFloatNode.doFloat(LLVM128BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMSignedCastToFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMSignedCastToFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMSignedCastToFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMSignedCastToFloatNode.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link LLVMToFloatNode} recursive</pre>
             */
            @Child LLVMToFloatNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

        }
        @GeneratedBy(LLVMSignedCastToFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doPointer}
             *   Parameter: {@link LLVMToFloatNode} recursive</pre>
             */
            @Child LLVMToFloatNode recursive_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToFloatNode#doManagedPointer}
     *     Activation probability: 0.21250
     *     With/without class size: 10/16 bytes
     *   Specialization {@link LLVMToFloatNode#doPointer}
     *     Activation probability: 0.18750
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMUnsignedCastToFloatNode#doFloat(boolean)}
     *     Activation probability: 0.16250
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToFloatNode#doFloat(byte)}
     *     Activation probability: 0.13750
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToFloatNode#doFloat(short)}
     *     Activation probability: 0.11250
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToFloatNode#doFloat(int)}
     *     Activation probability: 0.08750
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToFloatNode#doFloat(long)}
     *     Activation probability: 0.06250
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToFloatNode#doFloat(float)}
     *     Activation probability: 0.03750
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMUnsignedCastToFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMUnsignedCastToFloatNodeGen extends LLVMUnsignedCastToFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToFloatNode#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToFloatNode#doPointer}
         *   3: SpecializationActive {@link LLVMUnsignedCastToFloatNode#doFloat(boolean)}
         *   4: SpecializationActive {@link LLVMUnsignedCastToFloatNode#doFloat(byte)}
         *   5: SpecializationActive {@link LLVMUnsignedCastToFloatNode#doFloat(short)}
         *   6: SpecializationActive {@link LLVMUnsignedCastToFloatNode#doFloat(int)}
         *   7: SpecializationActive {@link LLVMUnsignedCastToFloatNode#doFloat(long)}
         *   8: SpecializationActive {@link LLVMUnsignedCastToFloatNode#doFloat(float)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;

        private LLVMUnsignedCastToFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMUnsignedCastToFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected float executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */) {
                return doFloat(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111110110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b111101110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b111011110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b110111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b101111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b11111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else {
                return executeGeneric_generic6(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111110110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeFloat_boolean7(state_0, frameValue);
            } else if ((state_0 & 0b111101110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeFloat_byte8(state_0, frameValue);
            } else if ((state_0 & 0b111011110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeFloat_short9(state_0, frameValue);
            } else if ((state_0 & 0b110111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeFloat_int10(state_0, frameValue);
            } else if ((state_0 & 0b101111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeFloat_long11(state_0, frameValue);
            } else if ((state_0 & 0b11111110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] && SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */)) {
                return executeFloat_float12(state_0, frameValue);
            } else {
                return executeFloat_generic13(state_0, frameValue);
            }
        }

        private float executeFloat_boolean7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_byte8(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_short9(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_int10(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_long11(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_float12(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_generic13(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] || SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private float executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToFloatNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        s0_.recursive_ = s0_.insert((createRecursive()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                    ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                    ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToFloatNode.LLVMUnsignedCastToFloatNode.doFloat(float)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMUnsignedCastToFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMUnsignedCastToFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMUnsignedCastToFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMUnsignedCastToFloatNode.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link LLVMToFloatNode} recursive</pre>
             */
            @Child LLVMToFloatNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

        }
        @GeneratedBy(LLVMUnsignedCastToFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doPointer}
             *   Parameter: {@link LLVMToFloatNode} recursive</pre>
             */
            @Child LLVMToFloatNode recursive_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToFloatNode#doManagedPointer}
     *     Activation probability: 0.19111
     *     With/without class size: 10/16 bytes
     *   Specialization {@link LLVMToFloatNode#doPointer}
     *     Activation probability: 0.17111
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMBitcastToFloatNode#doFloat(int)}
     *     Activation probability: 0.15111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToFloatNode#doFloat(float)}
     *     Activation probability: 0.13111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToFloatNode#doI1Vector}
     *     Activation probability: 0.11111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToFloatNode#doI8Vector}
     *     Activation probability: 0.09111
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToFloatNode#doI16Vector}
     *     Activation probability: 0.07111
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToFloatNode#doI32Vector}
     *     Activation probability: 0.05111
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToFloatNode#doFloatVector}
     *     Activation probability: 0.03111
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMBitcastToFloatNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMBitcastToFloatNodeGen extends LLVMBitcastToFloatNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToFloatNode#doManagedPointer}
         *   2: SpecializationActive {@link LLVMToFloatNode#doPointer}
         *   3: SpecializationActive {@link LLVMBitcastToFloatNode#doFloat(int)}
         *   4: SpecializationActive {@link LLVMBitcastToFloatNode#doFloat(float)}
         *   5: SpecializationActive {@link LLVMBitcastToFloatNode#doI1Vector}
         *   6: SpecializationActive {@link LLVMBitcastToFloatNode#doI8Vector}
         *   7: SpecializationActive {@link LLVMBitcastToFloatNode#doI16Vector}
         *   8: SpecializationActive {@link LLVMBitcastToFloatNode#doI32Vector}
         *   9: SpecializationActive {@link LLVMBitcastToFloatNode#doFloatVector}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private ManagedPointerData managedPointer_cache;
        @Child private PointerData pointer_cache;

        private LLVMBitcastToFloatNodeGen(LLVMExpressionNode fromNode) {
            this.fromNode_ = fromNode;
        }

        private LLVMBitcastToFloatNodeGen(boolean isRecursive, LLVMExpressionNode fromNode) {
            super(isRecursive);
            this.fromNode_ = fromNode;
        }

        @Override
        protected float executeWith(long fromNodeValue) {
            throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */ && ((state_0 & 0b1111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */)) {
                return executeGeneric_int0(state_0, frameValue);
            } else if ((state_0 & 0b1111101110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */ && ((state_0 & 0b1111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */)) {
                return executeGeneric_float1(state_0, frameValue);
            } else {
                return executeGeneric_generic2(state_0, frameValue);
            }
        }

        private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_float1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] */ && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector) fromNodeValue_;
                    return doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] */ && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector) fromNodeValue_;
                    return doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */ && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector) fromNodeValue_;
                    return doFloatVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @Override
        public float executeFloat(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111110110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */ && ((state_0 & 0b1111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */)) {
                return executeFloat_int3(state_0, frameValue);
            } else if ((state_0 & 0b1111101110) == 0 /* only-active SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */ && ((state_0 & 0b1111111110) != 0  /* is-not SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] && SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] && SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */)) {
                return executeFloat_float4(state_0, frameValue);
            } else {
                return executeFloat_generic5(state_0, frameValue);
            }
        }

        private float executeFloat_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_float4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private float executeFloat_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] || SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] || SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */ && LLVMTypes.isManagedPointer(fromNodeValue_)) {
                    LLVMManagedPointer fromNodeValue__ = LLVMTypes.asManagedPointer(fromNodeValue_);
                    ManagedPointerData s0_ = this.managedPointer_cache;
                    if (s0_ != null) {
                        if ((LLVMToFloatNode.isForeignNumber(fromNodeValue__, s0_.foreigns_, s0_.interop_))) {
                            return doManagedPointer(fromNodeValue__, s0_.toLLVM_, s0_.recursive_, s0_.foreigns_, s0_.interop_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s1_ = this.pointer_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s1_.toNative_, s1_.recursive_);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] */ && fromNodeValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector fromNodeValue__ = (LLVMI8Vector) fromNodeValue_;
                    return doI8Vector(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] */ && fromNodeValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector fromNodeValue__ = (LLVMI16Vector) fromNodeValue_;
                    return doI16Vector(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] */ && fromNodeValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector fromNodeValue__ = (LLVMI32Vector) fromNodeValue_;
                    return doI32Vector(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */ && fromNodeValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector fromNodeValue__ = (LLVMFloatVector) fromNodeValue_;
                    return doFloatVector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        @SuppressWarnings("unused")
        private float executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(fromNodeValue)) {
                LLVMManagedPointer fromNodeValue_ = LLVMTypes.asManagedPointer(fromNodeValue);
                {
                    LLVMAsForeignLibrary foreigns__ = this.insert((L_L_V_M_AS_FOREIGN_LIBRARY_.createDispatched(1)));
                    InteropLibrary interop__ = this.insert((INTEROP_LIBRARY_.createDispatched(3)));
                    if ((LLVMToFloatNode.isForeignNumber(fromNodeValue_, foreigns__, interop__))) {
                        ManagedPointerData s0_ = this.insert(new ManagedPointerData());
                        s0_.toLLVM_ = s0_.insert((createForeignToLLVM()));
                        s0_.recursive_ = s0_.insert((createRecursive()));
                        Objects.requireNonNull(s0_.insert(foreigns__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.foreigns_ = foreigns__;
                        Objects.requireNonNull(s0_.insert(interop__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s0_.interop_ = interop__;
                        VarHandle.storeStoreFence();
                        this.managedPointer_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToFloatNode.doManagedPointer(LLVMManagedPointer, ForeignToLLVM, LLVMToFloatNode, LLVMAsForeignLibrary, InteropLibrary)] */;
                        this.state_0_ = state_0;
                        return doManagedPointer(fromNodeValue_, s0_.toLLVM_, s0_.recursive_, foreigns__, interop__);
                    }
                }
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s1_.toNative_, s1_.recursive_);
                }
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI8Vector) {
                LLVMI8Vector fromNodeValue_ = (LLVMI8Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] */;
                this.state_0_ = state_0;
                return doI8Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI16Vector) {
                LLVMI16Vector fromNodeValue_ = (LLVMI16Vector) fromNodeValue;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] */;
                this.state_0_ = state_0;
                return doI16Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI32Vector) {
                LLVMI32Vector fromNodeValue_ = (LLVMI32Vector) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] */;
                this.state_0_ = state_0;
                return doI32Vector(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMFloatVector) {
                LLVMFloatVector fromNodeValue_ = (LLVMFloatVector) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */;
                this.state_0_ = state_0;
                return doFloatVector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s1_ = this.insert(new PointerData());
                    s1_.toNative_ = s1_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s1_.recursive_ = s1_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s1_;
                    assert NodeUtil.assertRecursion(s1_.toNative_, 1);
                    ((GenerateAOT.Provider) s1_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s1_.recursive_, 1);
                    ((GenerateAOT.Provider) s1_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToFloatNode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToFloatNode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloat(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI1Vector(LLVMI1Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI8Vector(LLVMI8Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI16Vector(LLVMI16Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doI32Vector(LLVMI32Vector)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToFloatNode.LLVMBitcastToFloatNode.doFloatVector(LLVMFloatVector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMBitcastToFloatNode create(LLVMExpressionNode fromNode) {
            return new LLVMBitcastToFloatNodeGen(fromNode);
        }

        @NeverDefault
        public static LLVMBitcastToFloatNode create(boolean isRecursive, LLVMExpressionNode fromNode) {
            return new LLVMBitcastToFloatNodeGen(isRecursive, fromNode);
        }

        @GeneratedBy(LLVMBitcastToFloatNode.class)
        @DenyReplace
        private static final class ManagedPointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link ForeignToLLVM} toLLVM</pre>
             */
            @Child ForeignToLLVM toLLVM_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link LLVMToFloatNode} recursive</pre>
             */
            @Child LLVMToFloatNode recursive_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link LLVMAsForeignLibrary} foreigns</pre>
             */
            @Child LLVMAsForeignLibrary foreigns_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doManagedPointer}
             *   Parameter: {@link InteropLibrary} interop</pre>
             */
            @Child InteropLibrary interop_;

            ManagedPointerData() {
            }

        }
        @GeneratedBy(LLVMBitcastToFloatNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToFloatNode#doPointer}
             *   Parameter: {@link LLVMToFloatNode} recursive</pre>
             */
            @Child LLVMToFloatNode recursive_;

            PointerData() {
            }

        }
    }
}
