// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitLarge;
import com.oracle.truffle.llvm.runtime.LLVMIVarBitSmall;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMToVarINode#doPointer}
 *     Activation probability: 1.00000
 *     With/without class size: 28/8 bytes
 * </pre>
 */
@GeneratedBy(LLVMToVarINode.class)
@SuppressWarnings("javadoc")
public final class LLVMToVarINodeGen extends LLVMToVarINode implements GenerateAOT.Provider {

    private final int bits;
    @Child private LLVMExpressionNode fromNode_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMToVarINode#doPointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private PointerData pointer_cache;

    private LLVMToVarINodeGen(LLVMExpressionNode fromNode, int bits) {
        this.bits = bits;
        this.fromNode_ = fromNode;
    }

    private LLVMToVarINodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
        super(isRecursive);
        this.bits = bits;
        this.fromNode_ = fromNode;
    }

    @Override
    public int getBits() {
        return this.bits;
    }

    @Override
    protected LLVMIVarBit executeWith(long fromNodeValue) {
        throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(fromNodeValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
            LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
            PointerData s0_ = this.pointer_cache;
            if (s0_ != null) {
                assert DSLSupport.assertIdempotence((!(isRecursive)));
                return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(fromNodeValue_);
    }

    private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(fromNodeValue)) {
            LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
            if ((!(isRecursive))) {
                PointerData s0_ = this.insert(new PointerData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s0_.recursive_ = s0_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
                this.state_0_ = state_0;
                return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            if ((!(isRecursive))) {
                PointerData s0_ = this.insert(new PointerData());
                s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                s0_.recursive_ = s0_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.pointer_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
    }

    @NeverDefault
    public static LLVMToVarINode create(LLVMExpressionNode fromNode, int bits) {
        return new LLVMToVarINodeGen(fromNode, bits);
    }

    @NeverDefault
    public static LLVMToVarINode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
        return new LLVMToVarINodeGen(isRecursive, fromNode, bits);
    }

    @GeneratedBy(LLVMToVarINode.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToVarINode#doPointer}
         *   Parameter: {@link LLVMToNativeNode} toNative</pre>
         */
        @Child LLVMToNativeNode toNative_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMToVarINode#doPointer}
         *   Parameter: {@link LLVMToVarINode} recursive</pre>
         */
        @Child LLVMToVarINode recursive_;

        PointerData() {
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToVarINode#doPointer}
     *     Activation probability: 0.17364
     *     With/without class size: 8/8 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#doBoolean}
     *     Activation probability: 0.15727
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#doI8}
     *     Activation probability: 0.14091
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#doI16}
     *     Activation probability: 0.12455
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#doI32}
     *     Activation probability: 0.10818
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#doI64}
     *     Activation probability: 0.09182
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#doIVarBit(LLVMIVarBitLarge)}
     *     Activation probability: 0.07545
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#doIVarBit(LLVMIVarBitSmall)}
     *     Activation probability: 0.05909
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#do80BitFloat}
     *     Activation probability: 0.04273
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMSignedCastToIVarNode#do128BitFloat}
     *     Activation probability: 0.02636
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSignedCastToIVarNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSignedCastToIVarNodeGen extends LLVMSignedCastToIVarNode implements GenerateAOT.Provider {

        private final int bits;
        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToVarINode#doPointer}
         *   2: SpecializationActive {@link LLVMSignedCastToIVarNode#doBoolean}
         *   3: SpecializationActive {@link LLVMSignedCastToIVarNode#doI8}
         *   4: SpecializationActive {@link LLVMSignedCastToIVarNode#doI16}
         *   5: SpecializationActive {@link LLVMSignedCastToIVarNode#doI32}
         *   6: SpecializationActive {@link LLVMSignedCastToIVarNode#doI64}
         *   7: SpecializationActive {@link LLVMSignedCastToIVarNode#doIVarBit(LLVMIVarBitLarge)}
         *   8: SpecializationActive {@link LLVMSignedCastToIVarNode#doIVarBit(LLVMIVarBitSmall)}
         *   9: SpecializationActive {@link LLVMSignedCastToIVarNode#do80BitFloat}
         *   10: SpecializationActive {@link LLVMSignedCastToIVarNode#do128BitFloat}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMSignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        private LLVMSignedCastToIVarNodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            super(isRecursive);
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] */) {
                return doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11111111010) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b11111110110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b11111101110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b11111011110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b11110111110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] */ && ((state_0 & 0b11111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else {
                return executeGeneric_generic5(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] */;
            return doBoolean(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] */;
            return doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] */;
            return doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b11111111110) != 0 /* is SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] || SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doBoolean(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI16(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI32(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] */ && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */ && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                    LLVMIVarBitSmall fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return do128BitFloat(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] */;
                this.state_0_ = state_0;
                return doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] */;
                this.state_0_ = state_0;
                return doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] */;
                this.state_0_ = state_0;
                return doIVarBit(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                LLVMIVarBitSmall fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */;
                this.state_0_ = state_0;
                return doIVarBit(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return do128BitFloat(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doBoolean(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI8(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI16(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI32(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doI64(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do80BitFloat(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToVarINode.LLVMSignedCastToIVarNode.do128BitFloat(LLVM128BitFloat)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMSignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMSignedCastToIVarNodeGen(fromNode, bits);
        }

        @NeverDefault
        public static LLVMSignedCastToIVarNode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            return new LLVMSignedCastToIVarNodeGen(isRecursive, fromNode, bits);
        }

        @GeneratedBy(LLVMSignedCastToIVarNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToVarINode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToVarINode#doPointer}
             *   Parameter: {@link LLVMToVarINode} recursive</pre>
             */
            @Child LLVMToVarINode recursive_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToVarINode#doPointer}
     *     Activation probability: 0.21250
     *     With/without class size: 9/8 bytes
     *   Specialization {@link LLVMUnsignedCastToIVarNode#doBoolean}
     *     Activation probability: 0.18750
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMUnsignedCastToIVarNode#doI8}
     *     Activation probability: 0.16250
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToIVarNode#doI16}
     *     Activation probability: 0.13750
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToIVarNode#doI32}
     *     Activation probability: 0.11250
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToIVarNode#doI64}
     *     Activation probability: 0.08750
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMUnsignedCastToIVarNode#doIVarBit(LLVMIVarBitLarge)}
     *     Activation probability: 0.06250
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMUnsignedCastToIVarNode#doIVarBit(LLVMIVarBitSmall)}
     *     Activation probability: 0.03750
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMUnsignedCastToIVarNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMUnsignedCastToIVarNodeGen extends LLVMUnsignedCastToIVarNode implements GenerateAOT.Provider {

        private final int bits;
        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToVarINode#doPointer}
         *   2: SpecializationActive {@link LLVMUnsignedCastToIVarNode#doBoolean}
         *   3: SpecializationActive {@link LLVMUnsignedCastToIVarNode#doI8}
         *   4: SpecializationActive {@link LLVMUnsignedCastToIVarNode#doI16}
         *   5: SpecializationActive {@link LLVMUnsignedCastToIVarNode#doI32}
         *   6: SpecializationActive {@link LLVMUnsignedCastToIVarNode#doI64}
         *   7: SpecializationActive {@link LLVMUnsignedCastToIVarNode#doIVarBit(LLVMIVarBitLarge)}
         *   8: SpecializationActive {@link LLVMUnsignedCastToIVarNode#doIVarBit(LLVMIVarBitSmall)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMUnsignedCastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        private LLVMUnsignedCastToIVarNodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            super(isRecursive);
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] */) {
                return doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b111111010) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b111110110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b111101110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b111011110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b110111110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] */ && ((state_0 & 0b111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] && SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else {
                return executeGeneric_generic5(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] */;
            return doBoolean(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] */;
            return doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] */;
            return doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_generic5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b111111110) != 0 /* is SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] || SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] || SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] || SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] || SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] || SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] || SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] || SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doBoolean(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI16(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI32(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] */ && LLVMTypes.isLLVMIVarBitLarge(fromNodeValue_)) {
                    LLVMIVarBitLarge fromNodeValue__ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */ && LLVMTypes.isLLVMIVarBitSmall(fromNodeValue_)) {
                    LLVMIVarBitSmall fromNodeValue__ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] */;
                this.state_0_ = state_0;
                return doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] */;
                this.state_0_ = state_0;
                return doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitLarge(fromNodeValue)) {
                LLVMIVarBitLarge fromNodeValue_ = LLVMTypes.asLLVMIVarBitLarge(fromNodeValue);
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] */;
                this.state_0_ = state_0;
                return doIVarBit(fromNodeValue_);
            }
            if (LLVMTypes.isLLVMIVarBitSmall(fromNodeValue)) {
                LLVMIVarBitSmall fromNodeValue_ = LLVMTypes.asLLVMIVarBitSmall(fromNodeValue);
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */;
                this.state_0_ = state_0;
                return doIVarBit(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doBoolean(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI8(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI16(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI32(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doI64(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitLarge)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToVarINode.LLVMUnsignedCastToIVarNode.doIVarBit(LLVMIVarBitSmall)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMUnsignedCastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMUnsignedCastToIVarNodeGen(fromNode, bits);
        }

        @NeverDefault
        public static LLVMUnsignedCastToIVarNode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            return new LLVMUnsignedCastToIVarNodeGen(isRecursive, fromNode, bits);
        }

        @GeneratedBy(LLVMUnsignedCastToIVarNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToVarINode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToVarINode#doPointer}
             *   Parameter: {@link LLVMToVarINode} recursive</pre>
             */
            @Child LLVMToVarINode recursive_;

            PointerData() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMToVarINode#doPointer}
     *     Activation probability: 0.14679
     *     With/without class size: 7/8 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doBoolean}
     *     Activation probability: 0.13526
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doI8}
     *     Activation probability: 0.12372
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doI16}
     *     Activation probability: 0.11218
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doI32}
     *     Activation probability: 0.10064
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doI64}
     *     Activation probability: 0.08910
     *     With/without class size: 5/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doIVarBit}
     *     Activation probability: 0.07756
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doFloat}
     *     Activation probability: 0.06603
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doDouble}
     *     Activation probability: 0.05449
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#do80BitFloat}
     *     Activation probability: 0.04295
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#do128BitFloat}
     *     Activation probability: 0.03141
     *     With/without class size: 4/0 bytes
     *   Specialization {@link LLVMBitcastToIVarNode#doI1Vector}
     *     Activation probability: 0.01987
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMBitcastToIVarNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMBitcastToIVarNodeGen extends LLVMBitcastToIVarNode implements GenerateAOT.Provider {

        private final int bits;
        @Child private LLVMExpressionNode fromNode_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMToVarINode#doPointer}
         *   2: SpecializationActive {@link LLVMBitcastToIVarNode#doBoolean}
         *   3: SpecializationActive {@link LLVMBitcastToIVarNode#doI8}
         *   4: SpecializationActive {@link LLVMBitcastToIVarNode#doI16}
         *   5: SpecializationActive {@link LLVMBitcastToIVarNode#doI32}
         *   6: SpecializationActive {@link LLVMBitcastToIVarNode#doI64}
         *   7: SpecializationActive {@link LLVMBitcastToIVarNode#doIVarBit}
         *   8: SpecializationActive {@link LLVMBitcastToIVarNode#doFloat}
         *   9: SpecializationActive {@link LLVMBitcastToIVarNode#doDouble}
         *   10: SpecializationActive {@link LLVMBitcastToIVarNode#do80BitFloat}
         *   11: SpecializationActive {@link LLVMBitcastToIVarNode#do128BitFloat}
         *   12: SpecializationActive {@link LLVMBitcastToIVarNode#doI1Vector}
         *   13-15: ImplicitCast[type=LLVMIVarBit, index=0]
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private PointerData pointer_cache;

        private LLVMBitcastToIVarNodeGen(LLVMExpressionNode fromNode, int bits) {
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        private LLVMBitcastToIVarNodeGen(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            super(isRecursive);
            this.bits = bits;
            this.fromNode_ = fromNode;
        }

        @Override
        public int getBits() {
            return this.bits;
        }

        @Override
        protected LLVMIVarBit executeWith(long fromNodeValue) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue);
            }
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] */) {
                return doI64(fromNodeValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue);
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111111111010) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_boolean0(state_0, frameValue);
            } else if ((state_0 & 0b1111111110110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_byte1(state_0, frameValue);
            } else if ((state_0 & 0b1111111101110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b1111111011110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_int3(state_0, frameValue);
            } else if ((state_0 & 0b1111110111110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_long4(state_0, frameValue);
            } else if ((state_0 & 0b1111011111110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_float5(state_0, frameValue);
            } else if ((state_0 & 0b1110111111110) == 0 /* only-active SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] */ && ((state_0 & 0b1111111111110) != 0  /* is-not SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] && SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */)) {
                return executeGeneric_double6(state_0, frameValue);
            } else {
                return executeGeneric_generic7(state_0, frameValue);
            }
        }

        private Object executeGeneric_boolean0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            boolean fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] */;
            return doBoolean(fromNodeValue_);
        }

        private Object executeGeneric_byte1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] */;
            return doI8(fromNodeValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] */;
            return doI16(fromNodeValue_);
        }

        private Object executeGeneric_int3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] */;
            return doI32(fromNodeValue_);
        }

        private Object executeGeneric_long4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] */;
            return doI64(fromNodeValue_);
        }

        private Object executeGeneric_float5(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            float fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] */;
            return doFloat(fromNodeValue_);
        }

        private Object executeGeneric_double6(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            double fromNodeValue_;
            try {
                fromNodeValue_ = this.fromNode_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            assert (state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] */;
            return doDouble(fromNodeValue_);
        }

        private Object executeGeneric_generic7(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object fromNodeValue_ = this.fromNode_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(fromNodeValue_);
            }
            if ((state_0 & 0b1111111111110) != 0 /* is SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] || SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */ && LLVMTypes.isPointer(fromNodeValue_)) {
                    LLVMPointer fromNodeValue__ = LLVMTypes.asPointer(fromNodeValue_);
                    PointerData s0_ = this.pointer_cache;
                    if (s0_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        return doPointer(fromNodeValue__, s0_.toNative_, s0_.recursive_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] */ && fromNodeValue_ instanceof Boolean) {
                    boolean fromNodeValue__ = (boolean) fromNodeValue_;
                    return doBoolean(fromNodeValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] */ && fromNodeValue_ instanceof Byte) {
                    byte fromNodeValue__ = (byte) fromNodeValue_;
                    return doI8(fromNodeValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] */ && fromNodeValue_ instanceof Short) {
                    short fromNodeValue__ = (short) fromNodeValue_;
                    return doI16(fromNodeValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] */ && fromNodeValue_ instanceof Integer) {
                    int fromNodeValue__ = (int) fromNodeValue_;
                    return doI32(fromNodeValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] */ && fromNodeValue_ instanceof Long) {
                    long fromNodeValue__ = (long) fromNodeValue_;
                    return doI64(fromNodeValue__);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] */ && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_)) {
                    LLVMIVarBit fromNodeValue__ = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=LLVMIVarBit, index=0] */, fromNodeValue_);
                    return doIVarBit(fromNodeValue__);
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] */ && fromNodeValue_ instanceof Float) {
                    float fromNodeValue__ = (float) fromNodeValue_;
                    return doFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] */ && fromNodeValue_ instanceof Double) {
                    double fromNodeValue__ = (double) fromNodeValue_;
                    return doDouble(fromNodeValue__);
                }
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] */ && fromNodeValue_ instanceof LLVM80BitFloat) {
                    LLVM80BitFloat fromNodeValue__ = (LLVM80BitFloat) fromNodeValue_;
                    return do80BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] */ && fromNodeValue_ instanceof LLVM128BitFloat) {
                    LLVM128BitFloat fromNodeValue__ = (LLVM128BitFloat) fromNodeValue_;
                    return do128BitFloat(fromNodeValue__);
                }
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */ && fromNodeValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector fromNodeValue__ = (LLVMI1Vector) fromNodeValue_;
                    return doI1Vector(fromNodeValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(fromNodeValue_);
        }

        private LLVMIVarBit executeAndSpecialize(Object fromNodeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(fromNodeValue)) {
                LLVMPointer fromNodeValue_ = LLVMTypes.asPointer(fromNodeValue);
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
                    this.state_0_ = state_0;
                    return doPointer(fromNodeValue_, s0_.toNative_, s0_.recursive_);
                }
            }
            if (fromNodeValue instanceof Boolean) {
                boolean fromNodeValue_ = (boolean) fromNodeValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] */;
                this.state_0_ = state_0;
                return doBoolean(fromNodeValue_);
            }
            if (fromNodeValue instanceof Byte) {
                byte fromNodeValue_ = (byte) fromNodeValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] */;
                this.state_0_ = state_0;
                return doI8(fromNodeValue_);
            }
            if (fromNodeValue instanceof Short) {
                short fromNodeValue_ = (short) fromNodeValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] */;
                this.state_0_ = state_0;
                return doI16(fromNodeValue_);
            }
            if (fromNodeValue instanceof Integer) {
                int fromNodeValue_ = (int) fromNodeValue;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] */;
                this.state_0_ = state_0;
                return doI32(fromNodeValue_);
            }
            if (fromNodeValue instanceof Long) {
                long fromNodeValue_ = (long) fromNodeValue;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] */;
                this.state_0_ = state_0;
                return doI64(fromNodeValue_);
            }
            {
                int lLVMIVarBitCast0;
                if ((lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(fromNodeValue)) != 0) {
                    LLVMIVarBit fromNodeValue_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, fromNodeValue);
                    state_0 = (state_0 | (lLVMIVarBitCast0 << 13) /* set-int ImplicitCast[type=LLVMIVarBit, index=0] */);
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] */;
                    this.state_0_ = state_0;
                    return doIVarBit(fromNodeValue_);
                }
            }
            if (fromNodeValue instanceof Float) {
                float fromNodeValue_ = (float) fromNodeValue;
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] */;
                this.state_0_ = state_0;
                return doFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof Double) {
                double fromNodeValue_ = (double) fromNodeValue;
                state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] */;
                this.state_0_ = state_0;
                return doDouble(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat fromNodeValue_ = (LLVM80BitFloat) fromNodeValue;
                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] */;
                this.state_0_ = state_0;
                return do80BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVM128BitFloat) {
                LLVM128BitFloat fromNodeValue_ = (LLVM128BitFloat) fromNodeValue;
                state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] */;
                this.state_0_ = state_0;
                return do128BitFloat(fromNodeValue_);
            }
            if (fromNodeValue instanceof LLVMI1Vector) {
                LLVMI1Vector fromNodeValue_ = (LLVMI1Vector) fromNodeValue;
                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */;
                this.state_0_ = state_0;
                return doI1Vector(fromNodeValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.fromNode_}, fromNodeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                if ((!(isRecursive))) {
                    PointerData s0_ = this.insert(new PointerData());
                    s0_.toNative_ = s0_.insert((LLVMToNativeNode.createToNativeWithTarget()));
                    s0_.recursive_ = s0_.insert((createRecursive()));
                    VarHandle.storeStoreFence();
                    this.pointer_cache = s0_;
                    assert NodeUtil.assertRecursion(s0_.toNative_, 1);
                    ((GenerateAOT.Provider) s0_.toNative_).prepareForAOT(language, root);
                    assert NodeUtil.assertRecursion(s0_.recursive_, 1);
                    ((GenerateAOT.Provider) s0_.recursive_).prepareForAOT(language, root);
                    this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMToVarINode.doPointer(LLVMPointer, LLVMToNativeNode, LLVMToVarINode)] */;
                }
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doBoolean(boolean)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI8(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI16(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI32(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI64(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doIVarBit(LLVMIVarBit)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doFloat(float)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doDouble(double)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do80BitFloat(LLVM80BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.do128BitFloat(LLVM128BitFloat)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000000000 /* add SpecializationActive[LLVMToVarINode.LLVMBitcastToIVarNode.doI1Vector(LLVMI1Vector)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            state_0 = state_0 | 0b1110000000000000 /* add ImplicitCast[type=LLVMIVarBit, index=0] */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.pointer_cache = null;
        }

        @NeverDefault
        public static LLVMBitcastToIVarNode create(LLVMExpressionNode fromNode, int bits) {
            return new LLVMBitcastToIVarNodeGen(fromNode, bits);
        }

        @NeverDefault
        public static LLVMBitcastToIVarNode create(boolean isRecursive, LLVMExpressionNode fromNode, int bits) {
            return new LLVMBitcastToIVarNodeGen(isRecursive, fromNode, bits);
        }

        @GeneratedBy(LLVMBitcastToIVarNode.class)
        @DenyReplace
        private static final class PointerData extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToVarINode#doPointer}
             *   Parameter: {@link LLVMToNativeNode} toNative</pre>
             */
            @Child LLVMToNativeNode toNative_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMToVarINode#doPointer}
             *   Parameter: {@link LLVMToVarINode} recursive</pre>
             */
            @Child LLVMToVarINode recursive_;

            PointerData() {
            }

        }
    }
}
