// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.control.LLVMConditionalBranchNode.LLVMConditionalBranchNodeImpl;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMConditionalBranchNode.class)
@SuppressWarnings("javadoc")
public final class LLVMConditionalBranchNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMConditionalBranchNodeImpl#doCondition}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMConditionalBranchNodeImpl.class)
    @SuppressWarnings("javadoc")
    static final class LLVMConditionalBranchNodeImplNodeGen extends LLVMConditionalBranchNodeImpl implements GenerateAOT.Provider {

        private final int trueSuccessor;
        private final int falseSuccessor;
        @Child private LLVMExpressionNode condition_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMConditionalBranchNodeImpl#doCondition}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMConditionalBranchNodeImplNodeGen(LLVMStatementNode truePhi, LLVMStatementNode falsePhi, LLVMExpressionNode condition, int trueSuccessor, int falseSuccessor) {
            super(truePhi, falsePhi);
            this.trueSuccessor = trueSuccessor;
            this.falseSuccessor = falseSuccessor;
            this.condition_ = condition;
        }

        @Override
        public int getTrueSuccessor() {
            return this.trueSuccessor;
        }

        @Override
        public int getFalseSuccessor() {
            return this.falseSuccessor;
        }

        @Override
        public boolean executeCondition(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            boolean conditionValue_;
            try {
                conditionValue_ = this.condition_.executeI1(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(conditionValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMConditionalBranchNode.LLVMConditionalBranchNodeImpl.doCondition(boolean)] */) {
                return doCondition(conditionValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(conditionValue_);
        }

        private boolean executeAndSpecialize(Object conditionValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (conditionValue instanceof Boolean) {
                boolean conditionValue_ = (boolean) conditionValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMConditionalBranchNode.LLVMConditionalBranchNodeImpl.doCondition(boolean)] */;
                this.state_0_ = state_0;
                return doCondition(conditionValue_);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.condition_}, conditionValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMConditionalBranchNode.LLVMConditionalBranchNodeImpl.doCondition(boolean)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMConditionalBranchNodeImpl create(LLVMStatementNode truePhi, LLVMStatementNode falsePhi, LLVMExpressionNode condition, int trueSuccessor, int falseSuccessor) {
            return new LLVMConditionalBranchNodeImplNodeGen(truePhi, falsePhi, condition, trueSuccessor, falseSuccessor);
        }

    }
}
