// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.control;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.instrumentation.InstrumentableNode.WrapperNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;

@GeneratedBy(LLVMSwitchNode.class)
final class LLVMSwitchNodeWrapper extends LLVMSwitchNode implements WrapperNode {

    @Child private LLVMSwitchNode delegateNode;
    @Child private ProbeNode probeNode;

    LLVMSwitchNodeWrapper(LLVMSwitchNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    @Override
    public LLVMSwitchNode getDelegateNode() {
        return delegateNode;
    }

    @Override
    public ProbeNode getProbeNode() {
        return probeNode;
    }

    @Override
    public Object executeCondition(VirtualFrame frame) {
        Object returnValue;
        for (;;) {
            boolean wasOnReturnExecuted = false;
            try {
                probeNode.onEnter(frame);
                returnValue = delegateNode.executeCondition(frame);
                wasOnReturnExecuted = true;
                probeNode.onReturnValue(frame, returnValue);
                break;
            } catch (Throwable t) {
                Object result = probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted);
                if (result == ProbeNode.UNWIND_ACTION_REENTER) {
                    continue;
                } else if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
        }
        return returnValue;
    }

    @Override
    public int getSuccessorCount() {
        return this.delegateNode.getSuccessorCount();
    }

    @Override
    public int[] getSuccessors() {
        return this.delegateNode.getSuccessors();
    }

    @Override
    public LLVMStatementNode getPhiNode(int successorIndex) {
        return this.delegateNode.getPhiNode(successorIndex);
    }

    @Override
    public boolean checkCase(VirtualFrame frame, int i, Object value) {
        return this.delegateNode.checkCase(frame, i, value);
    }

}
