// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNode.CatchPadEntryNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCatchSwitchNode.LLVMCatchSwitchImpl;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMCatchSwitchNode.class)
@SuppressWarnings("javadoc")
public final class LLVMCatchSwitchNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMCatchSwitchImpl#doCondition}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMCatchSwitchImpl.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMCatchSwitchImplNodeGen extends LLVMCatchSwitchImpl implements GenerateAOT.Provider {

        private LLVMCatchSwitchImplNodeGen(int exceptionSlot, int[] targetBlocks, int unwindBlock, LLVMExpressionNode getStack, LLVMStatementNode[] phiNodes) {
            super(exceptionSlot, targetBlocks, unwindBlock, getStack, phiNodes);
        }

        @Override
        public Object executeCondition(VirtualFrame frameValue) {
            return doCondition(frameValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LLVMCatchSwitchImpl create(int exceptionSlot, int[] targetBlocks, int unwindBlock, LLVMExpressionNode getStack, LLVMStatementNode[] phiNodes) {
            return new LLVMCatchSwitchImplNodeGen(exceptionSlot, targetBlocks, unwindBlock, getStack, phiNodes);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link CatchPadEntryNode#doExecute}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(CatchPadEntryNode.class)
    @SuppressWarnings("javadoc")
    public static final class CatchPadEntryNodeGen extends CatchPadEntryNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode stack_;
        @Child private LLVMExpressionNode thrownObject_;
        @Child private LLVMExpressionNode throwInfo_;
        @Child private LLVMExpressionNode imageBase_;
        @Child private LLVMExpressionNode catchType_;
        @Child private LLVMExpressionNode exceptionSlot_;
        @Child private LLVMExpressionNode stackPointer_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link CatchPadEntryNode#doExecute}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private CatchPadEntryNodeGen(PointerType exceptionType, int attributes, LLVMExpressionNode stack, LLVMExpressionNode thrownObject, LLVMExpressionNode throwInfo, LLVMExpressionNode imageBase, LLVMExpressionNode catchType, LLVMExpressionNode exceptionSlot, LLVMExpressionNode stackPointer) {
            super(exceptionType, attributes);
            this.stack_ = stack;
            this.thrownObject_ = thrownObject;
            this.throwInfo_ = throwInfo;
            this.imageBase_ = imageBase;
            this.catchType_ = catchType;
            this.exceptionSlot_ = exceptionSlot;
            this.stackPointer_ = stackPointer;
        }

        @Override
        boolean execute(VirtualFrame frameValue, LLVMStack stackValue, LLVMPointer thrownObjectValue, LLVMPointer throwInfoValue, LLVMPointer imageBaseValue, long catchTypeValue) {
            int state_0 = this.state_0_;
            Object exceptionSlotValue_ = this.exceptionSlot_.executeGeneric(frameValue);
            Object stackPointerValue_ = this.stackPointer_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue_, stackPointerValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMCatchSwitchNode.CatchPadEntryNode.doExecute(LLVMStack, LLVMPointer, LLVMPointer, LLVMPointer, long, LLVMPointer, LLVMPointer)] */ && LLVMTypes.isPointer(exceptionSlotValue_)) {
                LLVMPointer exceptionSlotValue__ = LLVMTypes.asPointer(exceptionSlotValue_);
                if (LLVMTypes.isPointer(stackPointerValue_)) {
                    LLVMPointer stackPointerValue__ = LLVMTypes.asPointer(stackPointerValue_);
                    return doExecute(stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue__, stackPointerValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue_, stackPointerValue_);
        }

        private boolean executeAndSpecialize(Object stackValue, Object thrownObjectValue, Object throwInfoValue, Object imageBaseValue, Object catchTypeValue, Object exceptionSlotValue, Object stackPointerValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (stackValue instanceof LLVMStack) {
                LLVMStack stackValue_ = (LLVMStack) stackValue;
                if (LLVMTypes.isPointer(thrownObjectValue)) {
                    LLVMPointer thrownObjectValue_ = LLVMTypes.asPointer(thrownObjectValue);
                    if (LLVMTypes.isPointer(throwInfoValue)) {
                        LLVMPointer throwInfoValue_ = LLVMTypes.asPointer(throwInfoValue);
                        if (LLVMTypes.isPointer(imageBaseValue)) {
                            LLVMPointer imageBaseValue_ = LLVMTypes.asPointer(imageBaseValue);
                            if (catchTypeValue instanceof Long) {
                                long catchTypeValue_ = (long) catchTypeValue;
                                if (LLVMTypes.isPointer(exceptionSlotValue)) {
                                    LLVMPointer exceptionSlotValue_ = LLVMTypes.asPointer(exceptionSlotValue);
                                    if (LLVMTypes.isPointer(stackPointerValue)) {
                                        LLVMPointer stackPointerValue_ = LLVMTypes.asPointer(stackPointerValue);
                                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMCatchSwitchNode.CatchPadEntryNode.doExecute(LLVMStack, LLVMPointer, LLVMPointer, LLVMPointer, long, LLVMPointer, LLVMPointer)] */;
                                        this.state_0_ = state_0;
                                        return doExecute(stackValue_, thrownObjectValue_, throwInfoValue_, imageBaseValue_, catchTypeValue_, exceptionSlotValue_, stackPointerValue_);
                                    }
                                }
                            }
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.stack_, this.thrownObject_, this.throwInfo_, this.imageBase_, this.catchType_, this.exceptionSlot_, this.stackPointer_}, stackValue, thrownObjectValue, throwInfoValue, imageBaseValue, catchTypeValue, exceptionSlotValue, stackPointerValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMCatchSwitchNode.CatchPadEntryNode.doExecute(LLVMStack, LLVMPointer, LLVMPointer, LLVMPointer, long, LLVMPointer, LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static CatchPadEntryNode create(PointerType exceptionType, int attributes, LLVMExpressionNode stack, LLVMExpressionNode thrownObject, LLVMExpressionNode throwInfo, LLVMExpressionNode imageBase, LLVMExpressionNode catchType, LLVMExpressionNode exceptionSlot, LLVMExpressionNode stackPointer) {
            return new CatchPadEntryNodeGen(exceptionType, attributes, stack, thrownObject, throwInfo, imageBase, catchType, exceptionSlot, stackPointer);
        }

    }
}
