// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMLandingpadNode#doLandingpad}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMLandingpadNode.class)
@SuppressWarnings("javadoc")
public final class LLVMLandingpadNodeGen extends LLVMLandingpadNode implements GenerateAOT.Provider {

    private LLVMLandingpadNodeGen(LLVMExpressionNode getStack, LLVMExpressionNode allocateLandingPadValue, int exceptionSlot, boolean cleanup, LandingpadEntryNode[] entries) {
        super(getStack, allocateLandingPadValue, exceptionSlot, cleanup, entries);
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        return doLandingpad(frameValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        {
        }
    }

    @NeverDefault
    public static LLVMLandingpadNode create(LLVMExpressionNode getStack, LLVMExpressionNode allocateLandingPadValue, int exceptionSlot, boolean cleanup, LandingpadEntryNode[] entries) {
        return new LLVMLandingpadNodeGen(getStack, allocateLandingPadValue, exceptionSlot, cleanup, entries);
    }

    /**
     * Debug Info: <pre>
     *   Specialization {@link LandingpadCatchEntryNode#getIdentifier}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LandingpadCatchEntryNode.class)
    @SuppressWarnings("javadoc")
    static final class LandingpadCatchEntryNodeGen extends LandingpadCatchEntryNode implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode stack_;
        @Child private LLVMExpressionNode unwindHeader_;
        @Child private LLVMExpressionNode catchType_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LandingpadCatchEntryNode#getIdentifier}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LandingpadCatchEntryNodeGen(LLVMExpressionNode stack, LLVMExpressionNode unwindHeader, LLVMExpressionNode catchType) {
            this.stack_ = stack;
            this.unwindHeader_ = unwindHeader;
            this.catchType_ = catchType;
        }

        @Override
        public int execute(VirtualFrame frameValue, LLVMStack stackValue, LLVMPointer unwindHeaderValue) {
            int state_0 = this.state_0_;
            Object catchTypeValue_ = this.catchType_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(stackValue, unwindHeaderValue, catchTypeValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMLandingpadNode.LandingpadCatchEntryNode.getIdentifier(LLVMStack, LLVMPointer, LLVMPointer)] */ && LLVMTypes.isPointer(catchTypeValue_)) {
                LLVMPointer catchTypeValue__ = LLVMTypes.asPointer(catchTypeValue_);
                return getIdentifier(stackValue, unwindHeaderValue, catchTypeValue__);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(stackValue, unwindHeaderValue, catchTypeValue_);
        }

        private int executeAndSpecialize(Object stackValue, Object unwindHeaderValue, Object catchTypeValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (stackValue instanceof LLVMStack) {
                LLVMStack stackValue_ = (LLVMStack) stackValue;
                if (LLVMTypes.isPointer(unwindHeaderValue)) {
                    LLVMPointer unwindHeaderValue_ = LLVMTypes.asPointer(unwindHeaderValue);
                    if (LLVMTypes.isPointer(catchTypeValue)) {
                        LLVMPointer catchTypeValue_ = LLVMTypes.asPointer(catchTypeValue);
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMLandingpadNode.LandingpadCatchEntryNode.getIdentifier(LLVMStack, LLVMPointer, LLVMPointer)] */;
                        this.state_0_ = state_0;
                        return getIdentifier(stackValue_, unwindHeaderValue_, catchTypeValue_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.stack_, this.unwindHeader_, this.catchType_}, stackValue, unwindHeaderValue, catchTypeValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMLandingpadNode.LandingpadCatchEntryNode.getIdentifier(LLVMStack, LLVMPointer, LLVMPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LandingpadCatchEntryNode create(LLVMExpressionNode stack, LLVMExpressionNode unwindHeader, LLVMExpressionNode catchType) {
            return new LandingpadCatchEntryNodeGen(stack, unwindHeader, catchType);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LandingpadFilterEntryNode#getIdentifier}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(LandingpadFilterEntryNode.class)
    @SuppressWarnings("javadoc")
    public static final class LandingpadFilterEntryNodeGen extends LandingpadFilterEntryNode implements GenerateAOT.Provider {

        private LandingpadFilterEntryNodeGen(LLVMExpressionNode[] filterTypes) {
            super(filterTypes);
        }

        @Override
        public int execute(VirtualFrame frameValue, LLVMStack arg0Value, LLVMPointer arg1Value) {
            return getIdentifier(frameValue, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            {
            }
        }

        @NeverDefault
        public static LandingpadFilterEntryNode create(LLVMExpressionNode[] filterTypes) {
            return new LandingpadFilterEntryNodeGen(filterTypes);
        }

    }
}
