// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPrepareArgumentNode#doPointer}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMPrepareArgumentNode#doOther}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPrepareArgumentNode.class)
@SuppressWarnings("javadoc")
final class LLVMPrepareArgumentNodeGen extends LLVMPrepareArgumentNode implements GenerateAOT.Provider {

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPrepareArgumentNode#doPointer}
     *   2: SpecializationActive {@link LLVMPrepareArgumentNode#doOther}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMPrepareArgumentNodeGen() {
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPrepareArgumentNode.doPointer(LLVMPointer)] */) && LLVMTypes.isPointer(arg0Value)) {
            return false;
        }
        return true;
    }

    @Override
    protected Object executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPrepareArgumentNode.doPointer(LLVMPointer)] || SpecializationActive[LLVMPrepareArgumentNode.doOther(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPrepareArgumentNode.doPointer(LLVMPointer)] */ && LLVMTypes.isPointer(arg0Value)) {
                LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
                return doPointer(arg0Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPrepareArgumentNode.doOther(Object)] */) {
                if (fallbackGuard_(state_0, arg0Value)) {
                    return doOther(arg0Value);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    private Object executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(arg0Value)) {
            LLVMPointer arg0Value_ = LLVMTypes.asPointer(arg0Value);
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPrepareArgumentNode.doPointer(LLVMPointer)] */;
            this.state_0_ = state_0;
            return doPointer(arg0Value_);
        }
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPrepareArgumentNode.doOther(Object)] */;
        this.state_0_ = state_0;
        return doOther(arg0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPrepareArgumentNode.doPointer(LLVMPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPrepareArgumentNode.doOther(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPrepareArgumentNode create() {
        return new LLVMPrepareArgumentNodeGen();
    }

}
