// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMExit#doOp}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMExit.class)
@SuppressWarnings("javadoc")
public final class LLVMExitNodeGen extends LLVMExit implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMExit#doOp}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMExitNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int child0Value_;
        try {
            child0Value_ = this.child0_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMExit.doOp(int)] */) {
            return doOp(child0Value_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private Object executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child0Value instanceof Integer) {
            int child0Value_ = (int) child0Value;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMExit.doOp(int)] */;
            this.state_0_ = state_0;
            return doOp(child0Value_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMExit.doOp(int)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMExit create(LLVMExpressionNode child0) {
        return new LLVMExitNodeGen(child0);
    }

}
