// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.c;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.c.LLVMSyscall.SyscallArgConverter;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMSyscall.class)
@SuppressWarnings("javadoc")
public final class LLVMSyscallFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link SyscallArgConverter#convert(long)}
     *     Activation probability: 0.27381
     *     With/without class size: 7/0 bytes
     *   Specialization {@link SyscallArgConverter#convert(int)}
     *     Activation probability: 0.23095
     *     With/without class size: 6/0 bytes
     *   Specialization {@link SyscallArgConverter#convert(short)}
     *     Activation probability: 0.18810
     *     With/without class size: 6/0 bytes
     *   Specialization {@link SyscallArgConverter#convert(byte)}
     *     Activation probability: 0.14524
     *     With/without class size: 5/0 bytes
     *   Specialization {@link SyscallArgConverter#convert(LLVMPointer)}
     *     Activation probability: 0.10238
     *     With/without class size: 5/0 bytes
     *   Specialization {@link SyscallArgConverter#convert(Object)}
     *     Activation probability: 0.05952
     *     With/without class size: 4/0 bytes
     * </pre>
     */
    @GeneratedBy(SyscallArgConverter.class)
    @SuppressWarnings("javadoc")
    static final class SyscallArgConverterNodeGen extends SyscallArgConverter implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode value_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link SyscallArgConverter#convert(long)}
         *   2: SpecializationActive {@link SyscallArgConverter#convert(int)}
         *   3: SpecializationActive {@link SyscallArgConverter#convert(short)}
         *   4: SpecializationActive {@link SyscallArgConverter#convert(byte)}
         *   5: SpecializationActive {@link SyscallArgConverter#convert(LLVMPointer)}
         *   6: SpecializationActive {@link SyscallArgConverter#convert(Object)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private SyscallArgConverterNodeGen(LLVMExpressionNode value) {
            this.value_ = value;
        }

        @SuppressWarnings("static-method")
        private boolean fallbackGuard_(int state_0, Object valueValue) {
            if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */) && valueValue instanceof Long) {
                return false;
            }
            if (!((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */) && valueValue instanceof Integer) {
                return false;
            }
            if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */) && valueValue instanceof Short) {
                return false;
            }
            if (!((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */) && valueValue instanceof Byte) {
                return false;
            }
            if (!((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] */) && LLVMTypes.isPointer(valueValue)) {
                return false;
            }
            return true;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1111100) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */)) {
                return executeGeneric_long0(state_0, frameValue);
            } else if ((state_0 & 0b1111010) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */)) {
                return executeGeneric_int1(state_0, frameValue);
            } else if ((state_0 & 0b1110110) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */)) {
                return executeGeneric_short2(state_0, frameValue);
            } else if ((state_0 & 0b1101110) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */ && ((state_0 & 0b1111110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */)) {
                return executeGeneric_byte3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_long0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long valueValue_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(valueValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_int1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(valueValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_short2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short valueValue_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(valueValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_byte3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(valueValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(valueValue_);
            }
            if ((state_0 & 0b1111110) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */ && valueValue_ instanceof Long) {
                    long valueValue__ = (long) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */ && valueValue_ instanceof Integer) {
                    int valueValue__ = (int) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */ && valueValue_ instanceof Short) {
                    short valueValue__ = (short) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */ && valueValue_ instanceof Byte) {
                    byte valueValue__ = (byte) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] */ && LLVMTypes.isPointer(valueValue_)) {
                    LLVMPointer valueValue__ = LLVMTypes.asPointer(valueValue_);
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */) {
                    if (fallbackGuard_(state_0, valueValue_)) {
                        return SyscallArgConverter.convert(valueValue_);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(valueValue_);
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */) {
                return LLVMTypesGen.expectLong(executeGeneric(frameValue));
            }
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */)) {
                return executeI64_long5(state_0, frameValue);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */)) {
                return executeI64_int6(state_0, frameValue);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */)) {
                return executeI64_short7(state_0, frameValue);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] && SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */)) {
                return executeI64_byte8(state_0, frameValue);
            } else {
                return executeI64_generic9(state_0, frameValue);
            }
        }

        private long executeI64_long5(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            long valueValue_;
            try {
                valueValue_ = this.value_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(valueValue_));
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_int6(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            int valueValue_;
            try {
                valueValue_ = this.value_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(valueValue_));
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_short7(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            short valueValue_;
            try {
                valueValue_ = this.value_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(valueValue_));
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_byte8(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            byte valueValue_;
            try {
                valueValue_ = this.value_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(valueValue_));
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */;
            return SyscallArgConverter.convert(valueValue_);
        }

        private long executeI64_generic9(int state_0__, VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = state_0__;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(valueValue_));
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] || SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */ && valueValue_ instanceof Long) {
                    long valueValue__ = (long) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */ && valueValue_ instanceof Integer) {
                    int valueValue__ = (int) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */ && valueValue_ instanceof Short) {
                    short valueValue__ = (short) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */ && valueValue_ instanceof Byte) {
                    byte valueValue__ = (byte) valueValue_;
                    return SyscallArgConverter.convert(valueValue__);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(valueValue_));
        }

        private Object executeAndSpecialize(Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (valueValue instanceof Long) {
                long valueValue_ = (long) valueValue;
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */;
                this.state_0_ = state_0;
                return SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Integer) {
                int valueValue_ = (int) valueValue;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */;
                this.state_0_ = state_0;
                return SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Short) {
                short valueValue_ = (short) valueValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */;
                this.state_0_ = state_0;
                return SyscallArgConverter.convert(valueValue_);
            }
            if (valueValue instanceof Byte) {
                byte valueValue_ = (byte) valueValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */;
                this.state_0_ = state_0;
                return SyscallArgConverter.convert(valueValue_);
            }
            if (LLVMTypes.isPointer(valueValue)) {
                LLVMPointer valueValue_ = LLVMTypes.asPointer(valueValue);
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] */;
                this.state_0_ = state_0;
                return SyscallArgConverter.convert(valueValue_);
            }
            state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */;
            this.state_0_ = state_0;
            return SyscallArgConverter.convert(valueValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(long)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(LLVMPointer)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMSyscall.SyscallArgConverter.convert(Object)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static SyscallArgConverter create(LLVMExpressionNode value) {
            return new SyscallArgConverterNodeGen(value);
        }

    }
}
