// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.handles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link GraalVMResolveFunction#doNativeResolve}
 *     Activation probability: 0.38500
 *     With/without class size: 10/4 bytes
 *   Specialization {@link GraalVMResolveFunction#doManagedResolve}
 *     Activation probability: 0.29500
 *     With/without class size: 7/0 bytes
 *   Specialization {@link GraalVMResolveFunction#doNativePointerResolve}
 *     Activation probability: 0.20500
 *     With/without class size: 6/0 bytes
 *   Specialization {@link GraalVMResolveFunction#doError}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(GraalVMResolveFunction.class)
@SuppressWarnings("javadoc")
public final class GraalVMResolveFunctionNodeGen extends GraalVMResolveFunction implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link GraalVMResolveFunction#doNativeResolve}
     *   2: SpecializationActive {@link GraalVMResolveFunction#doManagedResolve}
     *   3: SpecializationActive {@link GraalVMResolveFunction#doNativePointerResolve}
     *   4: SpecializationActive {@link GraalVMResolveFunction#doError}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link GraalVMResolveFunction#doNativeResolve}
     *   Parameter: {@link ConditionProfile} isFunction</pre>
     */
    @CompilationFinal private ConditionProfile nativeResolve_isFunction_;

    private GraalVMResolveFunctionNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object child0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMResolveFunction.doNativeResolve(LLVMNativePointer, ConditionProfile)] */) && LLVMTypes.isNativePointer(child0Value)) {
            return false;
        }
        if (LLVMTypes.isManagedPointer(child0Value)) {
            LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
            if ((pointsToFunctionDescriptor(child0Value_))) {
                return false;
            }
        }
        if (LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            if ((pointsToLong(child0Value_))) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[GraalVMResolveFunction.doNativeResolve(LLVMNativePointer, ConditionProfile)] || SpecializationActive[GraalVMResolveFunction.doManagedResolve(LLVMManagedPointer)] || SpecializationActive[GraalVMResolveFunction.doNativePointerResolve(LLVMPointer)] || SpecializationActive[GraalVMResolveFunction.doError(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[GraalVMResolveFunction.doNativeResolve(LLVMNativePointer, ConditionProfile)] */ && LLVMTypes.isNativePointer(child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypes.asNativePointer(child0Value_);
                {
                    ConditionProfile isFunction__ = this.nativeResolve_isFunction_;
                    if (isFunction__ != null) {
                        return doNativeResolve(child0Value__, isFunction__);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[GraalVMResolveFunction.doManagedResolve(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(child0Value_)) {
                LLVMManagedPointer child0Value__ = LLVMTypes.asManagedPointer(child0Value_);
                if ((pointsToFunctionDescriptor(child0Value__))) {
                    return doManagedResolve(child0Value__);
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[GraalVMResolveFunction.doNativePointerResolve(LLVMPointer)] */ && LLVMTypes.isPointer(child0Value_)) {
                LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
                if ((pointsToLong(child0Value__))) {
                    return doNativePointerResolve(child0Value__);
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[GraalVMResolveFunction.doError(Object)] */) {
                if (fallbackGuard_(state_0, child0Value_)) {
                    return doError(child0Value_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private Object executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(child0Value)) {
            LLVMNativePointer child0Value_ = LLVMTypes.asNativePointer(child0Value);
            ConditionProfile isFunction__ = (ConditionProfile.create());
            Objects.requireNonNull(isFunction__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.nativeResolve_isFunction_ = isFunction__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[GraalVMResolveFunction.doNativeResolve(LLVMNativePointer, ConditionProfile)] */;
            this.state_0_ = state_0;
            return doNativeResolve(child0Value_, isFunction__);
        }
        if (LLVMTypes.isManagedPointer(child0Value)) {
            LLVMManagedPointer child0Value_ = LLVMTypes.asManagedPointer(child0Value);
            if ((pointsToFunctionDescriptor(child0Value_))) {
                state_0 = state_0 | 0b100 /* add SpecializationActive[GraalVMResolveFunction.doManagedResolve(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doManagedResolve(child0Value_);
            }
        }
        if (LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            if ((pointsToLong(child0Value_))) {
                state_0 = state_0 | 0b1000 /* add SpecializationActive[GraalVMResolveFunction.doNativePointerResolve(LLVMPointer)] */;
                this.state_0_ = state_0;
                return doNativePointerResolve(child0Value_);
            }
        }
        state_0 = state_0 | 0b10000 /* add SpecializationActive[GraalVMResolveFunction.doError(Object)] */;
        this.state_0_ = state_0;
        return doError(child0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            ConditionProfile isFunction__ = (ConditionProfile.create());
            Objects.requireNonNull(isFunction__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.nativeResolve_isFunction_ = isFunction__;
            this.nativeResolve_isFunction_.disable();
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[GraalVMResolveFunction.doNativeResolve(LLVMNativePointer, ConditionProfile)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[GraalVMResolveFunction.doManagedResolve(LLVMManagedPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[GraalVMResolveFunction.doNativePointerResolve(LLVMPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[GraalVMResolveFunction.doError(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.nativeResolve_isFunction_.reset();
    }

    @NeverDefault
    public static GraalVMResolveFunction create(LLVMExpressionNode child0) {
        return new GraalVMResolveFunctionNodeGen(child0);
    }

}
