// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMTruffleManagedMalloc#doIntrinsic}
 *     Activation probability: 1.00000
 *     With/without class size: 20/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMTruffleManagedMalloc.class)
@SuppressWarnings("javadoc")
public final class LLVMTruffleManagedMallocNodeGen extends LLVMTruffleManagedMalloc implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMTruffleManagedMalloc#doIntrinsic}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMTruffleManagedMalloc#doIntrinsic}
     *   Parameter: {@link BranchProfile} exception</pre>
     */
    @CompilationFinal private BranchProfile exception_;

    private LLVMTruffleManagedMallocNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        long child0Value_;
        try {
            child0Value_ = this.child0_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTruffleManagedMalloc.doIntrinsic(long, BranchProfile)] */) {
            {
                BranchProfile exception__ = this.exception_;
                if (exception__ != null) {
                    return doIntrinsic(child0Value_, exception__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private Object executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child0Value instanceof Long) {
            long child0Value_ = (long) child0Value;
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.exception_ = exception__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTruffleManagedMalloc.doIntrinsic(long, BranchProfile)] */;
            this.state_0_ = state_0;
            return doIntrinsic(child0Value_, exception__);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_}, child0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            BranchProfile exception__ = (BranchProfile.create());
            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.exception_ = exception__;
            this.exception_.disable();
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTruffleManagedMalloc.doIntrinsic(long, BranchProfile)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.exception_.reset();
    }

    @NeverDefault
    public static LLVMTruffleManagedMalloc create(LLVMExpressionNode child0) {
        return new LLVMTruffleManagedMallocNodeGen(child0);
    }

}
