// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop.typed;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMTypeIDNode#doGlobal}
 *     Activation probability: 0.65000
 *     With/without class size: 14/4 bytes
 *   Specialization {@link LLVMTypeIDNode#fallback}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMTypeIDNode.class)
@SuppressWarnings("javadoc")
public final class LLVMTypeIDNodeGen extends LLVMTypeIDNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMTypeIDNode#doGlobal}
     *   2: SpecializationActive {@link LLVMTypeIDNode#fallback}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMTypeIDNode#doGlobal}
     *   Parameter: {@link BranchProfile} wrongType</pre>
     */
    @CompilationFinal private BranchProfile global_wrongType_;

    private LLVMTypeIDNodeGen(LLVMExpressionNode child0) {
        this.child0_ = child0;
    }

    @SuppressWarnings("static-method")
    private boolean fallbackGuard_(int state_0, Object child0Value) {
        if (!((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTypeIDNode.doGlobal(LLVMPointer, BranchProfile)] */) && LLVMTypes.isPointer(child0Value)) {
            return false;
        }
        return true;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMTypeIDNode.doGlobal(LLVMPointer, BranchProfile)] || SpecializationActive[LLVMTypeIDNode.fallback(Object)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMTypeIDNode.doGlobal(LLVMPointer, BranchProfile)] */ && LLVMTypes.isPointer(child0Value_)) {
                LLVMPointer child0Value__ = LLVMTypes.asPointer(child0Value_);
                {
                    BranchProfile wrongType__ = this.global_wrongType_;
                    if (wrongType__ != null) {
                        return doGlobal(child0Value__, wrongType__);
                    }
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMTypeIDNode.fallback(Object)] */) {
                if (fallbackGuard_(state_0, child0Value_)) {
                    return fallback(child0Value_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_);
    }

    private LLVMInteropType executeAndSpecialize(Object child0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(child0Value)) {
            LLVMPointer child0Value_ = LLVMTypes.asPointer(child0Value);
            BranchProfile wrongType__ = (BranchProfile.create());
            Objects.requireNonNull(wrongType__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.global_wrongType_ = wrongType__;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMTypeIDNode.doGlobal(LLVMPointer, BranchProfile)] */;
            this.state_0_ = state_0;
            return doGlobal(child0Value_, wrongType__);
        }
        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMTypeIDNode.fallback(Object)] */;
        this.state_0_ = state_0;
        return fallback(child0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            BranchProfile wrongType__ = (BranchProfile.create());
            Objects.requireNonNull(wrongType__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.global_wrongType_ = wrongType__;
            this.global_wrongType_.disable();
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMTypeIDNode.doGlobal(LLVMPointer, BranchProfile)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMTypeIDNode.fallback(Object)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.global_wrongType_.reset();
    }

    @NeverDefault
    public static LLVMTypeIDNode create(LLVMExpressionNode child0) {
        return new LLVMTypeIDNodeGen(child0);
    }

}
