// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemMoveNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToNativeNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMMemCopy#doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)}
 *     Activation probability: 0.48333
 *     With/without class size: 9/0 bytes
 *   Specialization {@link LLVMMemCopy#doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)}
 *     Activation probability: 0.33333
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMMemCopy#doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)}
 *     Activation probability: 0.18333
 *     With/without class size: 7/4 bytes
 * </pre>
 */
@GeneratedBy(LLVMMemCopy.class)
@SuppressWarnings("javadoc")
public final class LLVMMemCopyNodeGen extends LLVMMemCopy implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode destination_;
    @Child private LLVMExpressionNode source_;
    @Child private LLVMExpressionNode length_;
    @Child private LLVMExpressionNode isVolatile_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMMemCopy#doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)}
     *   2: SpecializationActive {@link LLVMMemCopy#doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)}
     *   3: SpecializationActive {@link LLVMMemCopy#doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMMemCopy#doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)}
     *   Parameter: {@link LLVMToNativeNode} toNative</pre>
     */
    @Child private LLVMToNativeNode void2_toNative_;

    private LLVMMemCopyNodeGen(LLVMMemMoveNode memMove, LLVMExpressionNode destination, LLVMExpressionNode source, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        super(memMove);
        this.destination_ = destination;
        this.source_ = source;
        this.length_ = length;
        this.isVolatile_ = isVolatile;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object destinationValue_ = this.destination_.executeGeneric(frameValue);
        Object sourceValue_ = this.source_.executeGeneric(frameValue);
        if ((state_0 & 0b1100) == 0 /* only-active SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] && SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] && SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */)) {
            return executeGeneric_int_boolean0(state_0, frameValue, destinationValue_, sourceValue_);
        } else if ((state_0 & 0b1010) == 0 /* only-active SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] && SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] && SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */)) {
            return executeGeneric_long_boolean1(state_0, frameValue, destinationValue_, sourceValue_);
        } else if ((state_0 & 0b110) == 0 /* only-active SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */ && ((state_0 & 0b1110) != 0  /* is-not SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] && SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] && SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */)) {
            return executeGeneric_boolean2(state_0, frameValue, destinationValue_, sourceValue_);
        } else {
            return executeGeneric_generic3(state_0, frameValue, destinationValue_, sourceValue_);
        }
    }

    private Object executeGeneric_int_boolean0(int state_0__, VirtualFrame frameValue, Object destinationValue_, Object sourceValue_) {
        int state_0 = state_0__;
        int lengthValue_;
        try {
            lengthValue_ = this.length_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, ex.getResult(), isVolatileValue);
        }
        boolean isVolatileValue_;
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] */;
        if (LLVMTypes.isPointer(destinationValue_)) {
            LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
            if (LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                return doVoid(frameValue, destinationValue__, sourceValue__, lengthValue_, isVolatileValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_long_boolean1(int state_0__, VirtualFrame frameValue, Object destinationValue_, Object sourceValue_) {
        int state_0 = state_0__;
        long lengthValue_;
        try {
            lengthValue_ = this.length_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, ex.getResult(), isVolatileValue);
        }
        boolean isVolatileValue_;
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] */;
        if (LLVMTypes.isPointer(destinationValue_)) {
            LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
            if (LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                return doVoid(frameValue, destinationValue__, sourceValue__, lengthValue_, isVolatileValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_boolean2(int state_0__, VirtualFrame frameValue, Object destinationValue_, Object sourceValue_) {
        int state_0 = state_0__;
        Object lengthValue_ = this.length_.executeGeneric(frameValue);
        boolean isVolatileValue_;
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */;
        if (LLVMTypes.isPointer(destinationValue_)) {
            LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
            if (LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                if (LLVMTypes.isPointer(lengthValue_)) {
                    LLVMPointer lengthValue__ = LLVMTypes.asPointer(lengthValue_);
                    {
                        LLVMToNativeNode toNative__ = this.void2_toNative_;
                        if (toNative__ != null) {
                            return doVoid(frameValue, destinationValue__, sourceValue__, lengthValue__, isVolatileValue_, toNative__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_generic3(int state_0__, VirtualFrame frameValue, Object destinationValue_, Object sourceValue_) {
        int state_0 = state_0__;
        Object lengthValue_ = this.length_.executeGeneric(frameValue);
        boolean isVolatileValue_;
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
        }
        if ((state_0 & 0b1110) != 0 /* is SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] || SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] || SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */ && LLVMTypes.isPointer(destinationValue_)) {
            LLVMPointer destinationValue__ = LLVMTypes.asPointer(destinationValue_);
            if (LLVMTypes.isPointer(sourceValue_)) {
                LLVMPointer sourceValue__ = LLVMTypes.asPointer(sourceValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] */ && lengthValue_ instanceof Integer) {
                    int lengthValue__ = (int) lengthValue_;
                    return doVoid(frameValue, destinationValue__, sourceValue__, lengthValue__, isVolatileValue_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] */ && lengthValue_ instanceof Long) {
                    long lengthValue__ = (long) lengthValue_;
                    return doVoid(frameValue, destinationValue__, sourceValue__, lengthValue__, isVolatileValue_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */ && LLVMTypes.isPointer(lengthValue_)) {
                    LLVMPointer lengthValue__ = LLVMTypes.asPointer(lengthValue_);
                    {
                        LLVMToNativeNode toNative__ = this.void2_toNative_;
                        if (toNative__ != null) {
                            return doVoid(frameValue, destinationValue__, sourceValue__, lengthValue__, isVolatileValue_, toNative__);
                        }
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object destinationValue, Object sourceValue, Object lengthValue, Object isVolatileValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(destinationValue)) {
            LLVMPointer destinationValue_ = LLVMTypes.asPointer(destinationValue);
            if (LLVMTypes.isPointer(sourceValue)) {
                LLVMPointer sourceValue_ = LLVMTypes.asPointer(sourceValue);
                if (isVolatileValue instanceof Boolean) {
                    boolean isVolatileValue_ = (boolean) isVolatileValue;
                    if (lengthValue instanceof Integer) {
                        int lengthValue_ = (int) lengthValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] */;
                        this.state_0_ = state_0;
                        return doVoid(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
                    }
                    if (lengthValue instanceof Long) {
                        long lengthValue_ = (long) lengthValue;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] */;
                        this.state_0_ = state_0;
                        return doVoid(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_);
                    }
                    if (LLVMTypes.isPointer(lengthValue)) {
                        LLVMPointer lengthValue_ = LLVMTypes.asPointer(lengthValue);
                        LLVMToNativeNode toNative__ = this.insert((LLVMToNativeNodeGen.create()));
                        Objects.requireNonNull(toNative__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        VarHandle.storeStoreFence();
                        this.void2_toNative_ = toNative__;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */;
                        this.state_0_ = state_0;
                        return doVoid(frameValue, destinationValue_, sourceValue_, lengthValue_, isVolatileValue_, toNative__);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.destination_, this.source_, this.length_, this.isVolatile_}, destinationValue, sourceValue, lengthValue, isVolatileValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, int, boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, long, boolean)] */;
        }
        {
            LLVMToNativeNode toNative__ = this.insert((LLVMToNativeNodeGen.create()));
            Objects.requireNonNull(toNative__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.void2_toNative_ = toNative__;
            assert NodeUtil.assertRecursion(this.void2_toNative_, 1);
            ((GenerateAOT.Provider) this.void2_toNative_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMMemCopy.doVoid(VirtualFrame, LLVMPointer, LLVMPointer, LLVMPointer, boolean, LLVMToNativeNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.void2_toNative_ = null;
    }

    @NeverDefault
    public static LLVMMemCopy create(LLVMMemMoveNode memMove, LLVMExpressionNode destination, LLVMExpressionNode source, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        return new LLVMMemCopyNodeGen(memMove, destination, source, length, isVolatile);
    }

}
