// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.memory.LLVMMemSetNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMMemSet#doOp(LLVMPointer, byte, int, boolean)}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMMemSet#doOp(LLVMPointer, byte, long, boolean)}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMMemSet.class)
@SuppressWarnings("javadoc")
public final class LLVMMemSetNodeGen extends LLVMMemSet implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    @Child private LLVMExpressionNode length_;
    @Child private LLVMExpressionNode isVolatile_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMMemSet#doOp(LLVMPointer, byte, int, boolean)}
     *   2: SpecializationActive {@link LLVMMemSet#doOp(LLVMPointer, byte, long, boolean)}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMMemSetNodeGen(LLVMMemSetNode memSet, LLVMExpressionNode address, LLVMExpressionNode value, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        super(memSet);
        this.address_ = address;
        this.value_ = value;
        this.length_ = length;
        this.isVolatile_ = isVolatile;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        byte valueValue_;
        try {
            valueValue_ = this.value_.executeI8(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object lengthValue = this.length_.executeGeneric(frameValue);
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return executeAndSpecialize(addressValue_, ex.getResult(), lengthValue, isVolatileValue);
        }
        if ((state_0 & 0b100) == 0 /* only-active SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] && SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */)) {
            return executeGeneric_int_boolean0(state_0, frameValue, addressValue_, valueValue_);
        } else if ((state_0 & 0b10) == 0 /* only-active SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */ && ((state_0 & 0b110) != 0  /* is-not SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] && SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */)) {
            return executeGeneric_long_boolean1(state_0, frameValue, addressValue_, valueValue_);
        } else {
            return executeGeneric_generic2(state_0, frameValue, addressValue_, valueValue_);
        }
    }

    private Object executeGeneric_int_boolean0(int state_0__, VirtualFrame frameValue, Object addressValue_, byte valueValue_) {
        int state_0 = state_0__;
        int lengthValue_;
        try {
            lengthValue_ = this.length_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return executeAndSpecialize(addressValue_, valueValue_, ex.getResult(), isVolatileValue);
        }
        boolean isVolatileValue_;
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
        }
        assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] */;
        if (LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return doOp(addressValue__, valueValue_, lengthValue_, isVolatileValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_long_boolean1(int state_0__, VirtualFrame frameValue, Object addressValue_, byte valueValue_) {
        int state_0 = state_0__;
        long lengthValue_;
        try {
            lengthValue_ = this.length_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object isVolatileValue = this.isVolatile_.executeGeneric(frameValue);
            return executeAndSpecialize(addressValue_, valueValue_, ex.getResult(), isVolatileValue);
        }
        boolean isVolatileValue_;
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
        }
        assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */;
        if (LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            return doOp(addressValue__, valueValue_, lengthValue_, isVolatileValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue, Object addressValue_, byte valueValue_) {
        int state_0 = state_0__;
        Object lengthValue_ = this.length_.executeGeneric(frameValue);
        boolean isVolatileValue_;
        try {
            isVolatileValue_ = this.isVolatile_.executeI1(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] || SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */ && LLVMTypes.isPointer(addressValue_)) {
            LLVMPointer addressValue__ = LLVMTypes.asPointer(addressValue_);
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] */ && lengthValue_ instanceof Integer) {
                int lengthValue__ = (int) lengthValue_;
                return doOp(addressValue__, valueValue_, lengthValue__, isVolatileValue_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */ && lengthValue_ instanceof Long) {
                long lengthValue__ = (long) lengthValue_;
                return doOp(addressValue__, valueValue_, lengthValue__, isVolatileValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
    }

    private Object executeAndSpecialize(Object addressValue, Object valueValue, Object lengthValue, Object isVolatileValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isPointer(addressValue)) {
            LLVMPointer addressValue_ = LLVMTypes.asPointer(addressValue);
            if (valueValue instanceof Byte) {
                byte valueValue_ = (byte) valueValue;
                if (isVolatileValue instanceof Boolean) {
                    boolean isVolatileValue_ = (boolean) isVolatileValue;
                    if (lengthValue instanceof Integer) {
                        int lengthValue_ = (int) lengthValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] */;
                        this.state_0_ = state_0;
                        return doOp(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
                    }
                    if (lengthValue instanceof Long) {
                        long lengthValue_ = (long) lengthValue;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */;
                        this.state_0_ = state_0;
                        return doOp(addressValue_, valueValue_, lengthValue_, isVolatileValue_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_, this.length_, this.isVolatile_}, addressValue, valueValue, lengthValue, isVolatileValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, int, boolean)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMMemSet.doOp(LLVMPointer, byte, long, boolean)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMMemSet create(LLVMMemSetNode memSet, LLVMExpressionNode address, LLVMExpressionNode value, LLVMExpressionNode length, LLVMExpressionNode isVolatile) {
        return new LLVMMemSetNodeGen(memSet, address, value, length, isVolatile);
    }

}
