// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMReturnAddress#doPointee}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMReturnAddress.class)
@SuppressWarnings("javadoc")
public final class LLVMReturnAddressNodeGen extends LLVMReturnAddress implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode val_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMReturnAddress#doPointee}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMReturnAddressNodeGen(LLVMExpressionNode val) {
        this.val_ = val;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        int valValue_;
        try {
            valValue_ = this.val_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(valValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMReturnAddress.doPointee(int)] */) {
            return doPointee(valValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(valValue_);
    }

    private LLVMNativePointer executeAndSpecialize(Object valValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (valValue instanceof Integer) {
            int valValue_ = (int) valValue;
            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMReturnAddress.doPointee(int)] */;
            this.state_0_ = state_0;
            return doPointee(valValue_);
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.val_}, valValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMReturnAddress.doPointee(int)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMReturnAddress create(LLVMExpressionNode val) {
        return new LLVMReturnAddressNodeGen(val);
    }

}
