// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic.Arithmetic;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic.CarryArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic.GCCArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic.LLVMArithmeticWithOverflow;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic.LLVMSimpleArithmeticPrimitive;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith.LLVMArithmetic.SaturatingArithmetic;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI16StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI32StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI64StoreNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMI8StoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.VarHandle;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMArithmetic.class)
@SuppressWarnings("javadoc")
public final class LLVMArithmeticFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link GCCArithmetic#doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)}
     *     Activation probability: 0.38500
     *     With/without class size: 11/4 bytes
     *   Specialization {@link GCCArithmetic#doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)}
     *     Activation probability: 0.29500
     *     With/without class size: 9/4 bytes
     *   Specialization {@link GCCArithmetic#doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link GCCArithmetic#doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)}
     *     Activation probability: 0.11500
     *     With/without class size: 6/4 bytes
     * </pre>
     */
    @GeneratedBy(GCCArithmetic.class)
    @SuppressWarnings("javadoc")
    public static final class GCCArithmeticNodeGen extends GCCArithmetic implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode target_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link GCCArithmetic#doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)}
         *   2: SpecializationActive {@link GCCArithmetic#doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)}
         *   3: SpecializationActive {@link GCCArithmetic#doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)}
         *   4: SpecializationActive {@link GCCArithmetic#doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private Intrinsic0Data intrinsic0_cache;
        @Child private Intrinsic1Data intrinsic1_cache;
        @Child private Intrinsic2Data intrinsic2_cache;
        @Child private Intrinsic3Data intrinsic3_cache;

        private GCCArithmeticNodeGen(Arithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
            this.target_ = target;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_byte_byte0(state_0, frameValue);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_short_short1(state_0, frameValue);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_int_int2(state_0, frameValue);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_long_long3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_byte_byte0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_short_short1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_int_int2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_long_long3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] || SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] || SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] || SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */ && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && leftValue_ instanceof Byte) {
                    byte leftValue__ = (byte) leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte rightValue__ = (byte) rightValue_;
                        Intrinsic0Data s0_ = this.intrinsic0_cache;
                        if (s0_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s0_.store_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */ && leftValue_ instanceof Short) {
                    short leftValue__ = (short) leftValue_;
                    if (rightValue_ instanceof Short) {
                        short rightValue__ = (short) rightValue_;
                        Intrinsic1Data s1_ = this.intrinsic1_cache;
                        if (s1_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s1_.store_);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */ && leftValue_ instanceof Integer) {
                    int leftValue__ = (int) leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int rightValue__ = (int) rightValue_;
                        Intrinsic2Data s2_ = this.intrinsic2_cache;
                        if (s2_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s2_.store_);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */ && leftValue_ instanceof Long) {
                    long leftValue__ = (long) leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (long) rightValue_;
                        Intrinsic3Data s3_ = this.intrinsic3_cache;
                        if (s3_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s3_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */ && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */ && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(executeAndSpecialize(ex.getResult(), rightValue, targetValue));
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, ex.getResult(), targetValue));
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */ && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, rightValue_, targetValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object targetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(targetValue)) {
                LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                if (leftValue instanceof Byte) {
                    byte leftValue_ = (byte) leftValue;
                    if (rightValue instanceof Byte) {
                        byte rightValue_ = (byte) rightValue;
                        Intrinsic0Data s0_ = this.insert(new Intrinsic0Data());
                        s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic0_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s0_.store_);
                    }
                }
                if (leftValue instanceof Short) {
                    short leftValue_ = (short) leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (short) rightValue;
                        Intrinsic1Data s1_ = this.insert(new Intrinsic1Data());
                        s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic1_cache = s1_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s1_.store_);
                    }
                }
                if (leftValue instanceof Integer) {
                    int leftValue_ = (int) leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (int) rightValue;
                        Intrinsic2Data s2_ = this.insert(new Intrinsic2Data());
                        s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic2_cache = s2_;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s2_.store_);
                    }
                }
                if (leftValue instanceof Long) {
                    long leftValue_ = (long) leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (long) rightValue;
                        Intrinsic3Data s3_ = this.insert(new Intrinsic3Data());
                        s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic3_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s3_.store_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.target_}, leftValue, rightValue, targetValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                Intrinsic0Data s0_ = this.insert(new Intrinsic0Data());
                s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic0_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.store_, 1);
                ((GenerateAOT.Provider) s0_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
            }
            {
                Intrinsic1Data s1_ = this.insert(new Intrinsic1Data());
                s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic1_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */;
            }
            {
                Intrinsic2Data s2_ = this.insert(new Intrinsic2Data());
                s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic2_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.store_, 1);
                ((GenerateAOT.Provider) s2_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */;
            }
            {
                Intrinsic3Data s3_ = this.insert(new Intrinsic3Data());
                s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic3_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.store_, 1);
                ((GenerateAOT.Provider) s3_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMArithmetic.GCCArithmetic.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic0_cache = null;
            this.intrinsic1_cache = null;
            this.intrinsic2_cache = null;
            this.intrinsic3_cache = null;
        }

        @NeverDefault
        public static GCCArithmetic create(Arithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            return new GCCArithmeticNodeGen(arithmetic, left, right, target);
        }

        @GeneratedBy(GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic0Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link GCCArithmetic#doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)}
             *   Parameter: {@link LLVMI8StoreNode} store</pre>
             */
            @Child LLVMI8StoreNode store_;

            Intrinsic0Data() {
            }

        }
        @GeneratedBy(GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link GCCArithmetic#doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)}
             *   Parameter: {@link LLVMI16StoreNode} store</pre>
             */
            @Child LLVMI16StoreNode store_;

            Intrinsic1Data() {
            }

        }
        @GeneratedBy(GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic2Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link GCCArithmetic#doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)}
             *   Parameter: {@link LLVMI32StoreNode} store</pre>
             */
            @Child LLVMI32StoreNode store_;

            Intrinsic2Data() {
            }

        }
        @GeneratedBy(GCCArithmetic.class)
        @DenyReplace
        private static final class Intrinsic3Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link GCCArithmetic#doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)}
             *   Parameter: {@link LLVMI64StoreNode} store</pre>
             */
            @Child LLVMI64StoreNode store_;

            Intrinsic3Data() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(byte, byte)}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(short, short)}
     *     Activation probability: 0.29500
     *     With/without class size: 7/0 bytes
     *   Specialization {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(int, int)}
     *     Activation probability: 0.20500
     *     With/without class size: 6/0 bytes
     *   Specialization {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(long, long)}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMSimpleArithmeticPrimitive.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMSimpleArithmeticPrimitiveNodeGen extends LLVMSimpleArithmeticPrimitive implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(byte, byte)}
         *   2: SpecializationActive {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(short, short)}
         *   3: SpecializationActive {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(int, int)}
         *   4: SpecializationActive {@link LLVMSimpleArithmeticPrimitive#doIntrinsic(long, long)}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private LLVMSimpleArithmeticPrimitiveNodeGen(SaturatingArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */)) {
                return executeGeneric_byte_byte0(state_0, frameValue);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */)) {
                return executeGeneric_short_short1(state_0, frameValue);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */)) {
                return executeGeneric_int_int2(state_0, frameValue);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] && SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */)) {
                return executeGeneric_long_long3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_byte_byte0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] */;
            return doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_short_short1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] */;
            return doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_int_int2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] */;
            return doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_long_long3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(leftValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */;
            return doIntrinsic(leftValue_, rightValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] || SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] || SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] || SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */) {
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] */ && leftValue_ instanceof Byte) {
                    byte leftValue__ = (byte) leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte rightValue__ = (byte) rightValue_;
                        return doIntrinsic(leftValue__, rightValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] */ && leftValue_ instanceof Short) {
                    short leftValue__ = (short) leftValue_;
                    if (rightValue_ instanceof Short) {
                        short rightValue__ = (short) rightValue_;
                        return doIntrinsic(leftValue__, rightValue__);
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] */ && leftValue_ instanceof Integer) {
                    int leftValue__ = (int) leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int rightValue__ = (int) rightValue_;
                        return doIntrinsic(leftValue__, rightValue__);
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */ && leftValue_ instanceof Long) {
                    long leftValue__ = (long) leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (long) rightValue_;
                        return doIntrinsic(leftValue__, rightValue__);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(executeAndSpecialize(ex.getResult(), rightValue));
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] */) {
                return doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightValue));
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] */) {
                return doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult(), rightValue));
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */) {
                return doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, rightValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(executeAndSpecialize(ex.getResult(), rightValue));
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, ex.getResult()));
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, rightValue_));
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] */) {
                return doIntrinsic(leftValue_, rightValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, rightValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (leftValue instanceof Byte) {
                byte leftValue_ = (byte) leftValue;
                if (rightValue instanceof Byte) {
                    byte rightValue_ = (byte) rightValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] */;
                    this.state_0_ = state_0;
                    return doIntrinsic(leftValue_, rightValue_);
                }
            }
            if (leftValue instanceof Short) {
                short leftValue_ = (short) leftValue;
                if (rightValue instanceof Short) {
                    short rightValue_ = (short) rightValue;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] */;
                    this.state_0_ = state_0;
                    return doIntrinsic(leftValue_, rightValue_);
                }
            }
            if (leftValue instanceof Integer) {
                int leftValue_ = (int) leftValue;
                if (rightValue instanceof Integer) {
                    int rightValue_ = (int) rightValue;
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] */;
                    this.state_0_ = state_0;
                    return doIntrinsic(leftValue_, rightValue_);
                }
            }
            if (leftValue instanceof Long) {
                long leftValue_ = (long) leftValue;
                if (rightValue instanceof Long) {
                    long rightValue_ = (long) rightValue;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */;
                    this.state_0_ = state_0;
                    return doIntrinsic(leftValue_, rightValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_}, leftValue, rightValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(byte, byte)] */;
            }
            {
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(short, short)] */;
            }
            {
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(int, int)] */;
            }
            {
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMArithmetic.LLVMSimpleArithmeticPrimitive.doIntrinsic(long, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMSimpleArithmeticPrimitive create(SaturatingArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right) {
            return new LLVMSimpleArithmeticPrimitiveNodeGen(arithmetic, left, right);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMArithmeticWithOverflow#doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)}
     *     Activation probability: 0.38500
     *     With/without class size: 11/4 bytes
     *   Specialization {@link LLVMArithmeticWithOverflow#doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)}
     *     Activation probability: 0.29500
     *     With/without class size: 9/4 bytes
     *   Specialization {@link LLVMArithmeticWithOverflow#doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMArithmeticWithOverflow#doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)}
     *     Activation probability: 0.11500
     *     With/without class size: 6/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMArithmeticWithOverflow.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMArithmeticWithOverflowNodeGen extends LLVMArithmeticWithOverflow implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode target_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMArithmeticWithOverflow#doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)}
         *   2: SpecializationActive {@link LLVMArithmeticWithOverflow#doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)}
         *   3: SpecializationActive {@link LLVMArithmeticWithOverflow#doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)}
         *   4: SpecializationActive {@link LLVMArithmeticWithOverflow#doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private Intrinsic0Data intrinsic0_cache;
        @Child private Intrinsic1Data intrinsic1_cache;
        @Child private Intrinsic2Data intrinsic2_cache;
        @Child private Intrinsic3Data intrinsic3_cache;

        private LLVMArithmeticWithOverflowNodeGen(Arithmetic arithmetic, long secondValueOffset, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            super(arithmetic, secondValueOffset);
            this.left_ = left;
            this.right_ = right;
            this.target_ = target;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_byte_byte0(state_0, frameValue);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_short_short1(state_0, frameValue);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_int_int2(state_0, frameValue);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_long_long3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_byte_byte0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_short_short1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_int_int2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_long_long3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, targetValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object targetValue = this.target_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), targetValue);
            }
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */;
            if (LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, targetValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object targetValue_ = this.target_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] || SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] || SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] || SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */ && LLVMTypes.isPointer(targetValue_)) {
                LLVMPointer targetValue__ = LLVMTypes.asPointer(targetValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && leftValue_ instanceof Byte) {
                    byte leftValue__ = (byte) leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte rightValue__ = (byte) rightValue_;
                        Intrinsic0Data s0_ = this.intrinsic0_cache;
                        if (s0_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s0_.store_);
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */ && leftValue_ instanceof Short) {
                    short leftValue__ = (short) leftValue_;
                    if (rightValue_ instanceof Short) {
                        short rightValue__ = (short) rightValue_;
                        Intrinsic1Data s1_ = this.intrinsic1_cache;
                        if (s1_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s1_.store_);
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */ && leftValue_ instanceof Integer) {
                    int leftValue__ = (int) leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int rightValue__ = (int) rightValue_;
                        Intrinsic2Data s2_ = this.intrinsic2_cache;
                        if (s2_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s2_.store_);
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */ && leftValue_ instanceof Long) {
                    long leftValue__ = (long) leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (long) rightValue_;
                        Intrinsic3Data s3_ = this.intrinsic3_cache;
                        if (s3_ != null) {
                            return doIntrinsic(leftValue__, rightValue__, targetValue__, s3_.store_);
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, targetValue_);
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object targetValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(targetValue)) {
                LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                if (leftValue instanceof Byte) {
                    byte leftValue_ = (byte) leftValue;
                    if (rightValue instanceof Byte) {
                        byte rightValue_ = (byte) rightValue;
                        Intrinsic0Data s0_ = this.insert(new Intrinsic0Data());
                        s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic0_cache = s0_;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s0_.store_);
                    }
                }
                if (leftValue instanceof Short) {
                    short leftValue_ = (short) leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (short) rightValue;
                        Intrinsic1Data s1_ = this.insert(new Intrinsic1Data());
                        s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic1_cache = s1_;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s1_.store_);
                    }
                }
                if (leftValue instanceof Integer) {
                    int leftValue_ = (int) leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (int) rightValue;
                        Intrinsic2Data s2_ = this.insert(new Intrinsic2Data());
                        s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic2_cache = s2_;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s2_.store_);
                    }
                }
                if (leftValue instanceof Long) {
                    long leftValue_ = (long) leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (long) rightValue;
                        Intrinsic3Data s3_ = this.insert(new Intrinsic3Data());
                        s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                        VarHandle.storeStoreFence();
                        this.intrinsic3_cache = s3_;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */;
                        this.state_0_ = state_0;
                        return doIntrinsic(leftValue_, rightValue_, targetValue_, s3_.store_);
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.target_}, leftValue, rightValue, targetValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                Intrinsic0Data s0_ = this.insert(new Intrinsic0Data());
                s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic0_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.store_, 1);
                ((GenerateAOT.Provider) s0_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
            }
            {
                Intrinsic1Data s1_ = this.insert(new Intrinsic1Data());
                s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic1_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)] */;
            }
            {
                Intrinsic2Data s2_ = this.insert(new Intrinsic2Data());
                s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic2_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.store_, 1);
                ((GenerateAOT.Provider) s2_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)] */;
            }
            {
                Intrinsic3Data s3_ = this.insert(new Intrinsic3Data());
                s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic3_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.store_, 1);
                ((GenerateAOT.Provider) s3_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflow.doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic0_cache = null;
            this.intrinsic1_cache = null;
            this.intrinsic2_cache = null;
            this.intrinsic3_cache = null;
        }

        @NeverDefault
        public static LLVMArithmeticWithOverflow create(Arithmetic arithmetic, long secondValueOffset, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode target) {
            return new LLVMArithmeticWithOverflowNodeGen(arithmetic, secondValueOffset, left, right, target);
        }

        @GeneratedBy(LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic0Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflow#doIntrinsic(byte, byte, LLVMPointer, LLVMI8StoreNode)}
             *   Parameter: {@link LLVMI8StoreNode} store</pre>
             */
            @Child LLVMI8StoreNode store_;

            Intrinsic0Data() {
            }

        }
        @GeneratedBy(LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflow#doIntrinsic(short, short, LLVMPointer, LLVMI16StoreNode)}
             *   Parameter: {@link LLVMI16StoreNode} store</pre>
             */
            @Child LLVMI16StoreNode store_;

            Intrinsic1Data() {
            }

        }
        @GeneratedBy(LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic2Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflow#doIntrinsic(int, int, LLVMPointer, LLVMI32StoreNode)}
             *   Parameter: {@link LLVMI32StoreNode} store</pre>
             */
            @Child LLVMI32StoreNode store_;

            Intrinsic2Data() {
            }

        }
        @GeneratedBy(LLVMArithmeticWithOverflow.class)
        @DenyReplace
        private static final class Intrinsic3Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflow#doIntrinsic(long, long, LLVMPointer, LLVMI64StoreNode)}
             *   Parameter: {@link LLVMI64StoreNode} store</pre>
             */
            @Child LLVMI64StoreNode store_;

            Intrinsic3Data() {
            }

        }
    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)}
     *     Activation probability: 0.38500
     *     With/without class size: 11/4 bytes
     *   Specialization {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)}
     *     Activation probability: 0.29500
     *     With/without class size: 9/4 bytes
     *   Specialization {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)}
     *     Activation probability: 0.11500
     *     With/without class size: 6/4 bytes
     * </pre>
     */
    @GeneratedBy(LLVMArithmeticWithOverflowAndCarry.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMArithmeticWithOverflowAndCarryNodeGen extends LLVMArithmeticWithOverflowAndCarry implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode left_;
        @Child private LLVMExpressionNode right_;
        @Child private LLVMExpressionNode cin_;
        @Child private LLVMExpressionNode cout_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)}
         *   2: SpecializationActive {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)}
         *   3: SpecializationActive {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)}
         *   4: SpecializationActive {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        @Child private Intrinsic0Data intrinsic0_cache;
        @Child private Intrinsic1Data intrinsic1_cache;
        @Child private Intrinsic2Data intrinsic2_cache;
        @Child private Intrinsic3Data intrinsic3_cache;

        private LLVMArithmeticWithOverflowAndCarryNodeGen(CarryArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode cin, LLVMExpressionNode cout) {
            super(arithmetic);
            this.left_ = left;
            this.right_ = right;
            this.cin_ = cin;
            this.cout_ = cout;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b11100) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_byte_byte_byte0(state_0, frameValue);
            } else if ((state_0 & 0b11010) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_short_short_short1(state_0, frameValue);
            } else if ((state_0 & 0b10110) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_int_int_int2(state_0, frameValue);
            } else if ((state_0 & 0b1110) == 0 /* only-active SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */ && ((state_0 & 0b11110) != 0  /* is-not SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] && SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */)) {
                return executeGeneric_long_long_long3(state_0, frameValue);
            } else {
                return executeGeneric_generic4(state_0, frameValue);
            }
        }

        private Object executeGeneric_byte_byte_byte0(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            byte cinValue_;
            try {
                cinValue_ = this.cin_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert (state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_short_short_short1(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            short cinValue_;
            try {
                cinValue_ = this.cin_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert (state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] */;
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_int_int_int2(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            int cinValue_;
            try {
                cinValue_ = this.cin_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] */;
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_long_long_long3(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue);
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue);
            }
            long cinValue_;
            try {
                cinValue_ = this.cin_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue);
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */;
            if (LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        private Object executeGeneric_generic4(int state_0__, VirtualFrame frameValue) {
            int state_0 = state_0__;
            Object leftValue_ = this.left_.executeGeneric(frameValue);
            Object rightValue_ = this.right_.executeGeneric(frameValue);
            Object cinValue_ = this.cin_.executeGeneric(frameValue);
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] || SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] || SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] || SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */ && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && leftValue_ instanceof Byte) {
                    byte leftValue__ = (byte) leftValue_;
                    if (rightValue_ instanceof Byte) {
                        byte rightValue__ = (byte) rightValue_;
                        if (cinValue_ instanceof Byte) {
                            byte cinValue__ = (byte) cinValue_;
                            Intrinsic0Data s0_ = this.intrinsic0_cache;
                            if (s0_ != null) {
                                return doIntrinsic(leftValue__, rightValue__, cinValue__, coutValue__, s0_.store_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] */ && leftValue_ instanceof Short) {
                    short leftValue__ = (short) leftValue_;
                    if (rightValue_ instanceof Short) {
                        short rightValue__ = (short) rightValue_;
                        if (cinValue_ instanceof Short) {
                            short cinValue__ = (short) cinValue_;
                            Intrinsic1Data s1_ = this.intrinsic1_cache;
                            if (s1_ != null) {
                                return doIntrinsic(leftValue__, rightValue__, cinValue__, coutValue__, s1_.store_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] */ && leftValue_ instanceof Integer) {
                    int leftValue__ = (int) leftValue_;
                    if (rightValue_ instanceof Integer) {
                        int rightValue__ = (int) rightValue_;
                        if (cinValue_ instanceof Integer) {
                            int cinValue__ = (int) cinValue_;
                            Intrinsic2Data s2_ = this.intrinsic2_cache;
                            if (s2_ != null) {
                                return doIntrinsic(leftValue__, rightValue__, cinValue__, coutValue__, s2_.store_);
                            }
                        }
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */ && leftValue_ instanceof Long) {
                    long leftValue__ = (long) leftValue_;
                    if (rightValue_ instanceof Long) {
                        long rightValue__ = (long) rightValue_;
                        if (cinValue_ instanceof Long) {
                            long cinValue__ = (long) cinValue_;
                            Intrinsic3Data s3_ = this.intrinsic3_cache;
                            if (s3_ != null) {
                                return doIntrinsic(leftValue__, rightValue__, cinValue__, coutValue__, s3_.store_);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_);
        }

        @Override
        public byte executeI8(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            byte leftValue_;
            try {
                leftValue_ = this.left_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            byte rightValue_;
            try {
                rightValue_ = this.right_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            byte cinValue_;
            try {
                cinValue_ = this.cin_.executeI8(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] */ && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic0Data s0_ = this.intrinsic0_cache;
                if (s0_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s0_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectByte(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public int executeI32(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            int leftValue_;
            try {
                leftValue_ = this.left_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            int rightValue_;
            try {
                rightValue_ = this.right_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            int cinValue_;
            try {
                cinValue_ = this.cin_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] */ && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic2Data s2_ = this.intrinsic2_cache;
                if (s2_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s2_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectInteger(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public long executeI64(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            long leftValue_;
            try {
                leftValue_ = this.left_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            long rightValue_;
            try {
                rightValue_ = this.right_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            long cinValue_;
            try {
                cinValue_ = this.cin_.executeI64(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */ && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic3Data s3_ = this.intrinsic3_cache;
                if (s3_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s3_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectLong(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        @Override
        public short executeI16(VirtualFrame frameValue) throws UnexpectedResultException {
            int state_0 = this.state_0_;
            short leftValue_;
            try {
                leftValue_ = this.left_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object rightValue = this.right_.executeGeneric(frameValue);
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(executeAndSpecialize(ex.getResult(), rightValue, cinValue, coutValue));
            }
            short rightValue_;
            try {
                rightValue_ = this.right_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object cinValue = this.cin_.executeGeneric(frameValue);
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, ex.getResult(), cinValue, coutValue));
            }
            short cinValue_;
            try {
                cinValue_ = this.cin_.executeI16(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object coutValue = this.cout_.executeGeneric(frameValue);
                return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, rightValue_, ex.getResult(), coutValue));
            }
            Object coutValue_ = this.cout_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] */ && LLVMTypes.isPointer(coutValue_)) {
                LLVMPointer coutValue__ = LLVMTypes.asPointer(coutValue_);
                Intrinsic1Data s1_ = this.intrinsic1_cache;
                if (s1_ != null) {
                    return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue__, s1_.store_);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return LLVMTypesGen.expectShort(executeAndSpecialize(leftValue_, rightValue_, cinValue_, coutValue_));
        }

        private Object executeAndSpecialize(Object leftValue, Object rightValue, Object cinValue, Object coutValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(coutValue)) {
                LLVMPointer coutValue_ = LLVMTypes.asPointer(coutValue);
                if (leftValue instanceof Byte) {
                    byte leftValue_ = (byte) leftValue;
                    if (rightValue instanceof Byte) {
                        byte rightValue_ = (byte) rightValue;
                        if (cinValue instanceof Byte) {
                            byte cinValue_ = (byte) cinValue;
                            Intrinsic0Data s0_ = this.insert(new Intrinsic0Data());
                            s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                            VarHandle.storeStoreFence();
                            this.intrinsic0_cache = s0_;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
                            this.state_0_ = state_0;
                            return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue_, s0_.store_);
                        }
                    }
                }
                if (leftValue instanceof Short) {
                    short leftValue_ = (short) leftValue;
                    if (rightValue instanceof Short) {
                        short rightValue_ = (short) rightValue;
                        if (cinValue instanceof Short) {
                            short cinValue_ = (short) cinValue;
                            Intrinsic1Data s1_ = this.insert(new Intrinsic1Data());
                            s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                            VarHandle.storeStoreFence();
                            this.intrinsic1_cache = s1_;
                            state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] */;
                            this.state_0_ = state_0;
                            return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue_, s1_.store_);
                        }
                    }
                }
                if (leftValue instanceof Integer) {
                    int leftValue_ = (int) leftValue;
                    if (rightValue instanceof Integer) {
                        int rightValue_ = (int) rightValue;
                        if (cinValue instanceof Integer) {
                            int cinValue_ = (int) cinValue;
                            Intrinsic2Data s2_ = this.insert(new Intrinsic2Data());
                            s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                            VarHandle.storeStoreFence();
                            this.intrinsic2_cache = s2_;
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] */;
                            this.state_0_ = state_0;
                            return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue_, s2_.store_);
                        }
                    }
                }
                if (leftValue instanceof Long) {
                    long leftValue_ = (long) leftValue;
                    if (rightValue instanceof Long) {
                        long rightValue_ = (long) rightValue;
                        if (cinValue instanceof Long) {
                            long cinValue_ = (long) cinValue;
                            Intrinsic3Data s3_ = this.insert(new Intrinsic3Data());
                            s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                            VarHandle.storeStoreFence();
                            this.intrinsic3_cache = s3_;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */;
                            this.state_0_ = state_0;
                            return doIntrinsic(leftValue_, rightValue_, cinValue_, coutValue_, s3_.store_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.left_, this.right_, this.cin_, this.cout_}, leftValue, rightValue, cinValue, coutValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                Intrinsic0Data s0_ = this.insert(new Intrinsic0Data());
                s0_.store_ = s0_.insert((LLVMI8StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic0_cache = s0_;
                assert NodeUtil.assertRecursion(s0_.store_, 1);
                ((GenerateAOT.Provider) s0_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)] */;
            }
            {
                Intrinsic1Data s1_ = this.insert(new Intrinsic1Data());
                s1_.store_ = s1_.insert((LLVMI16StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic1_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)] */;
            }
            {
                Intrinsic2Data s2_ = this.insert(new Intrinsic2Data());
                s2_.store_ = s2_.insert((LLVMI32StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic2_cache = s2_;
                assert NodeUtil.assertRecursion(s2_.store_, 1);
                ((GenerateAOT.Provider) s2_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)] */;
            }
            {
                Intrinsic3Data s3_ = this.insert(new Intrinsic3Data());
                s3_.store_ = s3_.insert((LLVMI64StoreNode.create()));
                VarHandle.storeStoreFence();
                this.intrinsic3_cache = s3_;
                assert NodeUtil.assertRecursion(s3_.store_, 1);
                ((GenerateAOT.Provider) s3_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMArithmetic.LLVMArithmeticWithOverflowAndCarry.doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.intrinsic0_cache = null;
            this.intrinsic1_cache = null;
            this.intrinsic2_cache = null;
            this.intrinsic3_cache = null;
        }

        @NeverDefault
        public static LLVMArithmeticWithOverflowAndCarry create(CarryArithmetic arithmetic, LLVMExpressionNode left, LLVMExpressionNode right, LLVMExpressionNode cin, LLVMExpressionNode cout) {
            return new LLVMArithmeticWithOverflowAndCarryNodeGen(arithmetic, left, right, cin, cout);
        }

        @GeneratedBy(LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic0Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(byte, byte, byte, LLVMPointer, LLVMI8StoreNode)}
             *   Parameter: {@link LLVMI8StoreNode} store</pre>
             */
            @Child LLVMI8StoreNode store_;

            Intrinsic0Data() {
            }

        }
        @GeneratedBy(LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic1Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(short, short, short, LLVMPointer, LLVMI16StoreNode)}
             *   Parameter: {@link LLVMI16StoreNode} store</pre>
             */
            @Child LLVMI16StoreNode store_;

            Intrinsic1Data() {
            }

        }
        @GeneratedBy(LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic2Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(int, int, int, LLVMPointer, LLVMI32StoreNode)}
             *   Parameter: {@link LLVMI32StoreNode} store</pre>
             */
            @Child LLVMI32StoreNode store_;

            Intrinsic2Data() {
            }

        }
        @GeneratedBy(LLVMArithmeticWithOverflowAndCarry.class)
        @DenyReplace
        private static final class Intrinsic3Data extends Node implements SpecializationDataNode {

            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMArithmeticWithOverflowAndCarry#doIntrinsic(long, long, long, LLVMPointer, LLVMI64StoreNode)}
             *   Parameter: {@link LLVMI64StoreNode} store</pre>
             */
            @Child LLVMI64StoreNode store_;

            Intrinsic3Data() {
            }

        }
    }
}
