// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.arith;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMComplexFloatDiv#doFloat}
 *     Activation probability: 1.00000
 *     With/without class size: 16/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMComplexFloatDiv.class)
@SuppressWarnings("javadoc")
public final class LLVMComplexFloatDivNodeGen extends LLVMComplexFloatDiv implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode a_;
    @Child private LLVMExpressionNode b_;
    @Child private LLVMExpressionNode c_;
    @Child private LLVMExpressionNode d_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMComplexFloatDiv#doFloat}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMComplexFloatDivNodeGen(LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        this.a_ = a;
        this.b_ = b;
        this.c_ = c;
        this.d_ = d;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        float aValue_;
        try {
            aValue_ = this.a_.executeFloat(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object bValue = this.b_.executeGeneric(frameValue);
            Object cValue = this.c_.executeGeneric(frameValue);
            Object dValue = this.d_.executeGeneric(frameValue);
            return executeAndSpecialize(ex.getResult(), bValue, cValue, dValue);
        }
        float bValue_;
        try {
            bValue_ = this.b_.executeFloat(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object cValue = this.c_.executeGeneric(frameValue);
            Object dValue = this.d_.executeGeneric(frameValue);
            return executeAndSpecialize(aValue_, ex.getResult(), cValue, dValue);
        }
        float cValue_;
        try {
            cValue_ = this.c_.executeFloat(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object dValue = this.d_.executeGeneric(frameValue);
            return executeAndSpecialize(aValue_, bValue_, ex.getResult(), dValue);
        }
        float dValue_;
        try {
            dValue_ = this.d_.executeFloat(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(aValue_, bValue_, cValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(aValue_, bValue_, cValue_, dValue_);
        }
        if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMComplexFloatDiv.doFloat(float, float, float, float)] */) {
            return doFloat(aValue_, bValue_, cValue_, dValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(aValue_, bValue_, cValue_, dValue_);
    }

    private LLVMFloatVector executeAndSpecialize(Object aValue, Object bValue, Object cValue, Object dValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (aValue instanceof Float) {
            float aValue_ = (float) aValue;
            if (bValue instanceof Float) {
                float bValue_ = (float) bValue;
                if (cValue instanceof Float) {
                    float cValue_ = (float) cValue;
                    if (dValue instanceof Float) {
                        float dValue_ = (float) dValue;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMComplexFloatDiv.doFloat(float, float, float, float)] */;
                        this.state_0_ = state_0;
                        return doFloat(aValue_, bValue_, cValue_, dValue_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.a_, this.b_, this.c_, this.d_}, aValue, bValue, cValue, dValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMComplexFloatDiv.doFloat(float, float, float, float)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMComplexFloatDiv create(LLVMExpressionNode a, LLVMExpressionNode b, LLVMExpressionNode c, LLVMExpressionNode d) {
        return new LLVMComplexFloatDivNodeGen(a, b, c, d);
    }

}
