// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.Type;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMGetElementPtrNode#doPointerDiff}
 *     Activation probability: 0.32000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMGetElementPtrNode#doPointerDiffRev}
 *     Activation probability: 0.26000
 *     With/without class size: 7/0 bytes
 *   Specialization {@link LLVMGetElementPtrNode#doInt}
 *     Activation probability: 0.20000
 *     With/without class size: 6/0 bytes
 *   Specialization {@link LLVMGetElementPtrNode#doLong}
 *     Activation probability: 0.14000
 *     With/without class size: 5/0 bytes
 *   Specialization {@link LLVMGetElementPtrNode#doNativePointer}
 *     Activation probability: 0.08000
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMGetElementPtrNode.class)
@SuppressWarnings("javadoc")
public final class LLVMGetElementPtrNodeGen extends LLVMGetElementPtrNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode base_;
    @Child private LLVMExpressionNode offset_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMGetElementPtrNode#doPointerDiff}
     *   2: SpecializationActive {@link LLVMGetElementPtrNode#doPointerDiffRev}
     *   3: SpecializationActive {@link LLVMGetElementPtrNode#doInt}
     *   4: SpecializationActive {@link LLVMGetElementPtrNode#doLong}
     *   5: SpecializationActive {@link LLVMGetElementPtrNode#doNativePointer}
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMGetElementPtrNodeGen(long typeWidth, Type targetType, LLVMExpressionNode base, LLVMExpressionNode offset) {
        super(typeWidth, targetType);
        this.base_ = base;
        this.offset_ = offset;
    }

    @Override
    public LLVMExpressionNode getBase() {
        return this.base_;
    }

    @Override
    public LLVMExpressionNode getOffset() {
        return this.offset_;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b110110) == 0 /* only-active SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMGetElementPtrNode.doPointerDiff(LLVMManagedPointer, LLVMManagedPointer)] && SpecializationActive[LLVMGetElementPtrNode.doPointerDiffRev(LLVMManagedPointer, LLVMManagedPointer)] && SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] && SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] && SpecializationActive[LLVMGetElementPtrNode.doNativePointer(LLVMPointer, LLVMNativePointer)] */)) {
            return executeGeneric_int0(state_0, frameValue);
        } else if ((state_0 & 0b101110) == 0 /* only-active SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] */ && ((state_0 & 0b111110) != 0  /* is-not SpecializationActive[LLVMGetElementPtrNode.doPointerDiff(LLVMManagedPointer, LLVMManagedPointer)] && SpecializationActive[LLVMGetElementPtrNode.doPointerDiffRev(LLVMManagedPointer, LLVMManagedPointer)] && SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] && SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] && SpecializationActive[LLVMGetElementPtrNode.doNativePointer(LLVMPointer, LLVMNativePointer)] */)) {
            return executeGeneric_long1(state_0, frameValue);
        } else {
            return executeGeneric_generic2(state_0, frameValue);
        }
    }

    private Object executeGeneric_int0(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        int offsetValue_;
        try {
            offsetValue_ = this.offset_.executeI32(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(baseValue_, offsetValue_);
        }
        assert (state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] */;
        if (LLVMTypes.isPointer(baseValue_)) {
            LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
            return doInt(baseValue__, offsetValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(baseValue_, offsetValue_);
    }

    private Object executeGeneric_long1(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        long offsetValue_;
        try {
            offsetValue_ = this.offset_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(baseValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(baseValue_, offsetValue_);
        }
        assert (state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] */;
        if (LLVMTypes.isPointer(baseValue_)) {
            LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
            return doLong(baseValue__, offsetValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(baseValue_, offsetValue_);
    }

    private Object executeGeneric_generic2(int state_0__, VirtualFrame frameValue) {
        int state_0 = state_0__;
        Object baseValue_ = this.base_.executeGeneric(frameValue);
        Object offsetValue_ = this.offset_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(baseValue_, offsetValue_);
        }
        if ((state_0 & 0b111110) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doPointerDiff(LLVMManagedPointer, LLVMManagedPointer)] || SpecializationActive[LLVMGetElementPtrNode.doPointerDiffRev(LLVMManagedPointer, LLVMManagedPointer)] || SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] || SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] || SpecializationActive[LLVMGetElementPtrNode.doNativePointer(LLVMPointer, LLVMNativePointer)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doPointerDiff(LLVMManagedPointer, LLVMManagedPointer)] || SpecializationActive[LLVMGetElementPtrNode.doPointerDiffRev(LLVMManagedPointer, LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(baseValue_)) {
                LLVMManagedPointer baseValue__ = LLVMTypes.asManagedPointer(baseValue_);
                if (LLVMTypes.isManagedPointer(offsetValue_)) {
                    LLVMManagedPointer offsetValue__ = LLVMTypes.asManagedPointer(offsetValue_);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doPointerDiff(LLVMManagedPointer, LLVMManagedPointer)] */) {
                        if ((LLVMGetElementPtrNode.isNegated(baseValue__.getObject(), offsetValue__.getObject()))) {
                            return doPointerDiff(baseValue__, offsetValue__);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doPointerDiffRev(LLVMManagedPointer, LLVMManagedPointer)] */) {
                        if ((LLVMGetElementPtrNode.isNegated(offsetValue__.getObject(), baseValue__.getObject()))) {
                            return doPointerDiffRev(baseValue__, offsetValue__);
                        }
                    }
                }
            }
            if ((state_0 & 0b111000) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] || SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] || SpecializationActive[LLVMGetElementPtrNode.doNativePointer(LLVMPointer, LLVMNativePointer)] */ && LLVMTypes.isPointer(baseValue_)) {
                LLVMPointer baseValue__ = LLVMTypes.asPointer(baseValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] */ && offsetValue_ instanceof Integer) {
                    int offsetValue__ = (int) offsetValue_;
                    return doInt(baseValue__, offsetValue__);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] */ && offsetValue_ instanceof Long) {
                    long offsetValue__ = (long) offsetValue_;
                    return doLong(baseValue__, offsetValue__);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMGetElementPtrNode.doNativePointer(LLVMPointer, LLVMNativePointer)] */ && LLVMTypes.isNativePointer(offsetValue_)) {
                    LLVMNativePointer offsetValue__ = LLVMTypes.asNativePointer(offsetValue_);
                    return doNativePointer(baseValue__, offsetValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(baseValue_, offsetValue_);
    }

    private LLVMPointer executeAndSpecialize(Object baseValue, Object offsetValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isManagedPointer(baseValue)) {
            LLVMManagedPointer baseValue_ = LLVMTypes.asManagedPointer(baseValue);
            if (LLVMTypes.isManagedPointer(offsetValue)) {
                LLVMManagedPointer offsetValue_ = LLVMTypes.asManagedPointer(offsetValue);
                if ((LLVMGetElementPtrNode.isNegated(baseValue_.getObject(), offsetValue_.getObject()))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMGetElementPtrNode.doPointerDiff(LLVMManagedPointer, LLVMManagedPointer)] */;
                    this.state_0_ = state_0;
                    return doPointerDiff(baseValue_, offsetValue_);
                }
                if ((LLVMGetElementPtrNode.isNegated(offsetValue_.getObject(), baseValue_.getObject()))) {
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMGetElementPtrNode.doPointerDiffRev(LLVMManagedPointer, LLVMManagedPointer)] */;
                    this.state_0_ = state_0;
                    return doPointerDiffRev(baseValue_, offsetValue_);
                }
            }
        }
        if (LLVMTypes.isPointer(baseValue)) {
            LLVMPointer baseValue_ = LLVMTypes.asPointer(baseValue);
            if (offsetValue instanceof Integer) {
                int offsetValue_ = (int) offsetValue;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] */;
                this.state_0_ = state_0;
                return doInt(baseValue_, offsetValue_);
            }
            if (offsetValue instanceof Long) {
                long offsetValue_ = (long) offsetValue;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] */;
                this.state_0_ = state_0;
                return doLong(baseValue_, offsetValue_);
            }
            if (LLVMTypes.isNativePointer(offsetValue)) {
                LLVMNativePointer offsetValue_ = LLVMTypes.asNativePointer(offsetValue);
                state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMGetElementPtrNode.doNativePointer(LLVMPointer, LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doNativePointer(baseValue_, offsetValue_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.base_, this.offset_}, baseValue, offsetValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMGetElementPtrNode.doPointerDiff(LLVMManagedPointer, LLVMManagedPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMGetElementPtrNode.doPointerDiffRev(LLVMManagedPointer, LLVMManagedPointer)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMGetElementPtrNode.doInt(LLVMPointer, int)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMGetElementPtrNode.doLong(LLVMPointer, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMGetElementPtrNode.doNativePointer(LLVMPointer, LLVMNativePointer)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMGetElementPtrNode create(long typeWidth, Type targetType, LLVMExpressionNode base, LLVMExpressionNode offset) {
        return new LLVMGetElementPtrNodeGen(typeWidth, targetType, base, offset);
    }

}
