// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.floating.LLVM128BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVM128BitFloatLoadNode#do128BitFloatNative}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVM128BitFloatLoadNode#do128BitFloatDerefHandle}
 *     Activation probability: 0.35000
 *     With/without class size: 12/8 bytes
 * </pre>
 */
@GeneratedBy(LLVM128BitFloatLoadNode.class)
@SuppressWarnings("javadoc")
public final class LLVM128BitFloatLoadNodeGen extends LLVM128BitFloatLoadNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVM128BitFloatLoadNode#do128BitFloatNative}
     *   2: SpecializationActive {@link LLVM128BitFloatLoadNode#do128BitFloatDerefHandle}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private Do128BitFloatDerefHandleData do128BitFloatDerefHandle_cache;

    private LLVM128BitFloatLoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    private LLVM128BitFloatLoadNodeGen(boolean isRecursive, LLVMExpressionNode address) {
        super(isRecursive);
        this.address_ = address;
    }

    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatNative(LLVMNativePointer)] || SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatLoadNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatNative(LLVMNativePointer)] */) {
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    return do128BitFloatNative(addressValue_);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatLoadNode)] */) {
                Do128BitFloatDerefHandleData s1_ = this.do128BitFloatDerefHandle_cache;
                if (s1_ != null) {
                    assert DSLSupport.assertIdempotence((!(isRecursive)));
                    if ((isAutoDerefHandle(addressValue_))) {
                        return do128BitFloatDerefHandle(addressValue_, s1_.getReceiver_, s1_.load_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @Override
    public LLVM128BitFloat executeWithTarget(LLVMManagedPointer addressValue) {
        throw CompilerDirectives.shouldNotReachHere("Delegation failed.");
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatNative(LLVMNativePointer)] || SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatLoadNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
            LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatNative(LLVMNativePointer)] */) {
                if ((!(isAutoDerefHandle(addressValue__)))) {
                    return do128BitFloatNative(addressValue__);
                }
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatLoadNode)] */) {
                Do128BitFloatDerefHandleData s1_ = this.do128BitFloatDerefHandle_cache;
                if (s1_ != null) {
                    assert DSLSupport.assertIdempotence((!(isRecursive)));
                    if ((isAutoDerefHandle(addressValue__))) {
                        return do128BitFloatDerefHandle(addressValue__, s1_.getReceiver_, s1_.load_);
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    private LLVM128BitFloat executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((!(isAutoDerefHandle(addressValue_)))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatNative(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return do128BitFloatNative(addressValue_);
            }
            if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                Do128BitFloatDerefHandleData s1_ = this.insert(new Do128BitFloatDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.getReceiver_ = getReceiver__;
                s1_.load_ = s1_.insert((LLVM128BitFloatLoadNode.createRecursive()));
                VarHandle.storeStoreFence();
                this.do128BitFloatDerefHandle_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatLoadNode)] */;
                this.state_0_ = state_0;
                return do128BitFloatDerefHandle(addressValue_, getReceiver__, s1_.load_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatNative(LLVMNativePointer)] */;
        }
        {
            if ((!(isRecursive))) {
                Do128BitFloatDerefHandleData s1_ = this.insert(new Do128BitFloatDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.getReceiver_ = getReceiver__;
                s1_.load_ = s1_.insert((LLVM128BitFloatLoadNode.createRecursive()));
                VarHandle.storeStoreFence();
                this.do128BitFloatDerefHandle_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.load_, 1);
                ((GenerateAOT.Provider) s1_.load_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVM128BitFloatLoadNode.do128BitFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVM128BitFloatLoadNode)] */;
            }
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.do128BitFloatDerefHandle_cache = null;
    }

    @NeverDefault
    public static LLVM128BitFloatLoadNode create(LLVMExpressionNode address) {
        return new LLVM128BitFloatLoadNodeGen(address);
    }

    @NeverDefault
    public static LLVM128BitFloatLoadNode create(boolean isRecursive, LLVMExpressionNode address) {
        return new LLVM128BitFloatLoadNodeGen(isRecursive, address);
    }

    @GeneratedBy(LLVM128BitFloatLoadNode.class)
    @DenyReplace
    private static final class Do128BitFloatDerefHandleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM128BitFloatLoadNode#do128BitFloatDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVM128BitFloatLoadNode#do128BitFloatDerefHandle}
         *   Parameter: {@link LLVM128BitFloatLoadNode} load</pre>
         */
        @Child LLVM128BitFloatLoadNode load_;

        Do128BitFloatDerefHandleData() {
        }

    }
}
