// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMFloatLoadNode#doFloatNative}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMFloatLoadNode#doFloatDerefHandle}
 *     Activation probability: 0.29500
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMFloatLoadNode#doFloatManaged}
 *     Activation probability: 0.20500
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMFloatLoadNode#doFloatManaged}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMFloatLoadNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMFloatLoadNodeGen extends LLVMFloatLoadNode implements GenerateAOT.Provider {

    static final ReferenceField<FloatManaged0Data> FLOAT_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "floatManaged0_cache", FloatManaged0Data.class);
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMFloatLoadNode#doFloatNative}
     *   2: SpecializationActive {@link LLVMFloatLoadNode#doFloatDerefHandle}
     *   3: SpecializationActive {@link LLVMFloatLoadNode#doFloatManaged}
     *   4: SpecializationActive {@link LLVMFloatLoadNode#doFloatManaged}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMFloatLoadNode#doFloatDerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode floatDerefHandle_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMFloatLoadNode#doFloatDerefHandle}
     *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
     */
    @Child private LLVMManagedReadLibrary floatDerefHandle_nativeRead_;
    @UnsafeAccessedField @Child private FloatManaged0Data floatManaged0_cache;

    private LLVMFloatLoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @ExplodeLoop
    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doFloatNative(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.floatDerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.floatDerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return LLVMFloatLoadNode.doFloatDerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    FloatManaged0Data s2_ = this.floatManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            return LLVMFloatLoadNode.doFloatManaged(addressValue_, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.floatManaged1Boundary(state_0, addressValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object floatManaged1Boundary(int state_0, LLVMManagedPointer addressValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return LLVMFloatLoadNode.doFloatManaged(addressValue_, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public float executeWithTarget(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doFloatNative(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.floatDerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.floatDerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return LLVMFloatLoadNode.doFloatDerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    FloatManaged0Data s2_ = this.floatManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            return LLVMFloatLoadNode.doFloatManaged(addressValue_, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.floatManaged1Boundary0(state_0, addressValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private float floatManaged1Boundary0(int state_0, LLVMManagedPointer addressValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return LLVMFloatLoadNode.doFloatManaged(addressValue_, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doFloatNative(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.floatDerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.floatDerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return LLVMFloatLoadNode.doFloatDerefHandle(addressValue__, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    FloatManaged0Data s2_ = this.floatManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                            return LLVMFloatLoadNode.doFloatManaged(addressValue__, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.floatManaged1Boundary1(state_0, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object floatManaged1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return LLVMFloatLoadNode.doFloatManaged(addressValue__, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public float executeFloat(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] || SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doFloatNative(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.floatDerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.floatDerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return LLVMFloatLoadNode.doFloatDerefHandle(addressValue__, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    FloatManaged0Data s2_ = this.floatManaged0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                            return LLVMFloatLoadNode.doFloatManaged(addressValue__, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.floatManaged1Boundary2(state_0, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private float floatManaged1Boundary2(int state_0, LLVMManagedPointer addressValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return LLVMFloatLoadNode.doFloatManaged(addressValue__, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private float executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((!(isAutoDerefHandle(addressValue_)))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doFloatNative(addressValue_);
            }
            if ((isAutoDerefHandle(addressValue_))) {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.floatDerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.floatDerefHandle_nativeRead_ = nativeRead__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                this.state_0_ = state_0;
                return LLVMFloatLoadNode.doFloatDerefHandle(addressValue_, getReceiver__, nativeRead__);
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                while (true) {
                    int count2_ = 0;
                    FloatManaged0Data s2_ = FLOAT_MANAGED0_CACHE_UPDATER.getVolatile(this);
                    FloatManaged0Data s2_original = s2_;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count2_++;
                        s2_ = s2_.next_;
                    }
                    if (s2_ == null) {
                        // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                        if (count2_ < (3)) {
                            s2_ = this.insert(new FloatManaged0Data(s2_original));
                            LLVMManagedReadLibrary nativeRead__1 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeRead__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.nativeRead_ = nativeRead__1;
                            if (!FLOAT_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s2_ != null) {
                        return LLVMFloatLoadNode.doFloatManaged(addressValue_, s2_.nativeRead_);
                    }
                    break;
                }
            }
            {
                LLVMManagedReadLibrary nativeRead__1 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        this.floatManaged0_cache = null;
                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMFloatLoadNode.doFloatManaged(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return LLVMFloatLoadNode.doFloatManaged(addressValue_, nativeRead__1);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFloatLoadNode.doFloatNative(LLVMNativePointer)] */;
        }
        {
            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.floatDerefHandle_getReceiver_ = getReceiver__;
            LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeRead__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.floatDerefHandle_nativeRead_ = nativeRead__;
            assert NodeUtil.assertRecursion(this.floatDerefHandle_getReceiver_, 1);
            ((GenerateAOT.Provider) this.floatDerefHandle_getReceiver_).prepareForAOT(language, root);
            if (this.floatDerefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.floatDerefHandle_nativeRead_, 1);
                ((GenerateAOT.Provider) this.floatDerefHandle_nativeRead_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMFloatLoadNode.doFloatDerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.floatDerefHandle_getReceiver_ = null;
        this.floatDerefHandle_nativeRead_ = null;
    }

    @NeverDefault
    public static LLVMFloatLoadNode create(LLVMExpressionNode address) {
        return new LLVMFloatLoadNodeGen(address);
    }

    @GeneratedBy(LLVMFloatLoadNode.class)
    @DenyReplace
    private static final class FloatManaged0Data extends Node implements SpecializationDataNode {

        @Child FloatManaged0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMFloatLoadNode#doFloatManaged}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child LLVMManagedReadLibrary nativeRead_;

        FloatManaged0Data(FloatManaged0Data next_) {
            this.next_ = next_;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMFloatOffsetLoadNode#doFloatNative}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMFloatOffsetLoadNode#doFloatDerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMFloatOffsetLoadNode#doFloatManaged}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMFloatOffsetLoadNode#doFloatManaged}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMFloatOffsetLoadNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMFloatOffsetLoadNodeGen extends LLVMFloatOffsetLoadNode implements GenerateAOT.Provider {

        static final ReferenceField<FloatManaged0Data> FLOAT_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "floatManaged0_cache", FloatManaged0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMFloatOffsetLoadNode#doFloatNative}
         *   2: SpecializationActive {@link LLVMFloatOffsetLoadNode#doFloatDerefHandle}
         *   3: SpecializationActive {@link LLVMFloatOffsetLoadNode#doFloatManaged}
         *   4: SpecializationActive {@link LLVMFloatOffsetLoadNode#doFloatManaged}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMFloatOffsetLoadNode#doFloatDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode floatDerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMFloatOffsetLoadNode#doFloatDerefHandle}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child private LLVMManagedReadLibrary floatDerefHandle_nativeRead_;
        @UnsafeAccessedField @Child private FloatManaged0Data floatManaged0_cache;

        private LLVMFloatOffsetLoadNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doFloatNative(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.floatDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.floatDerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return LLVMFloatOffsetLoadNode.doFloatDerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        FloatManaged0Data s2_ = this.floatManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        return this.floatManaged1Boundary(state_0, arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object floatManaged1Boundary(int state_0, LLVMManagedPointer arg0Value_, long arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                    return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, nativeRead__1);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public float executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doFloatNative(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.floatDerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.floatDerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return LLVMFloatOffsetLoadNode.doFloatDerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        FloatManaged0Data s2_ = this.floatManaged0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        return this.floatManaged1Boundary0(state_0, arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private float floatManaged1Boundary0(int state_0, LLVMManagedPointer arg0Value_, long arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                    return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, nativeRead__1);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private float executeAndSpecialize(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((!(isAutoDerefHandle(arg0Value_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] */;
                    this.state_0_ = state_0;
                    return doFloatNative(arg0Value_, arg1Value);
                }
                if ((isAutoDerefHandle(arg0Value_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.floatDerefHandle_getReceiver_ = getReceiver__;
                    LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeRead__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.floatDerefHandle_nativeRead_ = nativeRead__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatDerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return LLVMFloatOffsetLoadNode.doFloatDerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                }
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        FloatManaged0Data s2_ = FLOAT_MANAGED0_CACHE_UPDATER.getVolatile(this);
                        FloatManaged0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(arg0Value_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new FloatManaged0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__1 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(arg0Value_.getObject())));
                                Objects.requireNonNull(nativeRead__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.nativeRead_ = nativeRead__1;
                                if (!FLOAT_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                            this.floatManaged0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatManaged(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, nativeRead__1);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMFloatLoadNode.LLVMFloatOffsetLoadNode.doFloatNative(LLVMNativePointer, long)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2LJ(Node thisNode_, Object arg0Value, long arg1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
        }

        @NeverDefault
        public static LLVMFloatOffsetLoadNode create() {
            return new LLVMFloatOffsetLoadNodeGen();
        }

        @NeverDefault
        public static LLVMFloatOffsetLoadNode getUncached() {
            return LLVMFloatOffsetLoadNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMFloatOffsetLoadNode.class)
        @DenyReplace
        private static final class FloatManaged0Data extends Node implements SpecializationDataNode {

            @Child FloatManaged0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMFloatOffsetLoadNode#doFloatManaged}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            FloatManaged0Data(FloatManaged0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LLVMFloatOffsetLoadNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMFloatOffsetLoadNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doFloatNative(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return LLVMFloatOffsetLoadNode.doFloatDerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject())));
                }
                throw newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public float executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doFloatNative(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return LLVMFloatOffsetLoadNode.doFloatDerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return LLVMFloatOffsetLoadNode.doFloatManaged(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject())));
                }
                throw newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

        }
    }
}
