// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.load;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMI8LoadNode#doI8Native}
 *     Activation probability: 0.38500
 *     With/without class size: 8/0 bytes
 *   Specialization {@link LLVMI8LoadNode#doI8DerefHandle}
 *     Activation probability: 0.29500
 *     With/without class size: 11/8 bytes
 *   Specialization {@link LLVMI8LoadNode#doI8Managed}
 *     Activation probability: 0.20500
 *     With/without class size: 8/4 bytes
 *   Specialization {@link LLVMI8LoadNode#doI8Managed}
 *     Activation probability: 0.11500
 *     With/without class size: 5/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMI8LoadNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMI8LoadNodeGen extends LLVMI8LoadNode implements GenerateAOT.Provider {

    static final ReferenceField<I8Managed0Data> I8_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i8Managed0_cache", I8Managed0Data.class);
    private static final LibraryFactory<LLVMManagedReadLibrary> L_L_V_M_MANAGED_READ_LIBRARY_ = LibraryFactory.resolve(LLVMManagedReadLibrary.class);

    @Child private LLVMExpressionNode address_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMI8LoadNode#doI8Native}
     *   2: SpecializationActive {@link LLVMI8LoadNode#doI8DerefHandle}
     *   3: SpecializationActive {@link LLVMI8LoadNode#doI8Managed}
     *   4: SpecializationActive {@link LLVMI8LoadNode#doI8Managed}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI8LoadNode#doI8DerefHandle}
     *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
     */
    @Child private LLVMDerefHandleGetReceiverNode i8DerefHandle_getReceiver_;
    /**
     * Source Info: <pre>
     *   Specialization: {@link LLVMI8LoadNode#doI8DerefHandle}
     *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
     */
    @Child private LLVMManagedReadLibrary i8DerefHandle_nativeRead_;
    @UnsafeAccessedField @Child private I8Managed0Data i8Managed0_cache;

    private LLVMI8LoadNodeGen(LLVMExpressionNode address) {
        this.address_ = address;
    }

    @ExplodeLoop
    @Override
    public Object executeWithTargetGeneric(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doI8Native(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i8DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i8DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return doI8DerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I8Managed0Data s2_ = this.i8Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            return doI8Managed(addressValue_, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i8Managed1Boundary(state_0, addressValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object i8Managed1Boundary(int state_0, LLVMManagedPointer addressValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return doI8Managed(addressValue_, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public byte executeWithTarget(Object addressValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        return doI8Native(addressValue_);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i8DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i8DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue_))) {
                                    return doI8DerefHandle(addressValue_, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I8Managed0Data s2_ = this.i8Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            return doI8Managed(addressValue_, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i8Managed1Boundary0(state_0, addressValue_);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private byte i8Managed1Boundary0(int state_0, LLVMManagedPointer addressValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                return doI8Managed(addressValue_, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doI8Native(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i8DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i8DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return doI8DerefHandle(addressValue__, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I8Managed0Data s2_ = this.i8Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                            return doI8Managed(addressValue__, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i8Managed1Boundary1(state_0, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private Object i8Managed1Boundary1(int state_0, LLVMManagedPointer addressValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return doI8Managed(addressValue__, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public byte executeI8(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(addressValue_);
        }
        if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
            if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] || SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] */) {
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        return doI8Native(addressValue__);
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                    {
                        LLVMDerefHandleGetReceiverNode getReceiver__ = this.i8DerefHandle_getReceiver_;
                        if (getReceiver__ != null) {
                            LLVMManagedReadLibrary nativeRead__ = this.i8DerefHandle_nativeRead_;
                            if (nativeRead__ != null) {
                                if ((isAutoDerefHandle(addressValue__))) {
                                    return doI8DerefHandle(addressValue__, getReceiver__, nativeRead__);
                                }
                            }
                        }
                    }
                }
            }
            if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    I8Managed0Data s2_ = this.i8Managed0_cache;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue__.getObject()))) {
                            return doI8Managed(addressValue__, s2_.nativeRead_);
                        }
                        s2_ = s2_.next_;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                    return this.i8Managed1Boundary2(state_0, addressValue__);
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(addressValue_);
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private byte i8Managed1Boundary2(int state_0, LLVMManagedPointer addressValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue__.getObject()));
                return doI8Managed(addressValue__, nativeRead__1);
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private byte executeAndSpecialize(Object addressValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if ((!(isAutoDerefHandle(addressValue_)))) {
                state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] */;
                this.state_0_ = state_0;
                return doI8Native(addressValue_);
            }
            if ((isAutoDerefHandle(addressValue_))) {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.i8DerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.i8DerefHandle_nativeRead_ = nativeRead__;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                this.state_0_ = state_0;
                return doI8DerefHandle(addressValue_, getReceiver__, nativeRead__);
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */) {
                while (true) {
                    int count2_ = 0;
                    I8Managed0Data s2_ = I8_MANAGED0_CACHE_UPDATER.getVolatile(this);
                    I8Managed0Data s2_original = s2_;
                    while (s2_ != null) {
                        if ((s2_.nativeRead_.accepts(addressValue_.getObject()))) {
                            break;
                        }
                        count2_++;
                        s2_ = s2_.next_;
                    }
                    if (s2_ == null) {
                        // assert (s2_.nativeRead_.accepts(addressValue_.getObject()));
                        if (count2_ < (3)) {
                            s2_ = this.insert(new I8Managed0Data(s2_original));
                            LLVMManagedReadLibrary nativeRead__1 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(addressValue_.getObject())));
                            Objects.requireNonNull(nativeRead__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s2_.nativeRead_ = nativeRead__1;
                            if (!I8_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                        }
                    }
                    if (s2_ != null) {
                        return doI8Managed(addressValue_, s2_.nativeRead_);
                    }
                    break;
                }
            }
            {
                LLVMManagedReadLibrary nativeRead__1 = null;
                {
                    EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                    Node prev_ = encapsulating_.set(this);
                    try {
                        nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(addressValue_.getObject()));
                        this.i8Managed0_cache = null;
                        state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI8LoadNode.doI8Managed(LLVMManagedPointer, LLVMManagedReadLibrary)] */;
                        this.state_0_ = state_0;
                        return doI8Managed(addressValue_, nativeRead__1);
                    } finally {
                        encapsulating_.set(prev_);
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_}, addressValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI8LoadNode.doI8Native(LLVMNativePointer)] */;
        }
        {
            LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
            Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.i8DerefHandle_getReceiver_ = getReceiver__;
            LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
            Objects.requireNonNull(nativeRead__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.i8DerefHandle_nativeRead_ = nativeRead__;
            assert NodeUtil.assertRecursion(this.i8DerefHandle_getReceiver_, 1);
            ((GenerateAOT.Provider) this.i8DerefHandle_getReceiver_).prepareForAOT(language, root);
            if (this.i8DerefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                assert NodeUtil.assertRecursion(this.i8DerefHandle_nativeRead_, 1);
                ((GenerateAOT.Provider) this.i8DerefHandle_nativeRead_).prepareForAOT(language, root);
            }
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMI8LoadNode.doI8DerefHandle(LLVMNativePointer, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.i8DerefHandle_getReceiver_ = null;
        this.i8DerefHandle_nativeRead_ = null;
    }

    @NeverDefault
    public static LLVMI8LoadNode create(LLVMExpressionNode address) {
        return new LLVMI8LoadNodeGen(address);
    }

    @GeneratedBy(LLVMI8LoadNode.class)
    @DenyReplace
    private static final class I8Managed0Data extends Node implements SpecializationDataNode {

        @Child I8Managed0Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI8LoadNode#doI8Managed}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child LLVMManagedReadLibrary nativeRead_;

        I8Managed0Data(I8Managed0Data next_) {
            this.next_ = next_;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link LLVMI8OffsetLoadNode#doI8Native}
     *     Activation probability: 0.38500
     *     With/without class size: 8/0 bytes
     *   Specialization {@link LLVMI8OffsetLoadNode#doI8DerefHandle}
     *     Activation probability: 0.29500
     *     With/without class size: 11/8 bytes
     *   Specialization {@link LLVMI8OffsetLoadNode#doI8Managed}
     *     Activation probability: 0.20500
     *     With/without class size: 8/4 bytes
     *   Specialization {@link LLVMI8OffsetLoadNode#doI8Managed}
     *     Activation probability: 0.11500
     *     With/without class size: 5/0 bytes
     * </pre>
     */
    @GeneratedBy(LLVMI8OffsetLoadNode.class)
    @SuppressWarnings("javadoc")
    public static final class LLVMI8OffsetLoadNodeGen extends LLVMI8OffsetLoadNode implements GenerateAOT.Provider {

        static final ReferenceField<I8Managed0Data> I8_MANAGED0_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "i8Managed0_cache", I8Managed0Data.class);
        private static final Uncached UNCACHED = new Uncached();

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link LLVMI8OffsetLoadNode#doI8Native}
         *   2: SpecializationActive {@link LLVMI8OffsetLoadNode#doI8DerefHandle}
         *   3: SpecializationActive {@link LLVMI8OffsetLoadNode#doI8Managed}
         *   4: SpecializationActive {@link LLVMI8OffsetLoadNode#doI8Managed}
         * </pre>
         */
        @CompilationFinal private int state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI8OffsetLoadNode#doI8DerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child private LLVMDerefHandleGetReceiverNode i8DerefHandle_getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMI8OffsetLoadNode#doI8DerefHandle}
         *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
         */
        @Child private LLVMManagedReadLibrary i8DerefHandle_nativeRead_;
        @UnsafeAccessedField @Child private I8Managed0Data i8Managed0_cache;

        private LLVMI8OffsetLoadNodeGen() {
        }

        @ExplodeLoop
        @Override
        public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doI8Native(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.i8DerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.i8DerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return doI8DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        I8Managed0Data s2_ = this.i8Managed0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return doI8Managed(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        return this.i8Managed1Boundary(state_0, arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private Object i8Managed1Boundary(int state_0, LLVMManagedPointer arg0Value_, long arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                    return doI8Managed(arg0Value_, arg1Value, nativeRead__1);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @ExplodeLoop
        @Override
        public byte executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value, arg1Value);
            }
            if ((state_0 & 0b11110) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */ && LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] */) {
                        if ((!(isAutoDerefHandle(arg0Value_)))) {
                            return doI8Native(arg0Value_, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */) {
                        {
                            LLVMDerefHandleGetReceiverNode getReceiver__ = this.i8DerefHandle_getReceiver_;
                            if (getReceiver__ != null) {
                                LLVMManagedReadLibrary nativeRead__ = this.i8DerefHandle_nativeRead_;
                                if (nativeRead__ != null) {
                                    if ((isAutoDerefHandle(arg0Value_))) {
                                        return doI8DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                                    }
                                }
                            }
                        }
                    }
                }
                if ((state_0 & 0b11000) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] || SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        I8Managed0Data s2_ = this.i8Managed0_cache;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                return doI8Managed(arg0Value_, arg1Value, s2_.nativeRead_);
                            }
                            s2_ = s2_.next_;
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                        return this.i8Managed1Boundary0(state_0, arg0Value_, arg1Value);
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        @SuppressWarnings("static-method")
        @TruffleBoundary
        private byte i8Managed1Boundary0(int state_0, LLVMManagedPointer arg0Value_, long arg1Value) {
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this);
            try {
                {
                    LLVMManagedReadLibrary nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                    return doI8Managed(arg0Value_, arg1Value, nativeRead__1);
                }
            } finally {
                encapsulating_.set(prev_);
            }
        }

        private byte executeAndSpecialize(LLVMPointer arg0Value, long arg1Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                if ((!(isAutoDerefHandle(arg0Value_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] */;
                    this.state_0_ = state_0;
                    return doI8Native(arg0Value_, arg1Value);
                }
                if ((isAutoDerefHandle(arg0Value_))) {
                    LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                    Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.i8DerefHandle_getReceiver_ = getReceiver__;
                    LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                    Objects.requireNonNull(nativeRead__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                    VarHandle.storeStoreFence();
                    this.i8DerefHandle_nativeRead_ = nativeRead__;
                    state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
                    this.state_0_ = state_0;
                    return doI8DerefHandle(arg0Value_, arg1Value, getReceiver__, nativeRead__);
                }
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                if (((state_0 & 0b10000)) == 0 /* is-not SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */) {
                    while (true) {
                        int count2_ = 0;
                        I8Managed0Data s2_ = I8_MANAGED0_CACHE_UPDATER.getVolatile(this);
                        I8Managed0Data s2_original = s2_;
                        while (s2_ != null) {
                            if ((s2_.nativeRead_.accepts(arg0Value_.getObject()))) {
                                break;
                            }
                            count2_++;
                            s2_ = s2_.next_;
                        }
                        if (s2_ == null) {
                            // assert (s2_.nativeRead_.accepts(arg0Value_.getObject()));
                            if (count2_ < (3)) {
                                s2_ = this.insert(new I8Managed0Data(s2_original));
                                LLVMManagedReadLibrary nativeRead__1 = s2_.insert((L_L_V_M_MANAGED_READ_LIBRARY_.create(arg0Value_.getObject())));
                                Objects.requireNonNull(nativeRead__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s2_.nativeRead_ = nativeRead__1;
                                if (!I8_MANAGED0_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s2_ != null) {
                            return doI8Managed(arg0Value_, arg1Value, s2_.nativeRead_);
                        }
                        break;
                    }
                }
                {
                    LLVMManagedReadLibrary nativeRead__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeRead__1 = (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject()));
                            this.i8Managed0_cache = null;
                            state_0 = state_0 & 0xfffffff7 /* remove SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Managed(LLVMManagedPointer, long, LLVMManagedReadLibrary)] */;
                            this.state_0_ = state_0;
                            return doI8Managed(arg0Value_, arg1Value, nativeRead__1);
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value, arg1Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8Native(LLVMNativePointer, long)] */;
            }
            {
                LLVMDerefHandleGetReceiverNode getReceiver__ = this.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.i8DerefHandle_getReceiver_ = getReceiver__;
                LLVMManagedReadLibrary nativeRead__ = this.insert((L_L_V_M_MANAGED_READ_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(nativeRead__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                VarHandle.storeStoreFence();
                this.i8DerefHandle_nativeRead_ = nativeRead__;
                assert NodeUtil.assertRecursion(this.i8DerefHandle_getReceiver_, 1);
                ((GenerateAOT.Provider) this.i8DerefHandle_getReceiver_).prepareForAOT(language, root);
                if (this.i8DerefHandle_nativeRead_ instanceof GenerateAOT.Provider) {
                    assert NodeUtil.assertRecursion(this.i8DerefHandle_nativeRead_, 1);
                    ((GenerateAOT.Provider) this.i8DerefHandle_nativeRead_).prepareForAOT(language, root);
                }
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMI8LoadNode.LLVMI8OffsetLoadNode.doI8DerefHandle(LLVMNativePointer, long, LLVMDerefHandleGetReceiverNode, LLVMManagedReadLibrary)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
            this.i8DerefHandle_getReceiver_ = null;
            this.i8DerefHandle_nativeRead_ = null;
        }

        @TruffleBoundary
        private static UnsupportedSpecializationException newUnsupportedSpecializationException2LJ(Node thisNode_, Object arg0Value, long arg1Value) {
            return new UnsupportedSpecializationException(thisNode_, null, arg0Value, arg1Value);
        }

        @NeverDefault
        public static LLVMI8OffsetLoadNode create() {
            return new LLVMI8OffsetLoadNodeGen();
        }

        @NeverDefault
        public static LLVMI8OffsetLoadNode getUncached() {
            return LLVMI8OffsetLoadNodeGen.UNCACHED;
        }

        @GeneratedBy(LLVMI8OffsetLoadNode.class)
        @DenyReplace
        private static final class I8Managed0Data extends Node implements SpecializationDataNode {

            @Child I8Managed0Data next_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link LLVMI8OffsetLoadNode#doI8Managed}
             *   Parameter: {@link LLVMManagedReadLibrary} nativeRead</pre>
             */
            @Child LLVMManagedReadLibrary nativeRead_;

            I8Managed0Data(I8Managed0Data next_) {
                this.next_ = next_;
            }

        }
        @GeneratedBy(LLVMI8OffsetLoadNode.class)
        @DenyReplace
        private static final class Uncached extends LLVMI8OffsetLoadNode implements UnadoptableNode {

            @TruffleBoundary
            @Override
            public Object executeWithTargetGeneric(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doI8Native(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return doI8DerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doI8Managed(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject())));
                }
                throw newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public byte executeWithTarget(LLVMPointer arg0Value, long arg1Value) {
                if (LLVMTypes.isNativePointer(arg0Value)) {
                    LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                    if ((!(isAutoDerefHandle(arg0Value_)))) {
                        return doI8Native(arg0Value_, arg1Value);
                    }
                    if ((isAutoDerefHandle(arg0Value_))) {
                        return doI8DerefHandle(arg0Value_, arg1Value, (LLVMDerefHandleGetReceiverNodeGen.getUncached()), (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached()));
                    }
                }
                if (LLVMTypes.isManagedPointer(arg0Value)) {
                    LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                    return doI8Managed(arg0Value_, arg1Value, (L_L_V_M_MANAGED_READ_LIBRARY_.getUncached(arg0Value_.getObject())));
                }
                throw newUnsupportedSpecializationException2LJ(this, arg0Value, arg1Value);
            }

        }
    }
}
