// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.load.LLVMDerefHandleGetReceiverNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMPointerStoreNode.LLVMPointerOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMDoubleVector)}
 *     Activation probability: 0.07323
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVectorDerefHandle}
 *     Activation probability: 0.07046
 *     With/without class size: 5/8 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMFloatVector)}
 *     Activation probability: 0.06769
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI16Vector)}
 *     Activation probability: 0.06492
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI1Vector)}
 *     Activation probability: 0.06215
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI32Vector)}
 *     Activation probability: 0.05938
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI64Vector)}
 *     Activation probability: 0.05662
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI8Vector)}
 *     Activation probability: 0.05385
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)}
 *     Activation probability: 0.05108
 *     With/without class size: 5/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.04831
 *     With/without class size: 5/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.04554
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.04277
 *     With/without class size: 5/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.04000
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.03723
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.03446
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.03169
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.02892
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.02615
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.02338
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.02062
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.01785
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.01508
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.01231
 *     With/without class size: 4/0 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.00954
 *     With/without class size: 4/4 bytes
 *   Specialization {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)}
 *     Activation probability: 0.00677
 *     With/without class size: 4/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMStoreVectorNode.class)
@SuppressWarnings({"javadoc", "unused"})
public final class LLVMStoreVectorNodeGen extends LLVMStoreVectorNode implements GenerateAOT.Provider {

    static final ReferenceField<WriteVector8Data> WRITE_VECTOR8_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector8_cache", WriteVector8Data.class);
    static final ReferenceField<WriteVector10Data> WRITE_VECTOR10_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector10_cache", WriteVector10Data.class);
    static final ReferenceField<WriteVector12Data> WRITE_VECTOR12_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector12_cache", WriteVector12Data.class);
    static final ReferenceField<WriteVector14Data> WRITE_VECTOR14_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector14_cache", WriteVector14Data.class);
    static final ReferenceField<WriteVector16Data> WRITE_VECTOR16_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector16_cache", WriteVector16Data.class);
    static final ReferenceField<WriteVector18Data> WRITE_VECTOR18_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector18_cache", WriteVector18Data.class);
    static final ReferenceField<WriteVector20Data> WRITE_VECTOR20_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector20_cache", WriteVector20Data.class);
    static final ReferenceField<WriteVector22Data> WRITE_VECTOR22_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "writeVector22_cache", WriteVector22Data.class);
    private static final LibraryFactory<LLVMManagedWriteLibrary> L_L_V_M_MANAGED_WRITE_LIBRARY_ = LibraryFactory.resolve(LLVMManagedWriteLibrary.class);

    private final int vectorLength;
    @Child private LLVMExpressionNode address_;
    @Child private LLVMExpressionNode value_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMDoubleVector)}
     *   2: SpecializationActive {@link LLVMStoreVectorNode#writeVectorDerefHandle}
     *   3: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMFloatVector)}
     *   4: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI16Vector)}
     *   5: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI1Vector)}
     *   6: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI32Vector)}
     *   7: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI64Vector)}
     *   8: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMI8Vector)}
     *   9: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)}
     *   10: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)}
     *   11: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)}
     *   12: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)}
     *   13: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)}
     *   14: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)}
     *   15: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)}
     *   16: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)}
     *   17: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)}
     *   18: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)}
     *   19: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)}
     *   20: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)}
     *   21: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)}
     *   22: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)}
     *   23: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)}
     *   24: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)}
     *   25: SpecializationActive {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @Child private WriteVectorDerefHandleData writeVectorDerefHandle_cache;
    @Child private WriteVector7Data writeVector7_cache;
    @UnsafeAccessedField @Child private WriteVector8Data writeVector8_cache;
    @UnsafeAccessedField @Child private WriteVector10Data writeVector10_cache;
    @UnsafeAccessedField @Child private WriteVector12Data writeVector12_cache;
    @UnsafeAccessedField @Child private WriteVector14Data writeVector14_cache;
    @UnsafeAccessedField @Child private WriteVector16Data writeVector16_cache;
    @UnsafeAccessedField @Child private WriteVector18Data writeVector18_cache;
    @UnsafeAccessedField @Child private WriteVector20Data writeVector20_cache;
    @UnsafeAccessedField @Child private WriteVector22Data writeVector22_cache;

    private LLVMStoreVectorNodeGen(LLVMExpressionNode address, LLVMExpressionNode value, int vectorLength) {
        this.vectorLength = vectorLength;
        this.address_ = address;
        this.value_ = value;
    }

    private LLVMStoreVectorNodeGen(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, int vectorLength) {
        super(isRecursive);
        this.vectorLength = vectorLength;
        this.address_ = address;
        this.value_ = value;
    }

    @Override
    public int getVectorLength() {
        return this.vectorLength;
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(VirtualFrame frameValue, Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0x3fffffe) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] || SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] || SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] */ && valueValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector valueValue_ = (LLVMDoubleVector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] */) {
                    WriteVectorDerefHandleData s1_ = this.writeVectorDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue_))) {
                            writeVectorDerefHandle(addressValue_, valueValue, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] */ && valueValue instanceof LLVMFloatVector) {
                    LLVMFloatVector valueValue_ = (LLVMFloatVector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] */ && valueValue instanceof LLVMI16Vector) {
                    LLVMI16Vector valueValue_ = (LLVMI16Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] */ && valueValue instanceof LLVMI1Vector) {
                    LLVMI1Vector valueValue_ = (LLVMI1Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] */ && valueValue instanceof LLVMI32Vector) {
                    LLVMI32Vector valueValue_ = (LLVMI32Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] */ && valueValue instanceof LLVMI64Vector) {
                    LLVMI64Vector valueValue_ = (LLVMI64Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] */ && valueValue instanceof LLVMI8Vector) {
                    LLVMI8Vector valueValue_ = (LLVMI8Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */ && valueValue instanceof LLVMPointerVector) {
                    LLVMPointerVector valueValue_ = (LLVMPointerVector) valueValue;
                    WriteVector7Data s8_ = this.writeVector7_cache;
                    if (s8_ != null) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            writeVector(addressValue_, valueValue_, s8_.write_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0x3fffc00) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI1Vector) {
                    LLVMI1Vector valueValue_ = (LLVMI1Vector) valueValue;
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector8Data s9_ = this.writeVector8_cache;
                        while (s9_ != null) {
                            if ((s9_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s9_.nativeWrite_);
                                return;
                            }
                            s9_ = s9_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector9Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b11000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI8Vector) {
                    LLVMI8Vector valueValue_ = (LLVMI8Vector) valueValue;
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector10Data s11_ = this.writeVector10_cache;
                        while (s11_ != null) {
                            if ((s11_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s11_.nativeWrite_);
                                return;
                            }
                            s11_ = s11_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector11Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b1100000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI16Vector) {
                    LLVMI16Vector valueValue_ = (LLVMI16Vector) valueValue;
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector12Data s13_ = this.writeVector12_cache;
                        while (s13_ != null) {
                            if ((s13_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s13_.nativeWrite_);
                                return;
                            }
                            s13_ = s13_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector13Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0x30000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI32Vector) {
                    LLVMI32Vector valueValue_ = (LLVMI32Vector) valueValue;
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector14Data s15_ = this.writeVector14_cache;
                        while (s15_ != null) {
                            if ((s15_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s15_.nativeWrite_);
                                return;
                            }
                            s15_ = s15_.next_;
                        }
                    }
                    if ((state_0 & 0x20000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector15Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0xc0000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMFloatVector) {
                    LLVMFloatVector valueValue_ = (LLVMFloatVector) valueValue;
                    if ((state_0 & 0x40000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector16Data s17_ = this.writeVector16_cache;
                        while (s17_ != null) {
                            if ((s17_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s17_.nativeWrite_);
                                return;
                            }
                            s17_ = s17_.next_;
                        }
                    }
                    if ((state_0 & 0x80000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector17Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0x300000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector valueValue_ = (LLVMDoubleVector) valueValue;
                    if ((state_0 & 0x100000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector18Data s19_ = this.writeVector18_cache;
                        while (s19_ != null) {
                            if ((s19_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s19_.nativeWrite_);
                                return;
                            }
                            s19_ = s19_.next_;
                        }
                    }
                    if ((state_0 & 0x200000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector19Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0xc00000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI64Vector) {
                    LLVMI64Vector valueValue_ = (LLVMI64Vector) valueValue;
                    if ((state_0 & 0x400000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector20Data s21_ = this.writeVector20_cache;
                        while (s21_ != null) {
                            if ((s21_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s21_.nativeWrite_);
                                return;
                            }
                            s21_ = s21_.next_;
                        }
                    }
                    if ((state_0 & 0x800000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector21Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0x3000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMPointerVector) {
                    LLVMPointerVector valueValue_ = (LLVMPointerVector) valueValue;
                    if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector22Data s23_ = this.writeVector22_cache;
                        while (s23_ != null) {
                            if ((s23_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s23_.nativeWrite_);
                                return;
                            }
                            s23_ = s23_.next_;
                        }
                    }
                    if ((state_0 & 0x2000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector23Boundary(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector9Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMI1Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector11Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMI8Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector13Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMI16Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__2 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__2);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector15Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMI32Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__3 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__3);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector17Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMFloatVector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__4 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__4);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector19Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMDoubleVector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__5 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__5);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector21Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMI64Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__6 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__6);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector23Boundary(int state_0, LLVMManagedPointer addressValue_, LLVMPointerVector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__7 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__7);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public void executeWithTarget(LLVMPointer addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue, valueValue);
            return;
        }
        if ((state_0 & 0x3fffffe) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] || SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] || SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */ && LLVMTypes.isNativePointer(addressValue)) {
                LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] */ && valueValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector valueValue_ = (LLVMDoubleVector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] */) {
                    WriteVectorDerefHandleData s1_ = this.writeVectorDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue_))) {
                            writeVectorDerefHandle(addressValue_, valueValue, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] */ && valueValue instanceof LLVMFloatVector) {
                    LLVMFloatVector valueValue_ = (LLVMFloatVector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] */ && valueValue instanceof LLVMI16Vector) {
                    LLVMI16Vector valueValue_ = (LLVMI16Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] */ && valueValue instanceof LLVMI1Vector) {
                    LLVMI1Vector valueValue_ = (LLVMI1Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] */ && valueValue instanceof LLVMI32Vector) {
                    LLVMI32Vector valueValue_ = (LLVMI32Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] */ && valueValue instanceof LLVMI64Vector) {
                    LLVMI64Vector valueValue_ = (LLVMI64Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] */ && valueValue instanceof LLVMI8Vector) {
                    LLVMI8Vector valueValue_ = (LLVMI8Vector) valueValue;
                    if ((!(isAutoDerefHandle(addressValue_)))) {
                        writeVector(addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */ && valueValue instanceof LLVMPointerVector) {
                    LLVMPointerVector valueValue_ = (LLVMPointerVector) valueValue;
                    WriteVector7Data s8_ = this.writeVector7_cache;
                    if (s8_ != null) {
                        if ((!(isAutoDerefHandle(addressValue_)))) {
                            writeVector(addressValue_, valueValue_, s8_.write_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0x3fffc00) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue)) {
                LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
                if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI1Vector) {
                    LLVMI1Vector valueValue_ = (LLVMI1Vector) valueValue;
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector8Data s9_ = this.writeVector8_cache;
                        while (s9_ != null) {
                            if ((s9_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s9_.nativeWrite_);
                                return;
                            }
                            s9_ = s9_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector9Boundary0(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b11000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI8Vector) {
                    LLVMI8Vector valueValue_ = (LLVMI8Vector) valueValue;
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector10Data s11_ = this.writeVector10_cache;
                        while (s11_ != null) {
                            if ((s11_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s11_.nativeWrite_);
                                return;
                            }
                            s11_ = s11_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector11Boundary1(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0b1100000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI16Vector) {
                    LLVMI16Vector valueValue_ = (LLVMI16Vector) valueValue;
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector12Data s13_ = this.writeVector12_cache;
                        while (s13_ != null) {
                            if ((s13_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s13_.nativeWrite_);
                                return;
                            }
                            s13_ = s13_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector13Boundary2(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0x30000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI32Vector) {
                    LLVMI32Vector valueValue_ = (LLVMI32Vector) valueValue;
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector14Data s15_ = this.writeVector14_cache;
                        while (s15_ != null) {
                            if ((s15_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s15_.nativeWrite_);
                                return;
                            }
                            s15_ = s15_.next_;
                        }
                    }
                    if ((state_0 & 0x20000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector15Boundary3(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0xc0000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMFloatVector) {
                    LLVMFloatVector valueValue_ = (LLVMFloatVector) valueValue;
                    if ((state_0 & 0x40000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector16Data s17_ = this.writeVector16_cache;
                        while (s17_ != null) {
                            if ((s17_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s17_.nativeWrite_);
                                return;
                            }
                            s17_ = s17_.next_;
                        }
                    }
                    if ((state_0 & 0x80000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector17Boundary4(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0x300000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMDoubleVector) {
                    LLVMDoubleVector valueValue_ = (LLVMDoubleVector) valueValue;
                    if ((state_0 & 0x100000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector18Data s19_ = this.writeVector18_cache;
                        while (s19_ != null) {
                            if ((s19_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s19_.nativeWrite_);
                                return;
                            }
                            s19_ = s19_.next_;
                        }
                    }
                    if ((state_0 & 0x200000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector19Boundary5(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0xc00000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMI64Vector) {
                    LLVMI64Vector valueValue_ = (LLVMI64Vector) valueValue;
                    if ((state_0 & 0x400000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector20Data s21_ = this.writeVector20_cache;
                        while (s21_ != null) {
                            if ((s21_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s21_.nativeWrite_);
                                return;
                            }
                            s21_ = s21_.next_;
                        }
                    }
                    if ((state_0 & 0x800000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector21Boundary6(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
                if ((state_0 & 0x3000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */ && valueValue instanceof LLVMPointerVector) {
                    LLVMPointerVector valueValue_ = (LLVMPointerVector) valueValue;
                    if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector22Data s23_ = this.writeVector22_cache;
                        while (s23_ != null) {
                            if ((s23_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                writeVector(addressValue_, valueValue_, s23_.nativeWrite_);
                                return;
                            }
                            s23_ = s23_.next_;
                        }
                    }
                    if ((state_0 & 0x2000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector23Boundary7(state_0, addressValue_, valueValue_);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue, valueValue);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector9Boundary0(int state_0, LLVMManagedPointer addressValue_, LLVMI1Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector11Boundary1(int state_0, LLVMManagedPointer addressValue_, LLVMI8Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector13Boundary2(int state_0, LLVMManagedPointer addressValue_, LLVMI16Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__2 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__2);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector15Boundary3(int state_0, LLVMManagedPointer addressValue_, LLVMI32Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__3 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__3);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector17Boundary4(int state_0, LLVMManagedPointer addressValue_, LLVMFloatVector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__4 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__4);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector19Boundary5(int state_0, LLVMManagedPointer addressValue_, LLVMDoubleVector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__5 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__5);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector21Boundary6(int state_0, LLVMManagedPointer addressValue_, LLVMI64Vector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__6 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__6);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector23Boundary7(int state_0, LLVMManagedPointer addressValue_, LLVMPointerVector valueValue_) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__7 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                writeVector(addressValue_, valueValue_, nativeWrite__7);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @ExplodeLoop
    @Override
    public void execute(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object addressValue_ = this.address_.executeGeneric(frameValue);
        Object valueValue_ = this.value_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            executeAndSpecialize(addressValue_, valueValue_);
            return;
        }
        if ((state_0 & 0x3fffffe) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] || SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
            if ((state_0 & 0b1111111110) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] || SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */ && LLVMTypes.isNativePointer(addressValue_)) {
                LLVMNativePointer addressValue__ = LLVMTypes.asNativePointer(addressValue_);
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] */ && valueValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector valueValue__ = (LLVMDoubleVector) valueValue_;
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        writeVector(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] */) {
                    WriteVectorDerefHandleData s1_ = this.writeVectorDerefHandle_cache;
                    if (s1_ != null) {
                        assert DSLSupport.assertIdempotence((!(isRecursive)));
                        if ((isAutoDerefHandle(addressValue__))) {
                            writeVectorDerefHandle(addressValue__, valueValue_, s1_.getReceiver_, s1_.store_);
                            return;
                        }
                    }
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] */ && valueValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector valueValue__ = (LLVMFloatVector) valueValue_;
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        writeVector(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] */ && valueValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector valueValue__ = (LLVMI16Vector) valueValue_;
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        writeVector(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] */ && valueValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector valueValue__ = (LLVMI1Vector) valueValue_;
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        writeVector(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] */ && valueValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector valueValue__ = (LLVMI32Vector) valueValue_;
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        writeVector(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] */ && valueValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector valueValue__ = (LLVMI64Vector) valueValue_;
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        writeVector(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] */ && valueValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector valueValue__ = (LLVMI8Vector) valueValue_;
                    if ((!(isAutoDerefHandle(addressValue__)))) {
                        writeVector(addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */ && valueValue_ instanceof LLVMPointerVector) {
                    LLVMPointerVector valueValue__ = (LLVMPointerVector) valueValue_;
                    WriteVector7Data s8_ = this.writeVector7_cache;
                    if (s8_ != null) {
                        if ((!(isAutoDerefHandle(addressValue__)))) {
                            writeVector(addressValue__, valueValue__, s8_.write_);
                            return;
                        }
                    }
                }
            }
            if ((state_0 & 0x3fffc00) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */ && LLVMTypes.isManagedPointer(addressValue_)) {
                LLVMManagedPointer addressValue__ = LLVMTypes.asManagedPointer(addressValue_);
                if ((state_0 & 0b110000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMI1Vector) {
                    LLVMI1Vector valueValue__ = (LLVMI1Vector) valueValue_;
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector8Data s9_ = this.writeVector8_cache;
                        while (s9_ != null) {
                            if ((s9_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s9_.nativeWrite_);
                                return;
                            }
                            s9_ = s9_.next_;
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector9Boundary8(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b11000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMI8Vector) {
                    LLVMI8Vector valueValue__ = (LLVMI8Vector) valueValue_;
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector10Data s11_ = this.writeVector10_cache;
                        while (s11_ != null) {
                            if ((s11_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s11_.nativeWrite_);
                                return;
                            }
                            s11_ = s11_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector11Boundary9(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0b1100000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMI16Vector) {
                    LLVMI16Vector valueValue__ = (LLVMI16Vector) valueValue_;
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector12Data s13_ = this.writeVector12_cache;
                        while (s13_ != null) {
                            if ((s13_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s13_.nativeWrite_);
                                return;
                            }
                            s13_ = s13_.next_;
                        }
                    }
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector13Boundary10(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0x30000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMI32Vector) {
                    LLVMI32Vector valueValue__ = (LLVMI32Vector) valueValue_;
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector14Data s15_ = this.writeVector14_cache;
                        while (s15_ != null) {
                            if ((s15_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s15_.nativeWrite_);
                                return;
                            }
                            s15_ = s15_.next_;
                        }
                    }
                    if ((state_0 & 0x20000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector15Boundary11(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0xc0000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMFloatVector) {
                    LLVMFloatVector valueValue__ = (LLVMFloatVector) valueValue_;
                    if ((state_0 & 0x40000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector16Data s17_ = this.writeVector16_cache;
                        while (s17_ != null) {
                            if ((s17_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s17_.nativeWrite_);
                                return;
                            }
                            s17_ = s17_.next_;
                        }
                    }
                    if ((state_0 & 0x80000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector17Boundary12(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0x300000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMDoubleVector) {
                    LLVMDoubleVector valueValue__ = (LLVMDoubleVector) valueValue_;
                    if ((state_0 & 0x100000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector18Data s19_ = this.writeVector18_cache;
                        while (s19_ != null) {
                            if ((s19_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s19_.nativeWrite_);
                                return;
                            }
                            s19_ = s19_.next_;
                        }
                    }
                    if ((state_0 & 0x200000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector19Boundary13(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0xc00000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMI64Vector) {
                    LLVMI64Vector valueValue__ = (LLVMI64Vector) valueValue_;
                    if ((state_0 & 0x400000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */) {
                        WriteVector20Data s21_ = this.writeVector20_cache;
                        while (s21_ != null) {
                            if ((s21_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s21_.nativeWrite_);
                                return;
                            }
                            s21_ = s21_.next_;
                        }
                    }
                    if ((state_0 & 0x800000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector21Boundary14(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
                if ((state_0 & 0x3000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] || SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */ && valueValue_ instanceof LLVMPointerVector) {
                    LLVMPointerVector valueValue__ = (LLVMPointerVector) valueValue_;
                    if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
                        WriteVector22Data s23_ = this.writeVector22_cache;
                        while (s23_ != null) {
                            if ((s23_.nativeWrite_.accepts(addressValue__.getObject()))) {
                                writeVector(addressValue__, valueValue__, s23_.nativeWrite_);
                                return;
                            }
                            s23_ = s23_.next_;
                        }
                    }
                    if ((state_0 & 0x2000000) != 0 /* is SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
                        this.writeVector23Boundary15(state_0, addressValue__, valueValue__);
                        return;
                    }
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        executeAndSpecialize(addressValue_, valueValue_);
        return;
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector9Boundary8(int state_0, LLVMManagedPointer addressValue__, LLVMI1Vector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector11Boundary9(int state_0, LLVMManagedPointer addressValue__, LLVMI8Vector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__1);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector13Boundary10(int state_0, LLVMManagedPointer addressValue__, LLVMI16Vector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__2 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__2);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector15Boundary11(int state_0, LLVMManagedPointer addressValue__, LLVMI32Vector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__3 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__3);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector17Boundary12(int state_0, LLVMManagedPointer addressValue__, LLVMFloatVector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__4 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__4);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector19Boundary13(int state_0, LLVMManagedPointer addressValue__, LLVMDoubleVector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__5 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__5);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector21Boundary14(int state_0, LLVMManagedPointer addressValue__, LLVMI64Vector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__6 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__6);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    @SuppressWarnings("static-method")
    @TruffleBoundary
    private void writeVector23Boundary15(int state_0, LLVMManagedPointer addressValue__, LLVMPointerVector valueValue__) {
        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
        Node prev_ = encapsulating_.set(this);
        try {
            {
                LLVMManagedWriteLibrary nativeWrite__7 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue__.getObject()));
                writeVector(addressValue__, valueValue__, nativeWrite__7);
                return;
            }
        } finally {
            encapsulating_.set(prev_);
        }
    }

    private void executeAndSpecialize(Object addressValue, Object valueValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (LLVMTypes.isNativePointer(addressValue)) {
            LLVMNativePointer addressValue_ = LLVMTypes.asNativePointer(addressValue);
            if (valueValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector valueValue_ = (LLVMDoubleVector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_);
                    return;
                }
            }
            if ((!(isRecursive)) && (isAutoDerefHandle(addressValue_))) {
                WriteVectorDerefHandleData s1_ = this.insert(new WriteVectorDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.getReceiver_ = getReceiver__;
                s1_.store_ = s1_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.writeVectorDerefHandle_cache = s1_;
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] */;
                this.state_0_ = state_0;
                writeVectorDerefHandle(addressValue_, valueValue, getReceiver__, s1_.store_);
                return;
            }
            if (valueValue instanceof LLVMFloatVector) {
                LLVMFloatVector valueValue_ = (LLVMFloatVector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_);
                    return;
                }
            }
            if (valueValue instanceof LLVMI16Vector) {
                LLVMI16Vector valueValue_ = (LLVMI16Vector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_);
                    return;
                }
            }
            if (valueValue instanceof LLVMI1Vector) {
                LLVMI1Vector valueValue_ = (LLVMI1Vector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_);
                    return;
                }
            }
            if (valueValue instanceof LLVMI32Vector) {
                LLVMI32Vector valueValue_ = (LLVMI32Vector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b1000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_);
                    return;
                }
            }
            if (valueValue instanceof LLVMI64Vector) {
                LLVMI64Vector valueValue_ = (LLVMI64Vector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_);
                    return;
                }
            }
            if (valueValue instanceof LLVMI8Vector) {
                LLVMI8Vector valueValue_ = (LLVMI8Vector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_);
                    return;
                }
            }
            if (valueValue instanceof LLVMPointerVector) {
                LLVMPointerVector valueValue_ = (LLVMPointerVector) valueValue;
                if ((!(isAutoDerefHandle(addressValue_)))) {
                    WriteVector7Data s8_ = this.insert(new WriteVector7Data());
                    s8_.write_ = s8_.insert((LLVMPointerOffsetStoreNode.create()));
                    VarHandle.storeStoreFence();
                    this.writeVector7_cache = s8_;
                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */;
                    this.state_0_ = state_0;
                    writeVector(addressValue_, valueValue_, s8_.write_);
                    return;
                }
            }
        }
        if (LLVMTypes.isManagedPointer(addressValue)) {
            LLVMManagedPointer addressValue_ = LLVMTypes.asManagedPointer(addressValue);
            if (valueValue instanceof LLVMI1Vector) {
                LLVMI1Vector valueValue_ = (LLVMI1Vector) valueValue;
                if (((state_0 & 0b100000000000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count9_ = 0;
                        WriteVector8Data s9_ = WRITE_VECTOR8_CACHE_UPDATER.getVolatile(this);
                        WriteVector8Data s9_original = s9_;
                        while (s9_ != null) {
                            if ((s9_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count9_++;
                            s9_ = s9_.next_;
                        }
                        if (s9_ == null) {
                            // assert (s9_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count9_ < (3)) {
                                s9_ = this.insert(new WriteVector8Data(s9_original));
                                LLVMManagedWriteLibrary nativeWrite__ = s9_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s9_.nativeWrite_ = nativeWrite__;
                                if (!WRITE_VECTOR8_CACHE_UPDATER.compareAndSet(this, s9_original, s9_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b10000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s9_ != null) {
                            writeVector(addressValue_, valueValue_, s9_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__ = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__ = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector8_cache = null;
                            state_0 = state_0 & 0xfffffbff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0b100000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (valueValue instanceof LLVMI8Vector) {
                LLVMI8Vector valueValue_ = (LLVMI8Vector) valueValue;
                if (((state_0 & 0b10000000000000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count11_ = 0;
                        WriteVector10Data s11_ = WRITE_VECTOR10_CACHE_UPDATER.getVolatile(this);
                        WriteVector10Data s11_original = s11_;
                        while (s11_ != null) {
                            if ((s11_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count11_++;
                            s11_ = s11_.next_;
                        }
                        if (s11_ == null) {
                            // assert (s11_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count11_ < (3)) {
                                s11_ = this.insert(new WriteVector10Data(s11_original));
                                LLVMManagedWriteLibrary nativeWrite__1 = s11_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s11_.nativeWrite_ = nativeWrite__1;
                                if (!WRITE_VECTOR10_CACHE_UPDATER.compareAndSet(this, s11_original, s11_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s11_ != null) {
                            writeVector(addressValue_, valueValue_, s11_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__1 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__1 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector10_cache = null;
                            state_0 = state_0 & 0xffffefff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__1);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (valueValue instanceof LLVMI16Vector) {
                LLVMI16Vector valueValue_ = (LLVMI16Vector) valueValue;
                if (((state_0 & 0b1000000000000000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count13_ = 0;
                        WriteVector12Data s13_ = WRITE_VECTOR12_CACHE_UPDATER.getVolatile(this);
                        WriteVector12Data s13_original = s13_;
                        while (s13_ != null) {
                            if ((s13_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count13_++;
                            s13_ = s13_.next_;
                        }
                        if (s13_ == null) {
                            // assert (s13_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count13_ < (3)) {
                                s13_ = this.insert(new WriteVector12Data(s13_original));
                                LLVMManagedWriteLibrary nativeWrite__2 = s13_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s13_.nativeWrite_ = nativeWrite__2;
                                if (!WRITE_VECTOR12_CACHE_UPDATER.compareAndSet(this, s13_original, s13_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s13_ != null) {
                            writeVector(addressValue_, valueValue_, s13_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__2 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__2 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector12_cache = null;
                            state_0 = state_0 & 0xffffbfff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__2);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (valueValue instanceof LLVMI32Vector) {
                LLVMI32Vector valueValue_ = (LLVMI32Vector) valueValue;
                if (((state_0 & 0x20000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count15_ = 0;
                        WriteVector14Data s15_ = WRITE_VECTOR14_CACHE_UPDATER.getVolatile(this);
                        WriteVector14Data s15_original = s15_;
                        while (s15_ != null) {
                            if ((s15_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count15_++;
                            s15_ = s15_.next_;
                        }
                        if (s15_ == null) {
                            // assert (s15_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count15_ < (3)) {
                                s15_ = this.insert(new WriteVector14Data(s15_original));
                                LLVMManagedWriteLibrary nativeWrite__3 = s15_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__3, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s15_.nativeWrite_ = nativeWrite__3;
                                if (!WRITE_VECTOR14_CACHE_UPDATER.compareAndSet(this, s15_original, s15_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0x10000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s15_ != null) {
                            writeVector(addressValue_, valueValue_, s15_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__3 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__3 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector14_cache = null;
                            state_0 = state_0 & 0xfffeffff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0x20000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__3);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (valueValue instanceof LLVMFloatVector) {
                LLVMFloatVector valueValue_ = (LLVMFloatVector) valueValue;
                if (((state_0 & 0x80000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count17_ = 0;
                        WriteVector16Data s17_ = WRITE_VECTOR16_CACHE_UPDATER.getVolatile(this);
                        WriteVector16Data s17_original = s17_;
                        while (s17_ != null) {
                            if ((s17_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count17_++;
                            s17_ = s17_.next_;
                        }
                        if (s17_ == null) {
                            // assert (s17_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count17_ < (3)) {
                                s17_ = this.insert(new WriteVector16Data(s17_original));
                                LLVMManagedWriteLibrary nativeWrite__4 = s17_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__4, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s17_.nativeWrite_ = nativeWrite__4;
                                if (!WRITE_VECTOR16_CACHE_UPDATER.compareAndSet(this, s17_original, s17_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0x40000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s17_ != null) {
                            writeVector(addressValue_, valueValue_, s17_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__4 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__4 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector16_cache = null;
                            state_0 = state_0 & 0xfffbffff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0x80000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__4);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (valueValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector valueValue_ = (LLVMDoubleVector) valueValue;
                if (((state_0 & 0x200000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count19_ = 0;
                        WriteVector18Data s19_ = WRITE_VECTOR18_CACHE_UPDATER.getVolatile(this);
                        WriteVector18Data s19_original = s19_;
                        while (s19_ != null) {
                            if ((s19_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count19_++;
                            s19_ = s19_.next_;
                        }
                        if (s19_ == null) {
                            // assert (s19_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count19_ < (3)) {
                                s19_ = this.insert(new WriteVector18Data(s19_original));
                                LLVMManagedWriteLibrary nativeWrite__5 = s19_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__5, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s19_.nativeWrite_ = nativeWrite__5;
                                if (!WRITE_VECTOR18_CACHE_UPDATER.compareAndSet(this, s19_original, s19_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0x100000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s19_ != null) {
                            writeVector(addressValue_, valueValue_, s19_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__5 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__5 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector18_cache = null;
                            state_0 = state_0 & 0xffefffff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0x200000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__5);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (valueValue instanceof LLVMI64Vector) {
                LLVMI64Vector valueValue_ = (LLVMI64Vector) valueValue;
                if (((state_0 & 0x800000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count21_ = 0;
                        WriteVector20Data s21_ = WRITE_VECTOR20_CACHE_UPDATER.getVolatile(this);
                        WriteVector20Data s21_original = s21_;
                        while (s21_ != null) {
                            if ((s21_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count21_++;
                            s21_ = s21_.next_;
                        }
                        if (s21_ == null) {
                            // assert (s21_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count21_ < (3)) {
                                s21_ = this.insert(new WriteVector20Data(s21_original));
                                LLVMManagedWriteLibrary nativeWrite__6 = s21_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__6, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s21_.nativeWrite_ = nativeWrite__6;
                                if (!WRITE_VECTOR20_CACHE_UPDATER.compareAndSet(this, s21_original, s21_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0x400000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s21_ != null) {
                            writeVector(addressValue_, valueValue_, s21_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__6 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__6 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector20_cache = null;
                            state_0 = state_0 & 0xffbfffff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0x800000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__6);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
            if (valueValue instanceof LLVMPointerVector) {
                LLVMPointerVector valueValue_ = (LLVMPointerVector) valueValue;
                if (((state_0 & 0x2000000)) == 0 /* is-not SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */) {
                    while (true) {
                        int count23_ = 0;
                        WriteVector22Data s23_ = WRITE_VECTOR22_CACHE_UPDATER.getVolatile(this);
                        WriteVector22Data s23_original = s23_;
                        while (s23_ != null) {
                            if ((s23_.nativeWrite_.accepts(addressValue_.getObject()))) {
                                break;
                            }
                            count23_++;
                            s23_ = s23_.next_;
                        }
                        if (s23_ == null) {
                            // assert (s23_.nativeWrite_.accepts(addressValue_.getObject()));
                            if (count23_ < (3)) {
                                s23_ = this.insert(new WriteVector22Data(s23_original));
                                LLVMManagedWriteLibrary nativeWrite__7 = s23_.insert((L_L_V_M_MANAGED_WRITE_LIBRARY_.create(addressValue_.getObject())));
                                Objects.requireNonNull(nativeWrite__7, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                                s23_.nativeWrite_ = nativeWrite__7;
                                if (!WRITE_VECTOR22_CACHE_UPDATER.compareAndSet(this, s23_original, s23_)) {
                                    continue;
                                }
                                state_0 = state_0 | 0x1000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */;
                                this.state_0_ = state_0;
                            }
                        }
                        if (s23_ != null) {
                            writeVector(addressValue_, valueValue_, s23_.nativeWrite_);
                            return;
                        }
                        break;
                    }
                }
                {
                    LLVMManagedWriteLibrary nativeWrite__7 = null;
                    {
                        EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
                        Node prev_ = encapsulating_.set(this);
                        try {
                            nativeWrite__7 = (L_L_V_M_MANAGED_WRITE_LIBRARY_.getUncached(addressValue_.getObject()));
                            this.writeVector22_cache = null;
                            state_0 = state_0 & 0xfeffffff /* remove SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */;
                            state_0 = state_0 | 0x2000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)] */;
                            this.state_0_ = state_0;
                            writeVector(addressValue_, valueValue_, nativeWrite__7);
                            return;
                        } finally {
                            encapsulating_.set(prev_);
                        }
                    }
                }
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.address_, this.value_}, addressValue, valueValue);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMDoubleVector)] */;
        }
        {
            if ((!(isRecursive))) {
                WriteVectorDerefHandleData s1_ = this.insert(new WriteVectorDerefHandleData());
                LLVMDerefHandleGetReceiverNode getReceiver__ = s1_.insert((LLVMDerefHandleGetReceiverNodeGen.create()));
                Objects.requireNonNull(getReceiver__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s1_.getReceiver_ = getReceiver__;
                s1_.store_ = s1_.insert((createRecursive()));
                VarHandle.storeStoreFence();
                this.writeVectorDerefHandle_cache = s1_;
                assert NodeUtil.assertRecursion(s1_.getReceiver_, 1);
                ((GenerateAOT.Provider) s1_.getReceiver_).prepareForAOT(language, root);
                assert NodeUtil.assertRecursion(s1_.store_, 1);
                ((GenerateAOT.Provider) s1_.store_).prepareForAOT(language, root);
                this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMStoreVectorNode.writeVectorDerefHandle(LLVMNativePointer, Object, LLVMDerefHandleGetReceiverNode, LLVMStoreVectorNode)] */;
            }
        }
        {
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMFloatVector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI16Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI1Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b1000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI32Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b10000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI64Vector)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMI8Vector)] */;
        }
        {
            WriteVector7Data s8_ = this.insert(new WriteVector7Data());
            s8_.write_ = s8_.insert((LLVMPointerOffsetStoreNode.create()));
            VarHandle.storeStoreFence();
            this.writeVector7_cache = s8_;
            assert NodeUtil.assertRecursion(s8_.write_, 1);
            ((GenerateAOT.Provider) s8_.write_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000000000 /* add SpecializationActive[LLVMStoreVectorNode.writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.writeVectorDerefHandle_cache = null;
        this.writeVector7_cache = null;
    }

    @NeverDefault
    public static LLVMStoreVectorNode create(LLVMExpressionNode address, LLVMExpressionNode value, int vectorLength) {
        return new LLVMStoreVectorNodeGen(address, value, vectorLength);
    }

    @NeverDefault
    public static LLVMStoreVectorNode create(boolean isRecursive, LLVMExpressionNode address, LLVMExpressionNode value, int vectorLength) {
        return new LLVMStoreVectorNodeGen(isRecursive, address, value, vectorLength);
    }

    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVectorDerefHandleData extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVectorDerefHandle}
         *   Parameter: {@link LLVMDerefHandleGetReceiverNode} getReceiver</pre>
         */
        @Child LLVMDerefHandleGetReceiverNode getReceiver_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVectorDerefHandle}
         *   Parameter: {@link LLVMStoreVectorNode} store</pre>
         */
        @Child LLVMStoreVectorNode store_;

        WriteVectorDerefHandleData() {
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector7Data extends Node implements SpecializationDataNode {

        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMNativePointer, LLVMPointerVector, LLVMPointerOffsetStoreNode)}
         *   Parameter: {@link LLVMPointerOffsetStoreNode} write</pre>
         */
        @Child LLVMPointerOffsetStoreNode write_;

        WriteVector7Data() {
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector8Data extends Node implements SpecializationDataNode {

        @Child WriteVector8Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI1Vector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector8Data(WriteVector8Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector10Data extends Node implements SpecializationDataNode {

        @Child WriteVector10Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI8Vector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector10Data(WriteVector10Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector12Data extends Node implements SpecializationDataNode {

        @Child WriteVector12Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI16Vector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector12Data(WriteVector12Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector14Data extends Node implements SpecializationDataNode {

        @Child WriteVector14Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI32Vector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector14Data(WriteVector14Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector16Data extends Node implements SpecializationDataNode {

        @Child WriteVector16Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMFloatVector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector16Data(WriteVector16Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector18Data extends Node implements SpecializationDataNode {

        @Child WriteVector18Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMDoubleVector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector18Data(WriteVector18Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector20Data extends Node implements SpecializationDataNode {

        @Child WriteVector20Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMI64Vector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector20Data(WriteVector20Data next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(LLVMStoreVectorNode.class)
    @DenyReplace
    private static final class WriteVector22Data extends Node implements SpecializationDataNode {

        @Child WriteVector22Data next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link LLVMStoreVectorNode#writeVector(LLVMManagedPointer, LLVMPointerVector, LLVMManagedWriteLibrary)}
         *   Parameter: {@link LLVMManagedWriteLibrary} nativeWrite</pre>
         */
        @Child LLVMManagedWriteLibrary nativeWrite_;

        WriteVector22Data(WriteVector22Data next_) {
            this.next_ = next_;
        }

    }
}
