// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMIsFPClassNode.IsFPClassF32;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMIsFPClassNode.IsFPClassF32Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMIsFPClassNode.IsFPClassF64;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMIsFPClassNode.IsFPClassF64Vector;
import com.oracle.truffle.llvm.runtime.nodes.op.LLVMIsFPClassNode.IsFPClassF80;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(LLVMIsFPClassNode.class)
@SuppressWarnings("javadoc")
public final class LLVMIsFPClassNodeFactory {

    /**
     * Debug Info: <pre>
     *   Specialization {@link IsFPClassF32#doTest}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(IsFPClassF32.class)
    @SuppressWarnings("javadoc")
    public static final class IsFPClassF32NodeGen extends IsFPClassF32 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode op_;
        @Child private LLVMExpressionNode test_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link IsFPClassF32#doTest}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private IsFPClassF32NodeGen(LLVMExpressionNode op, LLVMExpressionNode test) {
            this.op_ = op;
            this.test_ = test;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            float opValue_;
            try {
                opValue_ = this.op_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object testValue = this.test_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), testValue);
            }
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF32.doTest(float, int)] */) {
                return IsFPClassF32.doTest(opValue_, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            float opValue_;
            try {
                opValue_ = this.op_.executeFloat(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object testValue = this.test_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), testValue);
            }
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF32.doTest(float, int)] */) {
                return IsFPClassF32.doTest(opValue_, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        private boolean executeAndSpecialize(Object opValue, Object testValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (opValue instanceof Float) {
                float opValue_ = (float) opValue;
                if (testValue instanceof Integer) {
                    int testValue_ = (int) testValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF32.doTest(float, int)] */;
                    this.state_0_ = state_0;
                    return IsFPClassF32.doTest(opValue_, testValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.op_, this.test_}, opValue, testValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF32.doTest(float, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static IsFPClassF32 create(LLVMExpressionNode op, LLVMExpressionNode test) {
            return new IsFPClassF32NodeGen(op, test);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IsFPClassF64#doTest}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(IsFPClassF64.class)
    @SuppressWarnings("javadoc")
    public static final class IsFPClassF64NodeGen extends IsFPClassF64 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode op_;
        @Child private LLVMExpressionNode test_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link IsFPClassF64#doTest}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private IsFPClassF64NodeGen(LLVMExpressionNode op, LLVMExpressionNode test) {
            this.op_ = op;
            this.test_ = test;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            double opValue_;
            try {
                opValue_ = this.op_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object testValue = this.test_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), testValue);
            }
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF64.doTest(double, int)] */) {
                return IsFPClassF64.doTest(opValue_, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            double opValue_;
            try {
                opValue_ = this.op_.executeDouble(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                Object testValue = this.test_.executeGeneric(frameValue);
                return executeAndSpecialize(ex.getResult(), testValue);
            }
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF64.doTest(double, int)] */) {
                return IsFPClassF64.doTest(opValue_, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        private boolean executeAndSpecialize(Object opValue, Object testValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (opValue instanceof Double) {
                double opValue_ = (double) opValue;
                if (testValue instanceof Integer) {
                    int testValue_ = (int) testValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF64.doTest(double, int)] */;
                    this.state_0_ = state_0;
                    return IsFPClassF64.doTest(opValue_, testValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.op_, this.test_}, opValue, testValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF64.doTest(double, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static IsFPClassF64 create(LLVMExpressionNode op, LLVMExpressionNode test) {
            return new IsFPClassF64NodeGen(op, test);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IsFPClassF80#doTest}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(IsFPClassF80.class)
    @SuppressWarnings("javadoc")
    public static final class IsFPClassF80NodeGen extends IsFPClassF80 implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode op_;
        @Child private LLVMExpressionNode test_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link IsFPClassF80#doTest}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private IsFPClassF80NodeGen(LLVMExpressionNode op, LLVMExpressionNode test) {
            this.op_ = op;
            this.test_ = test;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object opValue_ = this.op_.executeGeneric(frameValue);
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF80.doTest(LLVM80BitFloat, int)] */ && opValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat opValue__ = (LLVM80BitFloat) opValue_;
                return IsFPClassF80.doTest(opValue__, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        @Override
        public boolean executeI1(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object opValue_ = this.op_.executeGeneric(frameValue);
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF80.doTest(LLVM80BitFloat, int)] */ && opValue_ instanceof LLVM80BitFloat) {
                LLVM80BitFloat opValue__ = (LLVM80BitFloat) opValue_;
                return IsFPClassF80.doTest(opValue__, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        private boolean executeAndSpecialize(Object opValue, Object testValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (opValue instanceof LLVM80BitFloat) {
                LLVM80BitFloat opValue_ = (LLVM80BitFloat) opValue;
                if (testValue instanceof Integer) {
                    int testValue_ = (int) testValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF80.doTest(LLVM80BitFloat, int)] */;
                    this.state_0_ = state_0;
                    return IsFPClassF80.doTest(opValue_, testValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.op_, this.test_}, opValue, testValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF80.doTest(LLVM80BitFloat, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static IsFPClassF80 create(LLVMExpressionNode op, LLVMExpressionNode test) {
            return new IsFPClassF80NodeGen(op, test);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IsFPClassF32Vector#doTest}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(IsFPClassF32Vector.class)
    @SuppressWarnings("javadoc")
    public static final class IsFPClassF32VectorNodeGen extends IsFPClassF32Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode op_;
        @Child private LLVMExpressionNode test_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link IsFPClassF32Vector#doTest}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private IsFPClassF32VectorNodeGen(int vectorSize, LLVMExpressionNode op, LLVMExpressionNode test) {
            super(vectorSize);
            this.op_ = op;
            this.test_ = test;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object opValue_ = this.op_.executeGeneric(frameValue);
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF32Vector.doTest(LLVMFloatVector, int)] */ && opValue_ instanceof LLVMFloatVector) {
                LLVMFloatVector opValue__ = (LLVMFloatVector) opValue_;
                return doTest(opValue__, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object opValue, Object testValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (opValue instanceof LLVMFloatVector) {
                LLVMFloatVector opValue_ = (LLVMFloatVector) opValue;
                if (testValue instanceof Integer) {
                    int testValue_ = (int) testValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF32Vector.doTest(LLVMFloatVector, int)] */;
                    this.state_0_ = state_0;
                    return doTest(opValue_, testValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.op_, this.test_}, opValue, testValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF32Vector.doTest(LLVMFloatVector, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static IsFPClassF32Vector create(int vectorSize, LLVMExpressionNode op, LLVMExpressionNode test) {
            return new IsFPClassF32VectorNodeGen(vectorSize, op, test);
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link IsFPClassF64Vector#doTest}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(IsFPClassF64Vector.class)
    @SuppressWarnings("javadoc")
    public static final class IsFPClassF64VectorNodeGen extends IsFPClassF64Vector implements GenerateAOT.Provider {

        @Child private LLVMExpressionNode op_;
        @Child private LLVMExpressionNode test_;
        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link IsFPClassF64Vector#doTest}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private IsFPClassF64VectorNodeGen(int vectorSize, LLVMExpressionNode op, LLVMExpressionNode test) {
            super(vectorSize);
            this.op_ = op;
            this.test_ = test;
        }

        @Override
        public Object executeGeneric(VirtualFrame frameValue) {
            int state_0 = this.state_0_;
            Object opValue_ = this.op_.executeGeneric(frameValue);
            int testValue_;
            try {
                testValue_ = this.test_.executeI32(frameValue);
            } catch (UnexpectedResultException ex) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(opValue_, ex.getResult());
            }
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(opValue_, testValue_);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMIsFPClassNode.IsFPClassF64Vector.doTest(LLVMDoubleVector, int)] */ && opValue_ instanceof LLVMDoubleVector) {
                LLVMDoubleVector opValue__ = (LLVMDoubleVector) opValue_;
                return doTest(opValue__, testValue_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(opValue_, testValue_);
        }

        private LLVMI1Vector executeAndSpecialize(Object opValue, Object testValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (opValue instanceof LLVMDoubleVector) {
                LLVMDoubleVector opValue_ = (LLVMDoubleVector) opValue;
                if (testValue instanceof Integer) {
                    int testValue_ = (int) testValue;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF64Vector.doTest(LLVMDoubleVector, int)] */;
                    this.state_0_ = state_0;
                    return doTest(opValue_, testValue_);
                }
            }
            throw new UnsupportedSpecializationException(this, new Node[] {this.op_, this.test_}, opValue, testValue);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMIsFPClassNode.IsFPClassF64Vector.doTest(LLVMDoubleVector, int)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static IsFPClassF64Vector create(int vectorSize, LLVMExpressionNode op, LLVMExpressionNode test) {
            return new IsFPClassF64VectorNodeGen(vectorSize, op, test);
        }

    }
}
