// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesLongPointer;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesLongPointerGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link LLVMPointerMaskNode#doNative}
 *     Activation probability: 0.65000
 *     With/without class size: 11/0 bytes
 *   Specialization {@link LLVMPointerMaskNode#doManaged}
 *     Activation probability: 0.35000
 *     With/without class size: 8/0 bytes
 * </pre>
 */
@GeneratedBy(LLVMPointerMaskNode.class)
@SuppressWarnings("javadoc")
public final class LLVMPointerMaskNodeGen extends LLVMPointerMaskNode implements GenerateAOT.Provider {

    @Child private LLVMExpressionNode child0_;
    @Child private LLVMExpressionNode child1_;
    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link LLVMPointerMaskNode#doNative}
     *   2: SpecializationActive {@link LLVMPointerMaskNode#doManaged}
     *   3-4: ImplicitCast[type=LLVMNativePointer, index=0]
     * </pre>
     */
    @CompilationFinal private int state_0_;

    private LLVMPointerMaskNodeGen(LLVMExpressionNode child0, LLVMExpressionNode child1) {
        this.child0_ = child0;
        this.child1_ = child1;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object child0Value_ = this.child0_.executeGeneric(frameValue);
        long child1Value_;
        try {
            child1Value_ = this.child1_.executeI64(frameValue);
        } catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(child0Value_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(child0Value_, child1Value_);
        }
        if ((state_0 & 0b110) != 0 /* is SpecializationActive[LLVMPointerMaskNode.doNative(LLVMNativePointer, long)] || SpecializationActive[LLVMPointerMaskNode.doManaged(LLVMManagedPointer, long)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[LLVMPointerMaskNode.doNative(LLVMNativePointer, long)] */ && LLVMTypesLongPointerGen.isImplicitLLVMNativePointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMNativePointer, index=0] */, child0Value_)) {
                LLVMNativePointer child0Value__ = LLVMTypesLongPointerGen.asImplicitLLVMNativePointer((state_0 & 0b11000) >>> 3 /* get-int ImplicitCast[type=LLVMNativePointer, index=0] */, child0Value_);
                return doNative(child0Value__, child1Value_);
            }
            if ((state_0 & 0b100) != 0 /* is SpecializationActive[LLVMPointerMaskNode.doManaged(LLVMManagedPointer, long)] */ && LLVMTypesLongPointer.isManagedPointer(child0Value_)) {
                LLVMManagedPointer child0Value__ = LLVMTypesLongPointer.asManagedPointer(child0Value_);
                return doManaged(child0Value__, child1Value_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(child0Value_, child1Value_);
    }

    private LLVMPointer executeAndSpecialize(Object child0Value, Object child1Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (child1Value instanceof Long) {
            long child1Value_ = (long) child1Value;
            {
                int lLVMNativePointerCast0;
                if ((lLVMNativePointerCast0 = LLVMTypesLongPointerGen.specializeImplicitLLVMNativePointer(child0Value)) != 0) {
                    LLVMNativePointer child0Value_ = LLVMTypesLongPointerGen.asImplicitLLVMNativePointer(lLVMNativePointerCast0, child0Value);
                    state_0 = (state_0 | (lLVMNativePointerCast0 << 3) /* set-int ImplicitCast[type=LLVMNativePointer, index=0] */);
                    state_0 = state_0 | 0b10 /* add SpecializationActive[LLVMPointerMaskNode.doNative(LLVMNativePointer, long)] */;
                    this.state_0_ = state_0;
                    return doNative(child0Value_, child1Value_);
                }
            }
            if (LLVMTypesLongPointer.isManagedPointer(child0Value)) {
                LLVMManagedPointer child0Value_ = LLVMTypesLongPointer.asManagedPointer(child0Value);
                state_0 = state_0 | 0b100 /* add SpecializationActive[LLVMPointerMaskNode.doManaged(LLVMManagedPointer, long)] */;
                this.state_0_ = state_0;
                return doManaged(child0Value_, child1Value_);
            }
        }
        throw new UnsupportedSpecializationException(this, new Node[] {this.child0_, this.child1_}, child0Value, child1Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[LLVMPointerMaskNode.doNative(LLVMNativePointer, long)] */;
        }
        {
            this.state_0_ = state_0_ | 0b100 /* add SpecializationActive[LLVMPointerMaskNode.doManaged(LLVMManagedPointer, long)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        state_0 = state_0 | 0b11000 /* add ImplicitCast[type=LLVMNativePointer, index=0] */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMPointerMaskNode create(LLVMExpressionNode child0, LLVMExpressionNode child1) {
        return new LLVMPointerMaskNodeGen(child0, child1);
    }

}
