// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.nodes.op;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.AsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupport.IsPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.AsPointerNodeGen;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMNativePointerSupportFactory.IsPointerNodeGen;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

/**
 * Debug Info: <pre>
 *   Specialization {@link ToComparableValue#doPointer}
 *     Activation probability: 0.48333
 *     With/without class size: 17/8 bytes
 *   Specialization {@link ToComparableValue#doPointerException}
 *     Activation probability: 0.33333
 *     With/without class size: 14/12 bytes
 *   Specialization {@link ToComparableValue#doManaged}
 *     Activation probability: 0.18333
 *     With/without class size: 9/8 bytes
 * </pre>
 */
@GeneratedBy(ToComparableValue.class)
@SuppressWarnings("javadoc")
public final class ToComparableValueNodeGen extends ToComparableValue implements GenerateAOT.Provider {

    static final ReferenceField<PointerData> POINTER_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "pointer_cache", PointerData.class);
    static final ReferenceField<PointerExceptionData> POINTER_EXCEPTION_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "pointerException_cache", PointerExceptionData.class);
    static final ReferenceField<ManagedData> MANAGED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "managed_cache", ManagedData.class);

    /**
     * State Info: <pre>
     *   0: AOTPrepared
     *   1: SpecializationActive {@link ToComparableValue#doPointer}
     *   2: SpecializationExcluded {@link ToComparableValue#doPointer}
     *   3: SpecializationActive {@link ToComparableValue#doPointerException}
     *   4: SpecializationActive {@link ToComparableValue#doManaged}
     * </pre>
     */
    @CompilationFinal private int state_0_;
    @UnsafeAccessedField @Child private PointerData pointer_cache;
    @UnsafeAccessedField @Child private PointerExceptionData pointerException_cache;
    @UnsafeAccessedField @Child private ManagedData managed_cache;

    private ToComparableValueNodeGen() {
    }

    @ExplodeLoop
    @Override
    public long executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
            return executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0b11010) != 0 /* is SpecializationActive[ToComparableValue.doPointer(Object, IsPointerNode, AsPointerNode)] || SpecializationActive[ToComparableValue.doPointerException(Object, IsPointerNode, AsPointerNode, ManagedToComparableValue)] || SpecializationActive[ToComparableValue.doManaged(Object, IsPointerNode, ManagedToComparableValue)] */) {
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToComparableValue.doPointer(Object, IsPointerNode, AsPointerNode)] */) {
                PointerData s0_ = this.pointer_cache;
                while (s0_ != null) {
                    if ((s0_.isPointer_.execute(arg0Value))) {
                        try {
                            return doPointer(arg0Value, s0_.isPointer_, s0_.asPointer_);
                        } catch (UnsupportedMessageException ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ToComparableValue.doPointer(Object, IsPointerNode, AsPointerNode)] */;
                            state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                            this.state_0_ = state_0;
                            this.pointer_cache = null;
                            return executeAndSpecialize(arg0Value);
                        }
                    }
                    s0_ = s0_.next_;
                }
            }
            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ToComparableValue.doPointerException(Object, IsPointerNode, AsPointerNode, ManagedToComparableValue)] */) {
                PointerExceptionData s1_ = this.pointerException_cache;
                while (s1_ != null) {
                    if ((s1_.isPointer_.execute(arg0Value))) {
                        return doPointerException(arg0Value, s1_.isPointer_, s1_.asPointer_, s1_.toComparable_);
                    }
                    s1_ = s1_.next_;
                }
            }
            if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ToComparableValue.doManaged(Object, IsPointerNode, ManagedToComparableValue)] */) {
                ManagedData s2_ = this.managed_cache;
                while (s2_ != null) {
                    if ((!(s2_.isPointer_.execute(arg0Value)))) {
                        return doManaged(arg0Value, s2_.isPointer_, s2_.toComparable_);
                    }
                    s2_ = s2_.next_;
                }
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return executeAndSpecialize(arg0Value);
    }

    @SuppressWarnings("unused")
    private long executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (((state_0 & 0b100)) == 0 /* is-not SpecializationExcluded  */) {
            while (true) {
                int count0_ = 0;
                PointerData s0_ = POINTER_CACHE_UPDATER.getVolatile(this);
                PointerData s0_original = s0_;
                while (s0_ != null) {
                    if ((s0_.isPointer_.execute(arg0Value))) {
                        break;
                    }
                    count0_++;
                    s0_ = s0_.next_;
                }
                if (s0_ == null) {
                    {
                        IsPointerNode isPointer__ = this.insert((IsPointerNodeGen.create()));
                        if ((isPointer__.execute(arg0Value)) && count0_ < (3)) {
                            s0_ = this.insert(new PointerData(s0_original));
                            Objects.requireNonNull(s0_.insert(isPointer__), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.isPointer_ = isPointer__;
                            AsPointerNode asPointer__ = s0_.insert((AsPointerNodeGen.create()));
                            Objects.requireNonNull(asPointer__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                            s0_.asPointer_ = asPointer__;
                            if (!POINTER_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                continue;
                            }
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ToComparableValue.doPointer(Object, IsPointerNode, AsPointerNode)] */;
                            this.state_0_ = state_0;
                        }
                    }
                }
                if (s0_ != null) {
                    try {
                        return doPointer(arg0Value, s0_.isPointer_, s0_.asPointer_);
                    } catch (UnsupportedMessageException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 = state_0 & 0xfffffffd /* remove SpecializationActive[ToComparableValue.doPointer(Object, IsPointerNode, AsPointerNode)] */;
                        state_0 = state_0 | 0b100 /* add SpecializationExcluded  */;
                        this.state_0_ = state_0;
                        this.pointer_cache = null;
                        return executeAndSpecialize(arg0Value);
                    }
                }
                break;
            }
        }
        while (true) {
            int count1_ = 0;
            PointerExceptionData s1_ = POINTER_EXCEPTION_CACHE_UPDATER.getVolatile(this);
            PointerExceptionData s1_original = s1_;
            while (s1_ != null) {
                if ((s1_.isPointer_.execute(arg0Value))) {
                    break;
                }
                count1_++;
                s1_ = s1_.next_;
            }
            if (s1_ == null) {
                {
                    IsPointerNode isPointer__1 = this.insert((IsPointerNodeGen.create()));
                    if ((isPointer__1.execute(arg0Value)) && count1_ < (3)) {
                        s1_ = this.insert(new PointerExceptionData(s1_original));
                        Objects.requireNonNull(s1_.insert(isPointer__1), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s1_.isPointer_ = isPointer__1;
                        AsPointerNode asPointer__1 = s1_.insert((AsPointerNodeGen.create()));
                        Objects.requireNonNull(asPointer__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s1_.asPointer_ = asPointer__1;
                        s1_.toComparable_ = s1_.insert((ManagedToComparableValue.createUseOffset()));
                        if (!POINTER_EXCEPTION_CACHE_UPDATER.compareAndSet(this, s1_original, s1_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[ToComparableValue.doPointerException(Object, IsPointerNode, AsPointerNode, ManagedToComparableValue)] */;
                        this.state_0_ = state_0;
                    }
                }
            }
            if (s1_ != null) {
                return doPointerException(arg0Value, s1_.isPointer_, s1_.asPointer_, s1_.toComparable_);
            }
            break;
        }
        while (true) {
            int count2_ = 0;
            ManagedData s2_ = MANAGED_CACHE_UPDATER.getVolatile(this);
            ManagedData s2_original = s2_;
            while (s2_ != null) {
                if ((!(s2_.isPointer_.execute(arg0Value)))) {
                    break;
                }
                count2_++;
                s2_ = s2_.next_;
            }
            if (s2_ == null) {
                {
                    IsPointerNode isPointer__2 = this.insert((IsPointerNodeGen.create()));
                    if ((!(isPointer__2.execute(arg0Value))) && count2_ < (3)) {
                        s2_ = this.insert(new ManagedData(s2_original));
                        Objects.requireNonNull(s2_.insert(isPointer__2), "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                        s2_.isPointer_ = isPointer__2;
                        s2_.toComparable_ = s2_.insert((ManagedToComparableValue.createUseOffset()));
                        if (!MANAGED_CACHE_UPDATER.compareAndSet(this, s2_original, s2_)) {
                            continue;
                        }
                        state_0 = state_0 | 0b10000 /* add SpecializationActive[ToComparableValue.doManaged(Object, IsPointerNode, ManagedToComparableValue)] */;
                        this.state_0_ = state_0;
                    }
                }
            }
            if (s2_ != null) {
                return doManaged(arg0Value, s2_.isPointer_, s2_.toComparable_);
            }
            break;
        }
        throw new UnsupportedSpecializationException(this, null, arg0Value);
    }

    @Override
    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
        if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
            return;
        }
        {
            PointerData s0_ = this.insert(new PointerData(this.pointer_cache));
            IsPointerNode isPointer__ = s0_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointer__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s0_.isPointer_ = isPointer__;
            AsPointerNode asPointer__ = s0_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointer__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s0_.asPointer_ = asPointer__;
            VarHandle.storeStoreFence();
            this.pointer_cache = s0_;
            assert NodeUtil.assertRecursion(s0_.isPointer_, 1);
            ((GenerateAOT.Provider) s0_.isPointer_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s0_.asPointer_, 1);
            ((GenerateAOT.Provider) s0_.asPointer_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToComparableValue.doPointer(Object, IsPointerNode, AsPointerNode)] */;
        }
        {
            PointerExceptionData s1_ = this.insert(new PointerExceptionData(this.pointerException_cache));
            IsPointerNode isPointer__1 = s1_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointer__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.isPointer_ = isPointer__1;
            AsPointerNode asPointer__1 = s1_.insert((AsPointerNodeGen.create()));
            Objects.requireNonNull(asPointer__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s1_.asPointer_ = asPointer__1;
            s1_.toComparable_ = s1_.insert((ManagedToComparableValue.createUseOffset()));
            VarHandle.storeStoreFence();
            this.pointerException_cache = s1_;
            assert NodeUtil.assertRecursion(s1_.isPointer_, 1);
            ((GenerateAOT.Provider) s1_.isPointer_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s1_.asPointer_, 1);
            ((GenerateAOT.Provider) s1_.asPointer_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s1_.toComparable_, 1);
            ((GenerateAOT.Provider) s1_.toComparable_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b1000 /* add SpecializationActive[ToComparableValue.doPointerException(Object, IsPointerNode, AsPointerNode, ManagedToComparableValue)] */;
        }
        {
            ManagedData s2_ = this.insert(new ManagedData(this.managed_cache));
            IsPointerNode isPointer__2 = s2_.insert((IsPointerNodeGen.create()));
            Objects.requireNonNull(isPointer__2, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            s2_.isPointer_ = isPointer__2;
            s2_.toComparable_ = s2_.insert((ManagedToComparableValue.createUseOffset()));
            VarHandle.storeStoreFence();
            this.managed_cache = s2_;
            assert NodeUtil.assertRecursion(s2_.isPointer_, 1);
            ((GenerateAOT.Provider) s2_.isPointer_).prepareForAOT(language, root);
            assert NodeUtil.assertRecursion(s2_.toComparable_, 1);
            ((GenerateAOT.Provider) s2_.toComparable_).prepareForAOT(language, root);
            this.state_0_ = state_0_ | 0b10000 /* add SpecializationActive[ToComparableValue.doManaged(Object, IsPointerNode, ManagedToComparableValue)] */;
        }
        int state_0 = this.state_0_;
        state_0 = state_0 | 0b1 /* add AOTPrepared */;
        this.state_0_ = state_0;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
            return;
        }
        this.state_0_ = 0;
        this.pointer_cache = null;
        this.pointerException_cache = null;
        this.managed_cache = null;
    }

    @NeverDefault
    public static ToComparableValue create() {
        return new ToComparableValueNodeGen();
    }

    @GeneratedBy(ToComparableValue.class)
    @DenyReplace
    private static final class PointerData extends Node implements SpecializationDataNode {

        @Child PointerData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToComparableValue#doPointer}
         *   Parameter: {@link IsPointerNode} isPointer</pre>
         */
        @Child IsPointerNode isPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToComparableValue#doPointer}
         *   Parameter: {@link AsPointerNode} asPointer</pre>
         */
        @Child AsPointerNode asPointer_;

        PointerData(PointerData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(ToComparableValue.class)
    @DenyReplace
    private static final class PointerExceptionData extends Node implements SpecializationDataNode {

        @Child PointerExceptionData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToComparableValue#doPointerException}
         *   Parameter: {@link IsPointerNode} isPointer</pre>
         */
        @Child IsPointerNode isPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToComparableValue#doPointerException}
         *   Parameter: {@link AsPointerNode} asPointer</pre>
         */
        @Child AsPointerNode asPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToComparableValue#doPointerException}
         *   Parameter: {@link ManagedToComparableValue} toComparable</pre>
         */
        @Child ManagedToComparableValue toComparable_;

        PointerExceptionData(PointerExceptionData next_) {
            this.next_ = next_;
        }

    }
    @GeneratedBy(ToComparableValue.class)
    @DenyReplace
    private static final class ManagedData extends Node implements SpecializationDataNode {

        @Child ManagedData next_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToComparableValue#doManaged}
         *   Parameter: {@link IsPointerNode} isPointer</pre>
         */
        @Child IsPointerNode isPointer_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link ToComparableValue#doManaged}
         *   Parameter: {@link ManagedToComparableValue} toComparable</pre>
         */
        @Child ManagedToComparableValue toComparable_;

        ManagedData(ManagedData next_) {
            this.next_ = next_;
        }

    }
    /**
     * Debug Info: <pre>
     *   Specialization {@link ManagedToComparableValue#doManaged}
     *     Activation probability: 1.00000
     *     With/without class size: 16/0 bytes
     * </pre>
     */
    @GeneratedBy(ManagedToComparableValue.class)
    @SuppressWarnings("javadoc")
    public static final class ManagedToComparableValueNodeGen extends ManagedToComparableValue implements GenerateAOT.Provider {

        /**
         * State Info: <pre>
         *   0: AOTPrepared
         *   1: SpecializationActive {@link ManagedToComparableValue#doManaged}
         * </pre>
         */
        @CompilationFinal private int state_0_;

        private ManagedToComparableValueNodeGen(boolean includeOffset) {
            super(includeOffset);
        }

        @Override
        long executeWithTarget(Object arg0Value) {
            int state_0 = this.state_0_;
            if (CompilerDirectives.inInterpreter() && (state_0 & 0b1) != 0 /* is AOTPrepared */) {
                return executeAndSpecialize(arg0Value);
            }
            if ((state_0 & 0b10) != 0 /* is SpecializationActive[ToComparableValue.ManagedToComparableValue.doManaged(LLVMManagedPointer)] */ && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return doManaged(arg0Value_);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value);
        }

        private long executeAndSpecialize(Object arg0Value) {
            int state_0 = this.state_0_;
            if ((state_0 & 0b1) != 0 /* is AOTPrepared */) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                state_0 = state_0 | 0b10 /* add SpecializationActive[ToComparableValue.ManagedToComparableValue.doManaged(LLVMManagedPointer)] */;
                this.state_0_ = state_0;
                return doManaged(arg0Value_);
            }
            throw new UnsupportedSpecializationException(this, null, arg0Value);
        }

        @Override
        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert !isAdoptable() || ((ReentrantLock) getLock()).isHeldByCurrentThread() : "During prepare AST lock must be held.";
            if ((state_0_ & 0b1) != 0 /* is AOTPrepared */) {
                return;
            }
            {
                this.state_0_ = state_0_ | 0b10 /* add SpecializationActive[ToComparableValue.ManagedToComparableValue.doManaged(LLVMManagedPointer)] */;
            }
            int state_0 = this.state_0_;
            state_0 = state_0 | 0b1 /* add AOTPrepared */;
            this.state_0_ = state_0;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if (((state_0 & 0b1)) == 0 /* is-not AOTPrepared */) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static ManagedToComparableValue create(boolean includeOffset) {
            return new ManagedToComparableValueNodeGen(includeOffset);
        }

    }
}
