// CheckStyle: start generated
package com.oracle.truffle.llvm.runtime.options;

import com.oracle.truffle.api.TruffleOptionDescriptors;
import com.oracle.truffle.api.dsl.GeneratedBy;
import java.util.Iterator;
import java.util.List;
import org.graalvm.options.OptionCategory;
import org.graalvm.options.OptionDescriptor;
import org.graalvm.options.OptionStability;
import org.graalvm.polyglot.SandboxPolicy;

@GeneratedBy(SulongEngineOption.class)
final class SulongEngineOptionOptionDescriptors implements TruffleOptionDescriptors {

    @Override
    public OptionDescriptor get(String optionName) {
        switch (optionName) {
            case "llvm.AOTCacheLoad" :
                return OptionDescriptor.newBuilder(SulongEngineOption.AOTCacheLoad, "llvm.AOTCacheLoad").deprecated(false).help("Perform AOT-specific initialization after loading auxiliary engine cache.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.AOTCacheStore" :
                return OptionDescriptor.newBuilder(SulongEngineOption.AOTCacheStore, "llvm.AOTCacheStore").deprecated(false).help("Perform AOT-specific initialization before storing auxiliary engine cache.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.C++Interop" :
                return OptionDescriptor.newBuilder(SulongEngineOption.CXX_INTEROP, "llvm.C++Interop").deprecated(false).help("Enables using C++ code and features via interop.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.OSR" :
                return OptionDescriptor.newBuilder(SulongEngineOption.OSR_MODE, "llvm.OSR").deprecated(false).help("Mode to use for on-stack-replacement of loops.").usageSyntax("BYTECODE|NONE").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.enableLVI" :
                return OptionDescriptor.newBuilder(SulongEngineOption.ENABLE_LVI, "llvm.enableLVI").deprecated(true).deprecationMessage("").help("This option is deprecated, local variable inspection is always enabled.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.lazyParsing" :
                return OptionDescriptor.newBuilder(SulongEngineOption.LAZY_PARSING, "llvm.lazyParsing").deprecated(false).help("Enable lazy parsing of LLVM bitcode files.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.libraries" :
                return OptionDescriptor.newBuilder(SulongEngineOption.LIBRARIES, "llvm.libraries").deprecated(false).help("List of libraries (precompiled libraries *.dylib/*.so as well as bitcode libraries *.bc). Files with a relative path will be looked up relative to llvm.libraryPath. Libraries are delimited by the system path separator.").usageSyntax("<library>,<library>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "llvm.libraryPath" :
                return OptionDescriptor.newBuilder(SulongEngineOption.LIBRARY_PATH, "llvm.libraryPath").deprecated(false).help("A list of paths where Sulong will search for relative libraries. Paths are delimited by the system path separator.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "llvm.llDebug" :
                return OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG, "llvm.llDebug").deprecated(false).help("Enable IR-level debugging of LLVM bitcode files.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.llDebug.sources" :
                return OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG_SOURCES, "llvm.llDebug.sources").deprecated(false).help("Provide the locations of *.ll files for debugging. The expected format is <bc-path>=<ll-path>{:<bc-path>=<ll-path>}.").usageSyntax("<bc-path>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.loadC++Libraries" :
                return OptionDescriptor.newBuilder(SulongEngineOption.LOAD_CXX_LIBRARIES, "llvm.loadC++Libraries").deprecated(false).help("Specifies whether the standard C++ libraries (libc++ and libc++abi) should be loaded by default. This should only be needed for running plain bitcode files, since executables (ELF, Mach-O) usually have a dependency on both of them. Thus, the option is off by default.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.optimizeFrameSlots" :
                return OptionDescriptor.newBuilder(SulongEngineOption.OPTIMIZE_FRAME_SLOTS, "llvm.optimizeFrameSlots").deprecated(false).help("Enable fusing of instructions producing values with instructions consuming values.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.parseOnly" :
                return OptionDescriptor.newBuilder(SulongEngineOption.PARSE_ONLY, "llvm.parseOnly").deprecated(false).help("Only parses a bc file; execution is not possible.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.printASTFilter" :
                return OptionDescriptor.newBuilder(SulongEngineOption.PRINT_AST_FILTER, "llvm.printASTFilter").deprecated(false).help("Restricts which functions should have their abstract syntax tree printed on creation. Printing is enabled by setting '--log.llvm.AST.level=FINEST. A comma-separated list of regular expressions that will be matched against function names.").usageSyntax("<function>,<function>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.printStackTraceOnAbort" :
                return OptionDescriptor.newBuilder(SulongEngineOption.STACKTRACE_ON_ABORT, "llvm.printStackTraceOnAbort").deprecated(false).help("Prints a C stack trace when abort() is called.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build();
            case "llvm.stackSize" :
                return OptionDescriptor.newBuilder(SulongEngineOption.STACK_SIZE, "llvm.stackSize").deprecated(false).help("The stack size, please end the input with one of: k, m, g, or t. Note that the stack size will be in bytes if no appropriate suffix is given.").usageSyntax("<size>").category(OptionCategory.USER).stability(OptionStability.STABLE).build();
            case "llvm.verifyBitcode" :
                return OptionDescriptor.newBuilder(SulongEngineOption.VERIFY_BITCODE, "llvm.verifyBitcode").deprecated(false).help("Sanity check whether loaded bitcode files are compiled correctly.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build();
        }
        return null;
    }

    @Override
    public SandboxPolicy getSandboxPolicy(String optionName) {
        assert get(optionName) != null : "Unknown option " + optionName;
        return SandboxPolicy.TRUSTED;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return List.of(
            OptionDescriptor.newBuilder(SulongEngineOption.AOTCacheLoad, "llvm.AOTCacheLoad").deprecated(false).help("Perform AOT-specific initialization after loading auxiliary engine cache.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.AOTCacheStore, "llvm.AOTCacheStore").deprecated(false).help("Perform AOT-specific initialization before storing auxiliary engine cache.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.CXX_INTEROP, "llvm.C++Interop").deprecated(false).help("Enables using C++ code and features via interop.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.OSR_MODE, "llvm.OSR").deprecated(false).help("Mode to use for on-stack-replacement of loops.").usageSyntax("BYTECODE|NONE").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.ENABLE_LVI, "llvm.enableLVI").deprecated(true).deprecationMessage("").help("This option is deprecated, local variable inspection is always enabled.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.LAZY_PARSING, "llvm.lazyParsing").deprecated(false).help("Enable lazy parsing of LLVM bitcode files.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.LIBRARIES, "llvm.libraries").deprecated(false).help("List of libraries (precompiled libraries *.dylib/*.so as well as bitcode libraries *.bc). Files with a relative path will be looked up relative to llvm.libraryPath. Libraries are delimited by the system path separator.").usageSyntax("<library>,<library>,...").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.LIBRARY_PATH, "llvm.libraryPath").deprecated(false).help("A list of paths where Sulong will search for relative libraries. Paths are delimited by the system path separator.").usageSyntax("<path>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG, "llvm.llDebug").deprecated(false).help("Enable IR-level debugging of LLVM bitcode files.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.LL_DEBUG_SOURCES, "llvm.llDebug.sources").deprecated(false).help("Provide the locations of *.ll files for debugging. The expected format is <bc-path>=<ll-path>{:<bc-path>=<ll-path>}.").usageSyntax("<bc-path>").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.LOAD_CXX_LIBRARIES, "llvm.loadC++Libraries").deprecated(false).help("Specifies whether the standard C++ libraries (libc++ and libc++abi) should be loaded by default. This should only be needed for running plain bitcode files, since executables (ELF, Mach-O) usually have a dependency on both of them. Thus, the option is off by default.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.OPTIMIZE_FRAME_SLOTS, "llvm.optimizeFrameSlots").deprecated(false).help("Enable fusing of instructions producing values with instructions consuming values.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.PARSE_ONLY, "llvm.parseOnly").deprecated(false).help("Only parses a bc file; execution is not possible.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.PRINT_AST_FILTER, "llvm.printASTFilter").deprecated(false).help("Restricts which functions should have their abstract syntax tree printed on creation. Printing is enabled by setting '--log.llvm.AST.level=FINEST. A comma-separated list of regular expressions that will be matched against function names.").usageSyntax("<function>,<function>,...").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.STACKTRACE_ON_ABORT, "llvm.printStackTraceOnAbort").deprecated(false).help("Prints a C stack trace when abort() is called.").usageSyntax("true|false").category(OptionCategory.INTERNAL).stability(OptionStability.EXPERIMENTAL).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.STACK_SIZE, "llvm.stackSize").deprecated(false).help("The stack size, please end the input with one of: k, m, g, or t. Note that the stack size will be in bytes if no appropriate suffix is given.").usageSyntax("<size>").category(OptionCategory.USER).stability(OptionStability.STABLE).build(),
            OptionDescriptor.newBuilder(SulongEngineOption.VERIFY_BITCODE, "llvm.verifyBitcode").deprecated(false).help("Sanity check whether loaded bitcode files are compiled correctly.").usageSyntax("true|false").category(OptionCategory.EXPERT).stability(OptionStability.EXPERIMENTAL).build())
        .iterator();
    }

}
