/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlotKind;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.parser.LLVMLivenessAnalysis;
import com.oracle.truffle.llvm.parser.LLVMParserRuntime;
import com.oracle.truffle.llvm.parser.LLVMPhiManager;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.DebugInfoFunctionProcessor;
import com.oracle.truffle.llvm.parser.metadata.debuginfo.SourceVariable;
import com.oracle.truffle.llvm.parser.model.SymbolImpl;
import com.oracle.truffle.llvm.parser.model.attributes.Attribute;
import com.oracle.truffle.llvm.parser.model.blocks.InstructionBlock;
import com.oracle.truffle.llvm.parser.model.functions.FunctionDefinition;
import com.oracle.truffle.llvm.parser.model.functions.FunctionParameter;
import com.oracle.truffle.llvm.parser.model.functions.LazyFunctionParser;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgDeclareInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.DbgValueInstruction;
import com.oracle.truffle.llvm.parser.model.symbols.instructions.Instruction;
import com.oracle.truffle.llvm.parser.nodes.LLVMBitcodeInstructionVisitor;
import com.oracle.truffle.llvm.parser.nodes.LLVMFunctionModifier;
import com.oracle.truffle.llvm.parser.nodes.LLVMRuntimeDebugInformation;
import com.oracle.truffle.llvm.parser.nodes.LLVMSymbolReadResolver;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.GetStackSpaceFactory;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.LLVMNodeUtils;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.datalayout.DataLayout;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStatementNode;
import com.oracle.truffle.llvm.runtime.nodes.base.LLVMBasicBlockNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMUnpackVarargsNode;
import com.oracle.truffle.llvm.runtime.nodes.memory.LLVMUnpackVarargsNodeGen;
import com.oracle.truffle.llvm.runtime.options.SulongEngineOption;
import com.oracle.truffle.llvm.runtime.types.AggregateType;
import com.oracle.truffle.llvm.runtime.types.ArrayType;
import com.oracle.truffle.llvm.runtime.types.MetaType;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.StructureType;
import com.oracle.truffle.llvm.runtime.types.Type;
import com.oracle.truffle.llvm.runtime.types.symbols.SSAValue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.graalvm.options.OptionValues;

public class LazyToTruffleConverterImpl
implements LLVMFunctionCode.LazyToTruffleConverter {
    private final LLVMParserRuntime runtime;
    private final FunctionDefinition method;
    private final Source source;
    private final LazyFunctionParser parser;
    private final DebugInfoFunctionProcessor diProcessor;
    private final DataLayout dataLayout;
    private boolean parsed;
    private RootCallTarget resolved;
    private LLVMFunction rootFunction;

    LazyToTruffleConverterImpl(LLVMParserRuntime runtime, FunctionDefinition method, Source source, LazyFunctionParser parser, DebugInfoFunctionProcessor diProcessor, DataLayout dataLayout) {
        this.runtime = runtime;
        this.method = method;
        this.source = source;
        this.parser = parser;
        this.diProcessor = diProcessor;
        this.resolved = null;
        this.dataLayout = dataLayout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RootCallTarget convert() {
        CompilerAsserts.neverPartOfCompilation();
        LazyToTruffleConverterImpl lazyToTruffleConverterImpl = this;
        synchronized (lazyToTruffleConverterImpl) {
            if (this.resolved == null) {
                this.resolved = this.generateCallTarget();
            }
            return this.resolved;
        }
    }

    public void setRootFunction(LLVMFunction rootFunction) {
        this.rootFunction = rootFunction;
    }

    private synchronized void doParse() {
        if (!this.parsed) {
            this.parser.parse(this.diProcessor, this.source, this.runtime, LLVMLanguage.getContext());
            this.parsed = true;
        }
    }

    private RootCallTarget generateCallTarget() {
        String printASTOption;
        LLVMContext context = LLVMLanguage.getContext();
        NodeFactory nodeFactory = this.runtime.getNodeFactory();
        OptionValues options = context.getEnv().getOptions();
        boolean printAST = false;
        if (LLVMContext.printAstEnabled() && !(printASTOption = (String)options.get(SulongEngineOption.PRINT_AST_FILTER)).isEmpty()) {
            String[] regexes;
            for (String regex : regexes = printASTOption.split(",")) {
                if (!this.method.getName().matches(regex)) continue;
                printAST = true;
                LLVMContext.printAstLog("========== " + this.method.getName());
                break;
            }
        }
        this.doParse();
        Map<InstructionBlock, List<LLVMPhiManager.Phi>> phis = LLVMPhiManager.getPhis(this.method);
        LLVMLivenessAnalysis.LLVMLivenessAnalysisResult liveness = LLVMLivenessAnalysis.computeLiveness(phis, this.method);
        FrameDescriptor.Builder builder = FrameDescriptor.newBuilder();
        nodeFactory.addStackSlots(builder);
        LLVMStack.UniquesRegion uniquesRegion = new LLVMStack.UniquesRegion();
        GetStackSpaceFactory getStackSpaceFactory = GetStackSpaceFactory.createGetUniqueStackSpaceFactory(uniquesRegion);
        LLVMSymbolReadResolver symbols = new LLVMSymbolReadResolver(this.runtime, builder, getStackSpaceFactory, this.dataLayout, (Boolean)options.get(SulongEngineOption.LL_DEBUG));
        int exceptionSlot = builder.addSlot(FrameSlotKind.Object, null, null);
        for (FunctionParameter parameter : this.method.getParameters()) {
            symbols.findOrAddFrameSlot(parameter);
        }
        HashSet<SSAValue> neededForDebug = this.getDebugValues();
        boolean initDebugValues = true;
        LLVMRuntimeDebugInformation info = new LLVMRuntimeDebugInformation(this.method.getBlocks().size());
        LLVMBasicBlockNode[] blockNodes = new LLVMBasicBlockNode[this.method.getBlocks().size()];
        ArrayList<LLVMFunctionModifier> functionModifiers = new ArrayList<LLVMFunctionModifier>();
        for (InstructionBlock block : this.method.getBlocks()) {
            List<LLVMPhiManager.Phi> blockPhis = phis.get(block);
            ArrayList<LLVMLivenessAnalysis.NullerInformation> blockNullerInfos = liveness.getNullableWithinBlock()[block.getBlockIndex()];
            LLVMBitcodeInstructionVisitor visitor = new LLVMBitcodeInstructionVisitor(exceptionSlot, uniquesRegion, blockPhis, this.method.getParameters().size(), symbols, context, blockNullerInfos, neededForDebug, this.dataLayout, nodeFactory, functionModifiers);
            if (initDebugValues) {
                for (SourceVariable variable : this.method.getSourceFunction().getVariables()) {
                    if (!variable.hasFragments()) continue;
                    visitor.initializeAggregateLocalVariable(variable);
                }
                initDebugValues = false;
            }
            for (int i = 0; i < block.getInstructionCount(); ++i) {
                visitor.setInstructionIndex(i);
                block.getInstruction(i).accept(visitor);
            }
            LLVMStatementNode[] nodes = visitor.finish();
            info.setBlockDebugInfo(block.getBlockIndex(), visitor.getDebugInfo());
            blockNodes[block.getBlockIndex()] = LLVMBasicBlockNode.createBasicBlockNode(nodes, visitor.getControlFlowNode(), block.getBlockIndex(), block.getName());
        }
        for (LLVMFunctionModifier modifier : functionModifiers) {
            modifier.modify(blockNodes);
        }
        for (int j = 0; j < blockNodes.length; ++j) {
            int[] nullableBeforeBlock = LazyToTruffleConverterImpl.getNullableFrameSlots(liveness.getFrameSlots(), liveness.getNullableBeforeBlock()[j]);
            int[] nullableAfterBlock = LazyToTruffleConverterImpl.getNullableFrameSlots(liveness.getFrameSlots(), liveness.getNullableAfterBlock()[j]);
            blockNodes[j].setNullableFrameSlots(nullableBeforeBlock, nullableAfterBlock);
        }
        info.setBlocks(blockNodes);
        LLVMSourceLocation location = this.method.getLexicalScope();
        this.rootFunction.setSourceLocation(LLVMSourceLocation.orDefault(location));
        LLVMStatementNode[] copyArgumentsToFrameArray = this.copyArgumentsToFrame(symbols).toArray(LLVMStatementNode.NO_STATEMENTS);
        FrameDescriptor frame = builder.build();
        RootNode rootNode = nodeFactory.createFunction(exceptionSlot, blockNodes, uniquesRegion, copyArgumentsToFrameArray, frame, info, this.method.getName(), this.method.getSourceName(), this.method.getParameters().size(), this.source, location, this.rootFunction);
        this.method.onAfterParse();
        if (printAST) {
            LLVMNodeUtils.printNodeAST(new LLVMNodeUtils.LambdaLineWriter(LLVMContext::printAstLog), (Node)rootNode);
            LLVMContext.printAstLog("");
        }
        return rootNode.getCallTarget();
    }

    private HashSet<SSAValue> getDebugValues() {
        HashSet<SSAValue> neededForDebug = new HashSet<SSAValue>();
        for (InstructionBlock block : this.method.getBlocks()) {
            for (Instruction instruction : block.getInstructions()) {
                SymbolImpl value;
                if (instruction instanceof DbgValueInstruction) {
                    value = ((DbgValueInstruction)instruction).getValue();
                } else {
                    if (!(instruction instanceof DbgDeclareInstruction)) continue;
                    value = ((DbgDeclareInstruction)instruction).getValue();
                }
                if (!(value instanceof SSAValue)) continue;
                neededForDebug.add((SSAValue)((Object)value));
            }
        }
        return neededForDebug;
    }

    @Override
    public LLVMSourceFunctionType getSourceType() {
        CompilerAsserts.neverPartOfCompilation();
        this.doParse();
        return this.method.getSourceFunction().getSourceType();
    }

    private static int[] getNullableFrameSlots(SSAValue[] values, BitSet nullable) {
        int bitIndex = -1;
        int count = 0;
        int[] result = new int[8];
        while ((bitIndex = nullable.nextSetBit(bitIndex + 1)) >= 0) {
            int frameIdentifier = bitIndex;
            if (!SSAValue.isFrameSlotAllocated(values[frameIdentifier])) continue;
            if (result.length < count + 1) {
                result = Arrays.copyOf(result, result.length * 2);
            }
            result[count++] = SSAValue.getFrameSlot(values[frameIdentifier]);
        }
        if (count > 0) {
            return Arrays.copyOf(result, count);
        }
        return null;
    }

    private static Type functionParameterFindByValueAttribute(FunctionParameter parameter) {
        if (parameter.getParameterAttribute() != null) {
            for (Attribute a : parameter.getParameterAttribute().getAttributes()) {
                if (!(a instanceof Attribute.KnownAttribute) || ((Attribute.KnownAttribute)a).getAttr() != Attribute.Kind.BYVAL) continue;
                if (a instanceof Attribute.KnownTypedAttribute) {
                    return ((Attribute.KnownTypedAttribute)a).getType();
                }
                PointerType parameterType = (PointerType)parameter.getType();
                assert (parameterType.getPointeeType() != MetaType.UNKNOWN);
                return parameterType.getPointeeType();
            }
        }
        return null;
    }

    private LLVMExpressionNode getTargetAddress(LLVMExpressionNode baseAddress, Type sourceType, ArrayDeque<Long> indices) {
        return CommonNodeFactory.getTargetAddress(baseAddress, sourceType, indices, this.runtime.getNodeFactory(), this.dataLayout);
    }

    private void copyStructArgumentsToFrame(List<LLVMStatementNode> initializers, NodeFactory nodeFactory, int slot, int argIndex, Type topLevelType, Type currentType, ArrayDeque<Long> indices) {
        if (currentType instanceof StructureType || currentType instanceof ArrayType) {
            AggregateType t = (AggregateType)currentType;
            for (long i = 0L; i < t.getNumberOfElements(); ++i) {
                indices.push(i);
                this.copyStructArgumentsToFrame(initializers, nodeFactory, slot, argIndex, topLevelType, t.getElementType(i), indices);
                indices.pop();
            }
        } else {
            LLVMExpressionNode targetAddress = this.getTargetAddress(CommonNodeFactory.createFrameRead(PointerType.PTR, slot), topLevelType, indices);
            LLVMUnpackVarargsNode argMaybeUnpack = LLVMUnpackVarargsNodeGen.create(nodeFactory.createFunctionArgNode(argIndex, PointerType.PTR));
            LLVMExpressionNode sourceAddress = this.getTargetAddress(argMaybeUnpack, topLevelType, indices);
            LLVMExpressionNode sourceLoadNode = nodeFactory.createLoad(currentType, sourceAddress);
            LLVMStatementNode storeNode = nodeFactory.createStore(targetAddress, sourceLoadNode, currentType);
            initializers.add(storeNode);
        }
    }

    private List<LLVMStatementNode> copyArgumentsToFrame(LLVMSymbolReadResolver symbols) {
        NodeFactory nodeFactory = this.runtime.getNodeFactory();
        List<FunctionParameter> parameters = this.method.getParameters();
        ArrayList<LLVMStatementNode> formalParamInits = new ArrayList<LLVMStatementNode>();
        int argIndex = 1;
        Type retType = this.method.getType().getReturnType();
        if (retType instanceof StructureType || retType instanceof ArrayType) {
            ++argIndex;
        }
        for (FunctionParameter parameter : parameters) {
            int slot = symbols.findOrAddFrameSlot(parameter);
            Type byValType = LazyToTruffleConverterImpl.functionParameterFindByValueAttribute(parameter);
            if (parameter.getType() instanceof PointerType && byValType != null) {
                GetStackSpaceFactory allocaFactory = GetStackSpaceFactory.createAllocaFactory();
                LLVMExpressionNode allocation = allocaFactory.createGetStackSpace(nodeFactory, byValType);
                formalParamInits.add(CommonNodeFactory.createFrameWrite(PointerType.PTR, allocation, slot));
                ArrayDeque<Long> indices = new ArrayDeque<Long>();
                this.copyStructArgumentsToFrame(formalParamInits, nodeFactory, slot, argIndex++, byValType, byValType, indices);
                continue;
            }
            LLVMExpressionNode parameterNode = nodeFactory.createFunctionArgNode(argIndex++, parameter.getType());
            formalParamInits.add(CommonNodeFactory.createFrameWrite(parameter.getType(), parameterNode, slot));
        }
        return formalParamInits;
    }
}

