/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.llvm.runtime.ContextExtension;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NativeContextExtension;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMNativeLibrary;
import com.oracle.truffle.llvm.runtime.memory.LLVMHandleMemoryBase;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMNativeLibrary.class, useForAOT=false), @ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=true, useForAOTPriority=2)})
public final class LLVMFunctionDescriptor
extends LLVMInternalTruffleObject
implements Comparable<LLVMFunctionDescriptor> {
    private static final long SULONG_FUNCTION_POINTER_TAG = -4981268375154982912L;
    private final LLVMFunction llvmFunction;
    private final LLVMFunctionCode functionCode;
    @CompilerDirectives.CompilationFinal
    private Object nativeWrapper;
    @CompilerDirectives.CompilationFinal
    private long nativePointer;
    static final String CREATE_NATIVE_CLOSURE = "createNativeClosure";
    static final /* synthetic */ boolean $assertionsDisabled;

    private static long tagSulongFunctionPointer(int id) {
        return (long)id | 0xBADEFACE00000000L;
    }

    public LLVMFunction getLLVMFunction() {
        return this.llvmFunction;
    }

    public LLVMFunctionCode getFunctionCode() {
        return this.functionCode;
    }

    public long getNativePointer() {
        return this.nativePointer;
    }

    public LLVMFunctionDescriptor(LLVMFunction llvmFunction, LLVMFunctionCode functionCode) {
        CompilerAsserts.neverPartOfCompilation();
        this.llvmFunction = llvmFunction;
        this.functionCode = functionCode;
    }

    public String toString() {
        return String.format("function@%d '%s'", this.llvmFunction.getSymbolIndexIllegalOk(), this.llvmFunction.getName());
    }

    @Override
    public int compareTo(LLVMFunctionDescriptor o) {
        int otherIndex = o.llvmFunction.getSymbolIndexIllegalOk();
        IDGenerater.BitcodeID otherBitcodeID = o.llvmFunction.getBitcodeIDIllegalOk();
        int index = this.llvmFunction.getSymbolIndexIllegalOk();
        IDGenerater.BitcodeID bitcodeID = this.llvmFunction.getBitcodeIDIllegalOk();
        if (bitcodeID == otherBitcodeID) {
            return Long.compare(index, otherIndex);
        }
        throw new IllegalStateException("Comparing functions from different bitcode files.");
    }

    @ExportMessage
    public long asPointer(@Cached @Cached.Exclusive BranchProfile exception) throws UnsupportedMessageException {
        if (this.isPointer()) {
            return this.nativePointer;
        }
        exception.enter();
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean isPointer() {
        return this.nativeWrapper != null;
    }

    @ExportMessage
    public LLVMFunctionDescriptor toNative() {
        if (this.nativeWrapper == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.nativeWrapper = this.functionCode.getFunction().createNativeWrapper(this);
            try {
                this.nativePointer = ((InteropLibrary)InteropLibrary.getFactory().getUncached()).asPointer(this.nativeWrapper);
            }
            catch (UnsupportedMessageException ex) {
                this.nativePointer = LLVMFunctionDescriptor.tagSulongFunctionPointer(this.llvmFunction.getSymbolIndexIllegalOk());
            }
        }
        return this;
    }

    @ExportMessage
    public LLVMNativePointer toNativePointer(@CachedLibrary(value="this") LLVMNativeLibrary self, @Cached @Cached.Exclusive BranchProfile exceptionProfile) {
        try {
            return this.asNativePointer(exceptionProfile);
        }
        catch (UnsupportedMessageException e) {
            exceptionProfile.enter();
            throw new LLVMPolyglotException((Node)self, "Cannot convert %s to native pointer.", this);
        }
    }

    public LLVMNativePointer asNativePointer(BranchProfile exceptionProfile) throws UnsupportedMessageException {
        if (!this.isPointer()) {
            this.toNative();
        }
        return LLVMNativePointer.create(this.asPointer(exceptionProfile));
    }

    @ExportMessage
    boolean isExecutable() {
        return true;
    }

    @ExportMessage
    boolean isInstantiable() {
        return true;
    }

    @ExportMessage
    Object instantiate(Object[] arguments, @Cached.Exclusive @Cached IndirectCallNode call) {
        Object[] newArgs = new Object[arguments.length + 1];
        for (int i = 0; i < arguments.length; ++i) {
            newArgs[i + 1] = arguments[i];
        }
        return call.call(this.functionCode.getForeignConstructorCallTarget(), newArgs);
    }

    @ExportMessage
    public boolean hasExecutableName() {
        return this.llvmFunction.getSourceLocation() != null && this.llvmFunction.getSourceLocation().getName() != null;
    }

    @ExportMessage
    public Object getExecutableName() throws UnsupportedMessageException {
        if (this.hasExecutableName()) {
            return this.llvmFunction.getSourceLocation().getName();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public boolean hasSourceLocation() {
        return this.llvmFunction.getSourceLocation() != null;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public SourceSection getSourceLocation() throws UnsupportedMessageException {
        if (this.hasSourceLocation()) {
            return this.llvmFunction.getSourceLocation().getSourceSection();
        }
        throw UnsupportedMessageException.create();
    }

    @ExportMessage
    public static boolean isForeign(LLVMFunctionDescriptor receiver) {
        return false;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    static ContextExtension.Key<NativeContextExtension> getCtxExtKey() {
        return LLVMLanguage.get(null).lookupContextExtension(NativeContextExtension.class);
    }

    @ExportMessage
    Object getMembers(boolean includeInternal, @Bind(value="$node") Node node, @Cached(value="getCtxExtKey()", allowUncached=true) ContextExtension.Key<NativeContextExtension> ctxExtKey) {
        boolean hasCreateNativeClosure = ctxExtKey != null && ctxExtKey.get(LLVMContext.get(node)) != null;
        return new MembersList(hasCreateNativeClosure);
    }

    static {
        boolean bl = $assertionsDisabled = !LLVMFunctionDescriptor.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !LLVMHandleMemoryBase.isCommonHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && LLVMHandleMemoryBase.isDerefHandleMemory(-4981268375154982912L)) {
            throw new AssertionError();
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MembersList
    implements TruffleObject {
        private final boolean hasCreateNativeClosure;

        MembersList(boolean hasCreateNativeClosure) {
            this.hasCreateNativeClosure = hasCreateNativeClosure;
        }

        @ExportMessage
        boolean hasArrayElements() {
            return true;
        }

        @ExportMessage
        long getArraySize() {
            return this.hasCreateNativeClosure ? 1L : 0L;
        }

        @ExportMessage
        boolean isArrayElementReadable(long index) {
            return this.hasCreateNativeClosure && index == 0L;
        }

        @ExportMessage
        Object readArrayElement(long index) throws InvalidArrayIndexException {
            if (this.hasCreateNativeClosure && index == 0L) {
                return LLVMFunctionDescriptor.CREATE_NATIVE_CLOSURE;
            }
            throw InvalidArrayIndexException.create((long)index);
        }
    }

    @ExportMessage
    static class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"ident == CREATE_NATIVE_CLOSURE", "ctxExtKey != null"})
        static Object doCreate(LLVMFunctionDescriptor function, String ident, @Bind(value="$node") Node node, @Cached(value="getCtxExtKey()", allowUncached=true) ContextExtension.Key<NativeContextExtension> ctxExtKey, @Cached InlinedBranchProfile exception) throws UnknownIdentifierException {
            assert (LLVMFunctionDescriptor.CREATE_NATIVE_CLOSURE.equals(ident));
            if (ctxExtKey.get(LLVMContext.get(node)) == null) {
                exception.enter(node);
                throw UnknownIdentifierException.create((String)ident);
            }
            return new CreateNativeClosureExecutable(function.getFunctionCode());
        }

        @Specialization(guards={"CREATE_NATIVE_CLOSURE.equals(ident)", "ctxExtKey != null"}, replaces={"doCreate"})
        static Object doEqualsCheck(LLVMFunctionDescriptor function, String ident, @Bind(value="$node") Node node, @Cached(value="getCtxExtKey()", allowUncached=true) ContextExtension.Key<NativeContextExtension> ctxExtKey, @Cached InlinedBranchProfile exception) throws UnknownIdentifierException {
            return ReadMember.doCreate(function, ident, node, ctxExtKey, exception);
        }

        @Fallback
        static Object doOther(LLVMFunctionDescriptor function, String ident) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create((String)ident);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class CreateNativeClosureExecutable
    implements TruffleObject {
        private final LLVMFunctionCode function;

        private CreateNativeClosureExecutable(LLVMFunctionCode function) {
            this.function = function;
        }

        @ExportMessage
        boolean isExecutable() {
            assert (this.function != null);
            return true;
        }

        @ExportMessage
        Object execute(Object[] args, @Bind(value="$node") Node node, @Cached CreateNativeClosureNode createNativeClosure) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            return createNativeClosure.execute(node, this.function, args);
        }
    }

    @ExportMessage
    static class InvokeMember {
        InvokeMember() {
        }

        @Specialization(guards={"ident == CREATE_NATIVE_CLOSURE"})
        static Object doCreate(LLVMFunctionDescriptor function, String ident, Object[] args, @Bind(value="$node") Node node, @Cached CreateNativeClosureNode createNativeClosure) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
            assert (LLVMFunctionDescriptor.CREATE_NATIVE_CLOSURE.equals(ident));
            try {
                return createNativeClosure.execute(node, function.getFunctionCode(), args);
            }
            catch (UnsupportedMessageException e) {
                throw UnknownIdentifierException.create((String)ident);
            }
        }

        @Specialization(guards={"CREATE_NATIVE_CLOSURE.equals(ident)"}, replaces={"doCreate"})
        static Object doEqualsCheck(LLVMFunctionDescriptor function, String ident, Object[] args, @Bind(value="$node") Node node, @Cached CreateNativeClosureNode createNativeClosure) throws ArityException, UnknownIdentifierException, UnsupportedTypeException {
            return InvokeMember.doCreate(function, ident, args, node, createNativeClosure);
        }

        @Fallback
        static Object doOther(LLVMFunctionDescriptor function, String ident, Object[] arg) throws UnknownIdentifierException {
            throw UnknownIdentifierException.create((String)ident);
        }
    }

    @GenerateInline
    @GenerateUncached
    @ImportStatic(value={LLVMFunctionDescriptor.class})
    static abstract class CreateNativeClosureNode
    extends Node {
        CreateNativeClosureNode() {
        }

        abstract Object execute(Node var1, LLVMFunctionCode var2, Object[] var3) throws ArityException, UnsupportedMessageException, UnsupportedTypeException;

        @Specialization(guards={"ctxExtKey != null"})
        static Object doCreate(Node node, LLVMFunctionCode function, Object[] args, @Cached(value="getCtxExtKey()", allowUncached=true) ContextExtension.Key<NativeContextExtension> ctxExtKey, @Cached GetWrapperFactoryNode getWrapperFactory, @Cached InlineCacheHelperNode inlineCache, @Cached InlinedBranchProfile exception) throws ArityException, UnsupportedMessageException, UnsupportedTypeException {
            NativeContextExtension ctxExt = ctxExtKey.get(LLVMContext.get(node));
            if (ctxExt == null) {
                exception.enter(node);
                throw UnsupportedMessageException.create();
            }
            CallTarget wrapperFactory = getWrapperFactory.execute(node, ctxExt, function, args);
            return inlineCache.execute(node, wrapperFactory);
        }

        @Fallback
        static Object doFail(LLVMFunctionCode function, Object[] args) throws UnsupportedMessageException {
            throw UnsupportedMessageException.create();
        }
    }

    @GenerateInline
    @GenerateUncached
    static abstract class InlineCacheHelperNode
    extends Node {
        InlineCacheHelperNode() {
        }

        abstract Object execute(Node var1, CallTarget var2);

        @Specialization(limit="5", guards={"call.getCallTarget() == target"})
        static Object doCached(CallTarget target, @Cached(value="create(target)") DirectCallNode call) {
            assert (call.getCallTarget() == target);
            return call.call(new Object[0]);
        }

        @Specialization(replaces={"doCached"})
        static Object doGeneric(CallTarget target, @Cached IndirectCallNode call) {
            return call.call(target, new Object[0]);
        }
    }

    @GenerateInline
    @GenerateUncached
    static abstract class GetWrapperFactoryNode
    extends Node {
        GetWrapperFactoryNode() {
        }

        abstract CallTarget execute(Node var1, NativeContextExtension var2, LLVMFunctionCode var3, Object[] var4) throws ArityException, UnsupportedTypeException;

        @CompilerDirectives.TruffleBoundary
        static CallTarget getDefault(NativeContextExtension ctxExt, LLVMFunctionCode function) {
            return function.getNativeWrapperFactory(ctxExt);
        }

        @CompilerDirectives.TruffleBoundary
        static CallTarget getAltBackend(NativeContextExtension ctxExt, LLVMFunctionCode function, String backend) {
            return function.getAltBackendNativeWrapperFactory(ctxExt, backend);
        }

        @Specialization(guards={"args.length == 0"})
        static CallTarget doNoArgs(NativeContextExtension ctxExt, LLVMFunctionCode function, Object[] args) {
            assert (args.length == 0);
            return GetWrapperFactoryNode.getDefault(ctxExt, function);
        }

        @Specialization(guards={"args.length == 1"})
        static CallTarget doSingleArg(Node node, NativeContextExtension ctxExt, LLVMFunctionCode function, Object[] args, @Cached AsStringHelperNode asString) throws UnsupportedTypeException {
            return GetWrapperFactoryNode.getAltBackend(ctxExt, function, asString.execute(node, args[0]));
        }

        @Fallback
        static CallTarget doWrongArity(NativeContextExtension ctxExt, LLVMFunctionCode function, Object[] args) throws ArityException {
            throw ArityException.create((int)1, (int)1, (int)args.length);
        }
    }

    @GenerateInline
    @GenerateUncached
    static abstract class AsStringHelperNode
    extends Node {
        AsStringHelperNode() {
        }

        abstract String execute(Node var1, Object var2) throws UnsupportedTypeException;

        @Specialization(limit="3", guards={"interop.isString(arg)"})
        static String doString(Object arg, @CachedLibrary(value="arg") InteropLibrary interop) {
            try {
                return interop.asString(arg);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }

        @Fallback
        static String doOther(Object arg) throws UnsupportedTypeException {
            throw UnsupportedTypeException.create((Object[])new Object[]{arg}, (String)"string");
        }
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="isMemberReadable"), @ExportMessage(name="isMemberInvocable")})
    static class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"ident == CREATE_NATIVE_CLOSURE", "ctxExtKey != null"})
        static boolean doCreate(LLVMFunctionDescriptor function, String ident, @Bind(value="$node") Node node, @Cached(value="getCtxExtKey()", allowUncached=true) ContextExtension.Key<NativeContextExtension> ctxExtKey) {
            return ctxExtKey.get(LLVMContext.get(node)) != null;
        }

        @Specialization(guards={"CREATE_NATIVE_CLOSURE.equals(ident)", "ctxExtKey != null"}, replaces={"doCreate"})
        static boolean doEqualsCheck(LLVMFunctionDescriptor function, String ident, @Bind(value="$node") Node node, @Cached(value="getCtxExtKey()", allowUncached=true) ContextExtension.Key<NativeContextExtension> ctxExtKey) {
            return IsMemberReadable.doCreate(function, ident, node, ctxExtKey);
        }

        @Fallback
        static boolean doOther(LLVMFunctionDescriptor function, String ident) {
            return false;
        }
    }

    @ExportMessage
    @ImportStatic(value={LLVMLanguage.class})
    static class Execute {
        Execute() {
        }

        @Specialization(limit="5", guards={"self == cachedSelf", "isSingleContext($node)"})
        static Object doDescriptor(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self") LLVMFunctionDescriptor cachedSelf, @Cached(value="createCall(cachedSelf)") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doDescriptor"}, limit="5", guards={"self.getFunctionCode() == cachedFunctionCode"})
        static Object doCached(LLVMFunctionDescriptor self, Object[] args, @Cached(value="self.getFunctionCode()") LLVMFunctionCode cachedFunctionCode, @Cached(value="createCall(self)") DirectCallNode call) {
            return call.call(args);
        }

        @Specialization(replaces={"doCached"})
        static Object doPolymorphic(LLVMFunctionDescriptor self, Object[] args, @Cached.Exclusive @Cached IndirectCallNode call) {
            return call.call(self.getFunctionCode().getForeignCallTarget(), args);
        }

        protected static DirectCallNode createCall(LLVMFunctionDescriptor self) {
            DirectCallNode callNode = DirectCallNode.create((CallTarget)self.getFunctionCode().getForeignCallTarget());
            callNode.forceInlining();
            return callNode;
        }
    }
}

