/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.api.Toolchain;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.ToolchainConfig;
import com.oracle.truffle.llvm.runtime.nodes.asm.syscall.LLVMInfo;
import java.nio.file.LinkOption;
import java.util.List;

public final class ToolchainImpl
implements Toolchain {
    private static final String[] WINDOWS_EXECUTABLE_EXTENSIONS = new String[]{".exe", ".cmd"};
    private final ToolchainConfig toolchainConfig;
    private final LLVMLanguage language;

    public ToolchainImpl(ToolchainConfig toolchainConfig, LLVMLanguage language) {
        this.toolchainConfig = toolchainConfig;
        this.language = language;
    }

    public TruffleFile getToolPath(String tool) {
        TruffleFile res = this.getToolPathImpl(tool);
        if (LLVMInfo.SYSNAME.toLowerCase().contains("windows")) {
            TruffleFile parent = res.getParent();
            String name = res.getName();
            for (String ext : WINDOWS_EXECUTABLE_EXTENSIONS) {
                TruffleFile fileWithExt = parent.resolve(name + ext);
                try {
                    if (fileWithExt.exists(new LinkOption[0])) {
                        return fileWithExt;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return res;
    }

    private TruffleFile getToolPathImpl(String tool) {
        if (this.toolchainConfig == null) {
            return null;
        }
        TruffleFile binPrefix = this.getWrappersRoot().resolve("bin");
        switch (tool) {
            case "PATH": {
                return binPrefix;
            }
            case "CC": {
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-clang");
            }
            case "FC": {
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-flang");
            }
            case "CL": {
                if (!this.toolchainConfig.enableCL()) {
                    return null;
                }
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-clang-cl");
            }
            case "CXX": {
                if (!this.toolchainConfig.enableCXX()) {
                    return null;
                }
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-clang++");
            }
            case "LD": {
                return binPrefix.resolve("graalvm-" + this.toolchainConfig.getToolchainSubdir() + "-ld");
            }
            case "AR": 
            case "NM": 
            case "OBJCOPY": 
            case "OBJDUMP": 
            case "RANLIB": 
            case "READELF": 
            case "READOBJ": 
            case "STRIP": {
                return binPrefix.resolve(tool.toLowerCase());
            }
        }
        return null;
    }

    public List<TruffleFile> getPaths(String pathName) {
        if (this.toolchainConfig == null) {
            return null;
        }
        return switch (pathName) {
            case "PATH" -> {
                TruffleFile wrappersRoot = this.getWrappersRoot();
                if (wrappersRoot != null) {
                    yield List.of(wrappersRoot.resolve("bin"));
                }
                yield List.of();
            }
            case "LD_LIBRARY_PATH" -> {
                TruffleFile sysRoot = this.getSysroot();
                if (sysRoot != null) {
                    yield List.of(sysRoot.resolve("lib"));
                }
                yield List.of();
            }
            default -> null;
        };
    }

    private TruffleFile getWrappersRoot() {
        TruffleLanguage.Env env = LLVMLanguage.getContext().getEnv();
        String toolchainRoot = this.toolchainConfig.getToolchainRootOverride();
        return toolchainRoot != null ? env.getInternalTruffleFile(toolchainRoot) : this.getSysroot();
    }

    private TruffleFile getSysroot() {
        TruffleLanguage.Env env = LLVMLanguage.getContext().getEnv();
        String home = this.language.getLLVMLanguageHome();
        if (home != null) {
            return env.getInternalTruffleFile(home).resolve(this.toolchainConfig.getToolchainSubdir());
        }
        return null;
    }

    public String getIdentifier() {
        if (this.toolchainConfig == null) {
            return null;
        }
        return this.toolchainConfig.getToolchainSubdir();
    }

    public String toString() {
        return this.toolchainConfig.getClass().getSimpleName();
    }
}

