/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMIVarBit;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMDebugThreadLocalGlobalVariable;
import com.oracle.truffle.llvm.runtime.debug.value.LLVMDebugValue;
import com.oracle.truffle.llvm.runtime.floating.LLVM80BitFloat;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobalContainer;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypesGen;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.debug.LLVMToDebugValueNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.vector.LLVMDoubleVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMFloatVector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI16Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI1Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI32Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI64Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMI8Vector;
import com.oracle.truffle.llvm.runtime.vector.LLVMPointerVector;
import java.lang.invoke.VarHandle;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMToDebugValueNode.class)
public final class LLVMToDebugValueNodeGen
extends LLVMToDebugValueNode
implements GenerateAOT.Provider {
    private static final Uncached UNCACHED = new Uncached();
    @CompilerDirectives.CompilationFinal
    private int state_0_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile fromGlobal_exception_;
    @CompilerDirectives.CompilationFinal
    private BranchProfile fromThreadLocalGlobal_exception_;

    private LLVMToDebugValueNodeGen() {
    }

    private boolean fallbackGuard_(int state_0, Object arg0Value) {
        if ((state_0 & 2) == 0 && arg0Value instanceof Boolean) {
            return false;
        }
        if ((state_0 & 4) == 0 && arg0Value instanceof Byte) {
            return false;
        }
        if ((state_0 & 8) == 0 && arg0Value instanceof Short) {
            return false;
        }
        if ((state_0 & 0x10) == 0 && arg0Value instanceof Integer) {
            return false;
        }
        if ((state_0 & 0x20) == 0 && arg0Value instanceof Long) {
            return false;
        }
        if (LLVMTypesGen.isImplicitLLVMIVarBit(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x80) == 0 && LLVMTypes.isNativePointer(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x100) == 0 && LLVMTypes.isManagedPointer(arg0Value)) {
            return false;
        }
        if ((state_0 & 0x200) == 0 && arg0Value instanceof LLVMFunctionDescriptor) {
            return false;
        }
        if ((state_0 & 0x400) == 0 && arg0Value instanceof Float) {
            return false;
        }
        if ((state_0 & 0x800) == 0 && arg0Value instanceof Double) {
            return false;
        }
        if ((state_0 & 0x1000) == 0 && arg0Value instanceof LLVM80BitFloat) {
            return false;
        }
        if ((state_0 & 0x2000) == 0 && arg0Value instanceof LLVMI1Vector) {
            return false;
        }
        if ((state_0 & 0x4000) == 0 && arg0Value instanceof LLVMI8Vector) {
            return false;
        }
        if ((state_0 & 0x8000) == 0 && arg0Value instanceof LLVMI16Vector) {
            return false;
        }
        if ((state_0 & 0x10000) == 0 && arg0Value instanceof LLVMI32Vector) {
            return false;
        }
        if ((state_0 & 0x20000) == 0 && arg0Value instanceof LLVMI64Vector) {
            return false;
        }
        if ((state_0 & 0x40000) == 0 && arg0Value instanceof LLVMFloatVector) {
            return false;
        }
        if ((state_0 & 0x80000) == 0 && arg0Value instanceof LLVMDoubleVector) {
            return false;
        }
        if ((state_0 & 0x100000) == 0 && arg0Value instanceof LLVMPointerVector) {
            return false;
        }
        if ((state_0 & 0x200000) == 0 && arg0Value instanceof LLVMGlobalContainer) {
            return false;
        }
        if ((state_0 & 0x400000) == 0 && arg0Value instanceof LLVMDebugGlobalVariable) {
            return false;
        }
        return (state_0 & 0x800000) != 0 || !(arg0Value instanceof LLVMDebugThreadLocalGlobalVariable);
    }

    @Override
    protected LLVMDebugValue executeWithTarget(Object arg0Value) {
        int state_0 = this.state_0_;
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(arg0Value);
        }
        if ((state_0 & 0x1FFFFFE) != 0) {
            LLVMInternalTruffleObject arg0Value_;
            if ((state_0 & 2) != 0 && arg0Value instanceof Boolean) {
                boolean arg0Value_2 = (Boolean)arg0Value;
                return this.fromBoolean(arg0Value_2);
            }
            if ((state_0 & 4) != 0 && arg0Value instanceof Byte) {
                byte arg0Value_3 = (Byte)arg0Value;
                return this.fromByte(arg0Value_3);
            }
            if ((state_0 & 8) != 0 && arg0Value instanceof Short) {
                short arg0Value_4 = (Short)arg0Value;
                return this.fromShort(arg0Value_4);
            }
            if ((state_0 & 0x10) != 0 && arg0Value instanceof Integer) {
                int arg0Value_5 = (Integer)arg0Value;
                return this.fromInt(arg0Value_5);
            }
            if ((state_0 & 0x20) != 0 && arg0Value instanceof Long) {
                long arg0Value_6 = (Long)arg0Value;
                return this.fromLong(arg0Value_6);
            }
            if ((state_0 & 0x40) != 0 && LLVMTypesGen.isImplicitLLVMIVarBit((state_0 & 0xE000000) >>> 25, arg0Value)) {
                LLVMIVarBit arg0Value_7 = LLVMTypesGen.asImplicitLLVMIVarBit((state_0 & 0xE000000) >>> 25, arg0Value);
                return this.fromIVarBit(arg0Value_7);
            }
            if ((state_0 & 0x80) != 0 && LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_8 = LLVMTypes.asNativePointer(arg0Value);
                return this.fromNativePointer(arg0Value_8);
            }
            if ((state_0 & 0x100) != 0 && LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_9 = LLVMTypes.asManagedPointer(arg0Value);
                return this.fromManagedPointer(arg0Value_9);
            }
            if ((state_0 & 0x200) != 0 && arg0Value instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor arg0Value_10 = (LLVMFunctionDescriptor)arg0Value;
                return this.fromFunctionHandle(arg0Value_10);
            }
            if ((state_0 & 0x400) != 0 && arg0Value instanceof Float) {
                float arg0Value_11 = ((Float)arg0Value).floatValue();
                return this.fromFloat(arg0Value_11);
            }
            if ((state_0 & 0x800) != 0 && arg0Value instanceof Double) {
                double arg0Value_12 = (Double)arg0Value;
                return this.fromDouble(arg0Value_12);
            }
            if ((state_0 & 0x1000) != 0 && arg0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat arg0Value_13 = (LLVM80BitFloat)arg0Value;
                return this.from80BitFloat(arg0Value_13);
            }
            if ((state_0 & 0x2000) != 0 && arg0Value instanceof LLVMI1Vector) {
                LLVMI1Vector arg0Value_14 = (LLVMI1Vector)arg0Value;
                return this.fromI1Vector(arg0Value_14);
            }
            if ((state_0 & 0x4000) != 0 && arg0Value instanceof LLVMI8Vector) {
                LLVMI8Vector arg0Value_15 = (LLVMI8Vector)arg0Value;
                return this.fromI8Vector(arg0Value_15);
            }
            if ((state_0 & 0x8000) != 0 && arg0Value instanceof LLVMI16Vector) {
                LLVMI16Vector arg0Value_16 = (LLVMI16Vector)arg0Value;
                return this.fromI16Vector(arg0Value_16);
            }
            if ((state_0 & 0x10000) != 0 && arg0Value instanceof LLVMI32Vector) {
                LLVMI32Vector arg0Value_17 = (LLVMI32Vector)arg0Value;
                return this.fromI32Vector(arg0Value_17);
            }
            if ((state_0 & 0x20000) != 0 && arg0Value instanceof LLVMI64Vector) {
                LLVMI64Vector arg0Value_18 = (LLVMI64Vector)arg0Value;
                return this.fromI64Vector(arg0Value_18);
            }
            if ((state_0 & 0x40000) != 0 && arg0Value instanceof LLVMFloatVector) {
                LLVMFloatVector arg0Value_19 = (LLVMFloatVector)arg0Value;
                return this.fromFloatVector(arg0Value_19);
            }
            if ((state_0 & 0x80000) != 0 && arg0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector arg0Value_20 = (LLVMDoubleVector)arg0Value;
                return this.fromDoubleVector(arg0Value_20);
            }
            if ((state_0 & 0x100000) != 0 && arg0Value instanceof LLVMPointerVector) {
                LLVMPointerVector arg0Value_21 = (LLVMPointerVector)arg0Value;
                return this.fromAddressVector(arg0Value_21);
            }
            if ((state_0 & 0x200000) != 0 && arg0Value instanceof LLVMGlobalContainer) {
                LLVMGlobalContainer arg0Value_22 = (LLVMGlobalContainer)arg0Value;
                return this.fromGlobalContainer(arg0Value_22);
            }
            if ((state_0 & 0x400000) != 0 && arg0Value instanceof LLVMDebugGlobalVariable) {
                arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
                BranchProfile exception__ = this.fromGlobal_exception_;
                if (exception__ != null) {
                    return this.fromGlobal((LLVMDebugGlobalVariable)arg0Value_, exception__);
                }
            }
            if ((state_0 & 0x800000) != 0 && arg0Value instanceof LLVMDebugThreadLocalGlobalVariable) {
                arg0Value_ = (LLVMDebugThreadLocalGlobalVariable)arg0Value;
                BranchProfile exception__1 = this.fromThreadLocalGlobal_exception_;
                if (exception__1 != null) {
                    return this.fromThreadLocalGlobal((LLVMDebugThreadLocalGlobalVariable)arg0Value_, exception__1);
                }
            }
            if ((state_0 & 0x1000000) != 0 && this.fallbackGuard_(state_0, arg0Value)) {
                return this.fromGenericObject(arg0Value);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(arg0Value);
    }

    private LLVMDebugValue executeAndSpecialize(Object arg0Value) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (arg0Value instanceof Boolean) {
            boolean arg0Value_ = (Boolean)arg0Value;
            this.state_0_ = state_0 |= 2;
            return this.fromBoolean(arg0Value_);
        }
        if (arg0Value instanceof Byte) {
            byte arg0Value_ = (Byte)arg0Value;
            this.state_0_ = state_0 |= 4;
            return this.fromByte(arg0Value_);
        }
        if (arg0Value instanceof Short) {
            short arg0Value_ = (Short)arg0Value;
            this.state_0_ = state_0 |= 8;
            return this.fromShort(arg0Value_);
        }
        if (arg0Value instanceof Integer) {
            int arg0Value_ = (Integer)arg0Value;
            this.state_0_ = state_0 |= 0x10;
            return this.fromInt(arg0Value_);
        }
        if (arg0Value instanceof Long) {
            long arg0Value_ = (Long)arg0Value;
            this.state_0_ = state_0 |= 0x20;
            return this.fromLong(arg0Value_);
        }
        int lLVMIVarBitCast0 = LLVMTypesGen.specializeImplicitLLVMIVarBit(arg0Value);
        if (lLVMIVarBitCast0 != 0) {
            LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit(lLVMIVarBitCast0, arg0Value);
            state_0 |= lLVMIVarBitCast0 << 25;
            this.state_0_ = state_0 |= 0x40;
            return this.fromIVarBit(arg0Value_);
        }
        if (LLVMTypes.isNativePointer(arg0Value)) {
            LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
            this.state_0_ = state_0 |= 0x80;
            return this.fromNativePointer(arg0Value_);
        }
        if (LLVMTypes.isManagedPointer(arg0Value)) {
            LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
            this.state_0_ = state_0 |= 0x100;
            return this.fromManagedPointer(arg0Value_);
        }
        if (arg0Value instanceof LLVMFunctionDescriptor) {
            LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
            this.state_0_ = state_0 |= 0x200;
            return this.fromFunctionHandle(arg0Value_);
        }
        if (arg0Value instanceof Float) {
            float arg0Value_ = ((Float)arg0Value).floatValue();
            this.state_0_ = state_0 |= 0x400;
            return this.fromFloat(arg0Value_);
        }
        if (arg0Value instanceof Double) {
            double arg0Value_ = (Double)arg0Value;
            this.state_0_ = state_0 |= 0x800;
            return this.fromDouble(arg0Value_);
        }
        if (arg0Value instanceof LLVM80BitFloat) {
            LLVM80BitFloat arg0Value_ = (LLVM80BitFloat)arg0Value;
            this.state_0_ = state_0 |= 0x1000;
            return this.from80BitFloat(arg0Value_);
        }
        if (arg0Value instanceof LLVMI1Vector) {
            LLVMI1Vector arg0Value_ = (LLVMI1Vector)arg0Value;
            this.state_0_ = state_0 |= 0x2000;
            return this.fromI1Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI8Vector) {
            LLVMI8Vector arg0Value_ = (LLVMI8Vector)arg0Value;
            this.state_0_ = state_0 |= 0x4000;
            return this.fromI8Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI16Vector) {
            LLVMI16Vector arg0Value_ = (LLVMI16Vector)arg0Value;
            this.state_0_ = state_0 |= 0x8000;
            return this.fromI16Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI32Vector) {
            LLVMI32Vector arg0Value_ = (LLVMI32Vector)arg0Value;
            this.state_0_ = state_0 |= 0x10000;
            return this.fromI32Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMI64Vector) {
            LLVMI64Vector arg0Value_ = (LLVMI64Vector)arg0Value;
            this.state_0_ = state_0 |= 0x20000;
            return this.fromI64Vector(arg0Value_);
        }
        if (arg0Value instanceof LLVMFloatVector) {
            LLVMFloatVector arg0Value_ = (LLVMFloatVector)arg0Value;
            this.state_0_ = state_0 |= 0x40000;
            return this.fromFloatVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMDoubleVector) {
            LLVMDoubleVector arg0Value_ = (LLVMDoubleVector)arg0Value;
            this.state_0_ = state_0 |= 0x80000;
            return this.fromDoubleVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMPointerVector) {
            LLVMPointerVector arg0Value_ = (LLVMPointerVector)arg0Value;
            this.state_0_ = state_0 |= 0x100000;
            return this.fromAddressVector(arg0Value_);
        }
        if (arg0Value instanceof LLVMGlobalContainer) {
            LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer)arg0Value;
            this.state_0_ = state_0 |= 0x200000;
            return this.fromGlobalContainer(arg0Value_);
        }
        if (arg0Value instanceof LLVMDebugGlobalVariable) {
            LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
            BranchProfile exception__ = BranchProfile.create();
            Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.fromGlobal_exception_ = exception__;
            this.state_0_ = state_0 |= 0x400000;
            return this.fromGlobal(arg0Value_, exception__);
        }
        if (arg0Value instanceof LLVMDebugThreadLocalGlobalVariable) {
            LLVMDebugThreadLocalGlobalVariable arg0Value_ = (LLVMDebugThreadLocalGlobalVariable)arg0Value;
            BranchProfile exception__1 = BranchProfile.create();
            Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
            VarHandle.storeStoreFence();
            this.fromThreadLocalGlobal_exception_ = exception__1;
            this.state_0_ = state_0 |= 0x800000;
            return this.fromThreadLocalGlobal(arg0Value_, exception__1);
        }
        this.state_0_ = state_0 |= 0x1000000;
        return this.fromGenericObject(arg0Value);
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        this.state_0_ |= 4;
        this.state_0_ |= 8;
        this.state_0_ |= 0x10;
        this.state_0_ |= 0x20;
        this.state_0_ |= 0x40;
        this.state_0_ |= 0x80;
        this.state_0_ |= 0x100;
        this.state_0_ |= 0x200;
        this.state_0_ |= 0x400;
        this.state_0_ |= 0x800;
        this.state_0_ |= 0x1000;
        this.state_0_ |= 0x2000;
        this.state_0_ |= 0x4000;
        this.state_0_ |= 0x8000;
        this.state_0_ |= 0x10000;
        this.state_0_ |= 0x20000;
        this.state_0_ |= 0x40000;
        this.state_0_ |= 0x80000;
        this.state_0_ |= 0x100000;
        this.state_0_ |= 0x200000;
        BranchProfile exception__ = BranchProfile.create();
        Objects.requireNonNull(exception__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        VarHandle.storeStoreFence();
        this.fromGlobal_exception_ = exception__;
        this.fromGlobal_exception_.disable();
        this.state_0_ |= 0x400000;
        BranchProfile exception__1 = BranchProfile.create();
        Objects.requireNonNull(exception__1, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
        VarHandle.storeStoreFence();
        this.fromThreadLocalGlobal_exception_ = exception__1;
        this.fromThreadLocalGlobal_exception_.disable();
        this.state_0_ |= 0x800000;
        this.state_0_ |= 0x1000000;
        int state_0 = this.state_0_;
        state_0 |= 1;
        this.state_0_ = state_0 |= 0xE000000;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
        this.fromGlobal_exception_.reset();
        this.fromThreadLocalGlobal_exception_.reset();
    }

    @NeverDefault
    public static LLVMToDebugValueNode create() {
        return new LLVMToDebugValueNodeGen();
    }

    @NeverDefault
    public static LLVMToDebugValueNode getUncached() {
        return UNCACHED;
    }

    @GeneratedBy(value=LLVMToDebugValueNode.class)
    @DenyReplace
    private static final class Uncached
    extends LLVMToDebugValueNode
    implements UnadoptableNode {
        private Uncached() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected LLVMDebugValue executeWithTarget(Object arg0Value) {
            if (arg0Value instanceof Boolean) {
                boolean arg0Value_ = (Boolean)arg0Value;
                return this.fromBoolean(arg0Value_);
            }
            if (arg0Value instanceof Byte) {
                byte arg0Value_ = (Byte)arg0Value;
                return this.fromByte(arg0Value_);
            }
            if (arg0Value instanceof Short) {
                short arg0Value_ = (Short)arg0Value;
                return this.fromShort(arg0Value_);
            }
            if (arg0Value instanceof Integer) {
                int arg0Value_ = (Integer)arg0Value;
                return this.fromInt(arg0Value_);
            }
            if (arg0Value instanceof Long) {
                long arg0Value_ = (Long)arg0Value;
                return this.fromLong(arg0Value_);
            }
            if (LLVMTypesGen.isImplicitLLVMIVarBit(arg0Value)) {
                LLVMIVarBit arg0Value_ = LLVMTypesGen.asImplicitLLVMIVarBit(arg0Value);
                return this.fromIVarBit(arg0Value_);
            }
            if (LLVMTypes.isNativePointer(arg0Value)) {
                LLVMNativePointer arg0Value_ = LLVMTypes.asNativePointer(arg0Value);
                return this.fromNativePointer(arg0Value_);
            }
            if (LLVMTypes.isManagedPointer(arg0Value)) {
                LLVMManagedPointer arg0Value_ = LLVMTypes.asManagedPointer(arg0Value);
                return this.fromManagedPointer(arg0Value_);
            }
            if (arg0Value instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor arg0Value_ = (LLVMFunctionDescriptor)arg0Value;
                return this.fromFunctionHandle(arg0Value_);
            }
            if (arg0Value instanceof Float) {
                float arg0Value_ = ((Float)arg0Value).floatValue();
                return this.fromFloat(arg0Value_);
            }
            if (arg0Value instanceof Double) {
                double arg0Value_ = (Double)arg0Value;
                return this.fromDouble(arg0Value_);
            }
            if (arg0Value instanceof LLVM80BitFloat) {
                LLVM80BitFloat arg0Value_ = (LLVM80BitFloat)arg0Value;
                return this.from80BitFloat(arg0Value_);
            }
            if (arg0Value instanceof LLVMI1Vector) {
                LLVMI1Vector arg0Value_ = (LLVMI1Vector)arg0Value;
                return this.fromI1Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI8Vector) {
                LLVMI8Vector arg0Value_ = (LLVMI8Vector)arg0Value;
                return this.fromI8Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI16Vector) {
                LLVMI16Vector arg0Value_ = (LLVMI16Vector)arg0Value;
                return this.fromI16Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI32Vector) {
                LLVMI32Vector arg0Value_ = (LLVMI32Vector)arg0Value;
                return this.fromI32Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMI64Vector) {
                LLVMI64Vector arg0Value_ = (LLVMI64Vector)arg0Value;
                return this.fromI64Vector(arg0Value_);
            }
            if (arg0Value instanceof LLVMFloatVector) {
                LLVMFloatVector arg0Value_ = (LLVMFloatVector)arg0Value;
                return this.fromFloatVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMDoubleVector) {
                LLVMDoubleVector arg0Value_ = (LLVMDoubleVector)arg0Value;
                return this.fromDoubleVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMPointerVector) {
                LLVMPointerVector arg0Value_ = (LLVMPointerVector)arg0Value;
                return this.fromAddressVector(arg0Value_);
            }
            if (arg0Value instanceof LLVMGlobalContainer) {
                LLVMGlobalContainer arg0Value_ = (LLVMGlobalContainer)arg0Value;
                return this.fromGlobalContainer(arg0Value_);
            }
            if (arg0Value instanceof LLVMDebugGlobalVariable) {
                LLVMDebugGlobalVariable arg0Value_ = (LLVMDebugGlobalVariable)arg0Value;
                return this.fromGlobal(arg0Value_, BranchProfile.getUncached());
            }
            if (arg0Value instanceof LLVMDebugThreadLocalGlobalVariable) {
                LLVMDebugThreadLocalGlobalVariable arg0Value_ = (LLVMDebugThreadLocalGlobalVariable)arg0Value;
                return this.fromThreadLocalGlobal(arg0Value_, BranchProfile.getUncached());
            }
            return this.fromGenericObject(arg0Value);
        }
    }
}

