/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.coff;

import com.oracle.truffle.llvm.parser.coff.CoffFile;
import com.oracle.truffle.llvm.parser.coff.PEFile;
import com.oracle.truffle.llvm.parser.filereader.ObjectFileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.collections.Pair;

public final class ExportTable {
    private final List<Pair<String, Export>> exports;
    public static final ExportTable EMPTY = new ExportTable(Collections.emptyList());

    private ExportTable(List<Pair<String, Export>> exports) {
        this.exports = exports;
    }

    public Iterable<Pair<String, Export>> getExports() {
        return this.exports;
    }

    static ExportTable create(CoffFile file, PEFile.ImageDataDirectorySection section) {
        ObjectFileReader reader = section.getReader(file);
        ExportDirectoryTable exportTable = ExportDirectoryTable.read(file, reader);
        ArrayList<Pair<String, Export>> exports = new ArrayList<Pair<String, Export>>(exportTable.numberOfNamePointers);
        int[] exportAddressEntries = ExportTable.readIntArray(exportTable.exportAddressTableRVA, exportTable.addressTableEntries, file);
        int[] nameRVAs = ExportTable.readIntArray(exportTable.namePointerRVA, exportTable.numberOfNamePointers, file);
        short[] ordinalNumbers = ExportTable.readShortArray(exportTable.ordinalTableRVA, exportTable.numberOfNamePointers, file);
        for (int i = 0; i < exportTable.numberOfNamePointers; ++i) {
            String name = file.readStringAtVirtualOffset(nameRVAs[i]);
            int exportAddress = exportAddressEntries[ordinalNumbers[i]];
            if (section.isRVAInBounds(exportAddress)) {
                String exportName = file.readStringAtVirtualOffset(exportAddress);
                exports.add((Pair<String, Export>)Pair.create((Object)name, (Object)new ExportName(exportName)));
                continue;
            }
            exports.add((Pair<String, Export>)Pair.create((Object)name, (Object)new ExportRVA(exportAddress)));
        }
        return new ExportTable(exports);
    }

    private static int[] readIntArray(int position, int count, CoffFile file) {
        ObjectFileReader reader = file.getReaderAtVirtualAddress(position);
        int[] res = new int[count];
        for (int i = 0; i < count; ++i) {
            res[i] = reader.getInt();
        }
        return res;
    }

    private static short[] readShortArray(int position, int count, CoffFile file) {
        ObjectFileReader reader = file.getReaderAtVirtualAddress(position);
        short[] res = new short[count];
        for (int i = 0; i < count; ++i) {
            res[i] = reader.getShort();
        }
        return res;
    }

    public static final class ExportDirectoryTable {
        int exportFlags;
        int timeDateStamp;
        short majorVersion;
        short minorVersion;
        String name;
        int ordinalBase;
        int addressTableEntries;
        int numberOfNamePointers;
        int exportAddressTableRVA;
        int namePointerRVA;
        int ordinalTableRVA;

        private static ExportDirectoryTable read(CoffFile file, ObjectFileReader reader) {
            int start = reader.getPosition();
            ExportDirectoryTable table = new ExportDirectoryTable();
            table.exportFlags = reader.getInt();
            table.timeDateStamp = reader.getInt();
            table.majorVersion = reader.getShort();
            table.minorVersion = reader.getShort();
            int nameOffset = reader.getInt();
            table.ordinalBase = reader.getInt();
            table.addressTableEntries = reader.getInt();
            table.numberOfNamePointers = reader.getInt();
            table.exportAddressTableRVA = reader.getInt();
            table.namePointerRVA = reader.getInt();
            table.ordinalTableRVA = reader.getInt();
            assert (reader.getPosition() - start == 40);
            table.name = file.readStringAtVirtualOffset(nameOffset);
            return table;
        }
    }

    public static final class ExportName
    extends Export {
        private final String name;

        private ExportName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }

    public static final class ExportRVA
    extends Export {
        private final int rva;

        private ExportRVA(int rva) {
            this.rva = rva;
        }

        public int getRVA() {
            return this.rva;
        }
    }

    public static abstract class Export {
    }
}

