/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr;

import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.nodes.DebugExprNodeFactory;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.DebugExprException;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr.DebugExpressionLexer;
import com.oracle.truffle.llvm.runtime.debug.debugexpr.parser.antlr.DebugExpressionParser;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import org.graalvm.shadowed.org.antlr.v4.runtime.ANTLRErrorListener;
import org.graalvm.shadowed.org.antlr.v4.runtime.BaseErrorListener;
import org.graalvm.shadowed.org.antlr.v4.runtime.CharStream;
import org.graalvm.shadowed.org.antlr.v4.runtime.CharStreams;
import org.graalvm.shadowed.org.antlr.v4.runtime.CommonTokenStream;
import org.graalvm.shadowed.org.antlr.v4.runtime.RecognitionException;
import org.graalvm.shadowed.org.antlr.v4.runtime.Recognizer;
import org.graalvm.shadowed.org.antlr.v4.runtime.TokenSource;
import org.graalvm.shadowed.org.antlr.v4.runtime.TokenStream;

public class DebugExprParser {
    private final DebugExpressionParser parser;
    private final DebugExpressionLexer lexer;
    private final String asmSnippet;

    public DebugExprParser(TruffleLanguage.InlineParsingRequest request, Object globalScope) {
        this.asmSnippet = request.getSource().getCharacters().toString();
        this.lexer = new DebugExpressionLexer((CharStream)CharStreams.fromString((String)this.asmSnippet));
        this.parser = new DebugExpressionParser((TokenStream)new CommonTokenStream((TokenSource)this.lexer));
        DebugExprNodeFactory nodeFactory = DebugExprNodeFactory.create(globalScope, request.getFrame(), request.getLocation());
        this.parser.setNodeFactory(nodeFactory);
    }

    public LLVMExpressionNode parse() throws DebugExprException {
        this.lexer.removeErrorListeners();
        this.parser.removeErrorListeners();
        BailoutErrorListener listener = new BailoutErrorListener(this.asmSnippet);
        this.lexer.addErrorListener((ANTLRErrorListener)listener);
        this.parser.addErrorListener((ANTLRErrorListener)listener);
        this.parser.debugExpr();
        LLVMExpressionNode root = this.parser.GetASTRoot();
        if (this.parser.getNumberOfSyntaxErrors() == 0) {
            return root;
        }
        throw DebugExprException.create(root, ((Object)((Object)listener)).toString().replace("\n", "").replace("\r", ""), new Object[0]);
    }

    private static final class BailoutErrorListener
    extends BaseErrorListener {
        private final String snippet;

        BailoutErrorListener(String snippet) {
            this.snippet = snippet;
        }

        public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            String location = "-- line " + line + " col " + (charPositionInLine + 1) + ": ";
            throw DebugExprException.create(null, "Debug Expression error in %s:\n%s%s", this.snippet, location, msg);
        }
    }
}

