/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.intrinsics.interop;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.except.LLVMPolyglotException;
import com.oracle.truffle.llvm.runtime.interop.LLVMInternalTruffleObject;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedReadLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMManagedWriteLibrary;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMToPointerNode;
import com.oracle.truffle.llvm.runtime.nodes.intrinsics.llvm.LLVMIntrinsic;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMNativePointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;

@NodeChild(type=LLVMExpressionNode.class)
public abstract class LLVMTruffleManagedMalloc
extends LLVMIntrinsic {
    @Specialization
    protected Object doIntrinsic(long size, @Cached BranchProfile exception) {
        if (size < 0L) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Can't truffle_managed_malloc less than zero bytes");
        }
        long sizeInWords = (size + 8L - 1L) / 8L;
        if (sizeInWords > Integer.MAX_VALUE) {
            exception.enter();
            throw new LLVMPolyglotException(this, "Can't truffle_managed_malloc for more than 2^31 objects");
        }
        return LLVMManagedPointer.create(new ManagedMallocObject((int)sizeInWords));
    }

    @ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=LLVMManagedReadLibrary.class, useForAOT=true, useForAOTPriority=1), @ExportLibrary(value=LLVMManagedWriteLibrary.class, useForAOT=true, useForAOTPriority=2), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=true, useForAOTPriority=3), @ExportLibrary(value=LLVMAsForeignLibrary.class, useForAOT=true, useForAOTPriority=4)})
    public static final class ManagedMallocObject
    extends LLVMInternalTruffleObject {
        private final LLVMPointer[] contents;
        private static final LLVMInteropType NATIVE_TYPE = LLVMInteropType.ValueKind.POINTER.type.toArray(0L);

        public ManagedMallocObject(int entries) {
            this.contents = new LLVMPointer[entries];
        }

        public LLVMPointer get(int index) {
            return this.contents[index];
        }

        public void set(int index, LLVMPointer value) {
            this.contents[index] = value;
        }

        @ExportMessage
        static boolean hasNativeType(ManagedMallocObject receiver) {
            return true;
        }

        @ExportMessage
        static Object getNativeType(ManagedMallocObject receiver) {
            return NATIVE_TYPE;
        }

        @ExportMessage
        static boolean hasArrayElements(ManagedMallocObject receiver) {
            return true;
        }

        @ExportMessage
        static long getArraySize(ManagedMallocObject receiver) {
            return receiver.contents.length;
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isArrayElementReadable"), @ExportMessage(name="isArrayElementModifiable"), @ExportMessage(name="isArrayElementInsertable")})
        static boolean isArrayElementValid(ManagedMallocObject receiver, long index) {
            return 0L <= index && index < ManagedMallocObject.getArraySize(receiver);
        }

        @ExportMessage
        static Object readArrayElement(ManagedMallocObject receiver, long index, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (ManagedMallocObject.isArrayElementValid(receiver, index)) {
                return receiver.get((int)index);
            }
            exception.enter();
            throw InvalidArrayIndexException.create((long)index);
        }

        @ExportMessage
        static void writeArrayElement(ManagedMallocObject receiver, long index, Object value, @Cached LLVMToPointerNode toPointer, @Cached.Shared(value="exception") @Cached BranchProfile exception) throws InvalidArrayIndexException {
            if (!ManagedMallocObject.isArrayElementValid(receiver, index)) {
                exception.enter();
                throw InvalidArrayIndexException.create((long)index);
            }
            receiver.set((int)index, toPointer.executeWithTarget(value));
        }

        @ExportMessage.Repeat(value={@ExportMessage(name="isReadable"), @ExportMessage(name="isWritable")})
        static boolean isAccessible(ManagedMallocObject receiver) {
            return true;
        }

        @ExportMessage
        static byte readI8(ManagedMallocObject receiver, long offset, @CachedLibrary(value="receiver") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read I8 from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static short readI16(ManagedMallocObject receiver, long offset, @CachedLibrary(value="receiver") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read I16 from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static int readI32(ManagedMallocObject receiver, long offset, @CachedLibrary(value="receiver") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read I32 from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static double readDouble(ManagedMallocObject receiver, long offset, @CachedLibrary(value="receiver") LLVMManagedReadLibrary read) {
            throw new LLVMPolyglotException((Node)read, "Can't read double from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static LLVMPointer readPointer(ManagedMallocObject receiver, long offset, @Cached BranchProfile exception, @CachedLibrary(value="receiver") LLVMManagedReadLibrary read) {
            long idx;
            if (offset % 8L == 0L && (idx = offset / 8L) == (long)((int)idx)) {
                return receiver.get((int)idx);
            }
            exception.enter();
            throw new LLVMPolyglotException((Node)read, "Can't read pointer from managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static LLVMPointer readGenericI64(ManagedMallocObject receiver, long offset, @CachedLibrary(value="receiver") LLVMManagedReadLibrary read) {
            return read.readPointer(receiver, offset);
        }

        @ExportMessage
        static void writeI8(ManagedMallocObject receiver, long offset, byte value, @CachedLibrary(value="receiver") LLVMManagedWriteLibrary write) {
            throw new LLVMPolyglotException((Node)write, "Can't write I8 to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static void writeI16(ManagedMallocObject receiver, long offset, short value, @CachedLibrary(value="receiver") LLVMManagedWriteLibrary write) {
            throw new LLVMPolyglotException((Node)write, "Can't write I16 to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static void writeI32(ManagedMallocObject receiver, long offset, int value, @CachedLibrary(value="receiver") LLVMManagedWriteLibrary write) {
            throw new LLVMPolyglotException((Node)write, "Can't write I32 to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static void writePointer(ManagedMallocObject receiver, long offset, LLVMPointer value, @Cached BranchProfile exception, @CachedLibrary(value="receiver") LLVMManagedWriteLibrary write) {
            long idx;
            if (offset % 8L == 0L && (idx = offset / 8L) == (long)((int)idx)) {
                receiver.set((int)idx, value);
                return;
            }
            exception.enter();
            throw new LLVMPolyglotException((Node)write, "Can't write pointer to managed malloc object at offset %d.", offset);
        }

        @ExportMessage
        static void writeI64(ManagedMallocObject receiver, long offset, long value, @CachedLibrary(value="receiver") LLVMManagedWriteLibrary write) {
            write.writePointer(receiver, offset, LLVMNativePointer.create(value));
        }

        @ExportMessage
        static void writeGenericI64(ManagedMallocObject receiver, long offset, Object value, @Cached LLVMToPointerNode toPointer, @CachedLibrary(value="receiver") LLVMManagedWriteLibrary write) {
            write.writePointer(receiver, offset, toPointer.executeWithTarget(value));
        }

        @ExportMessage
        static boolean isForeign(ManagedMallocObject receiver) {
            return false;
        }
    }
}

