/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.literal;

import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@NodeChild(value="address", type=LLVMExpressionNode.class)
public abstract class LLVMArrayLiteralNode
extends LLVMExpressionNode {
    @Node.Children
    private final LLVMExpressionNode[] values;
    @Node.Child
    private LLVMStoreNode write;
    private final long stride;

    public LLVMArrayLiteralNode(LLVMExpressionNode[] values, long stride, LLVMStoreNode write) {
        this.values = values;
        this.stride = stride;
        this.write = write;
    }

    public LLVMExpressionNode[] getValues() {
        return this.values;
    }

    @Specialization
    @ExplodeLoop
    protected LLVMPointer foreignWrite(VirtualFrame frame, LLVMPointer addr) {
        LLVMPointer currentPtr = addr;
        for (int i = 0; i < this.values.length; ++i) {
            this.write.executeWithTarget(frame, currentPtr, this.values[i].executeGeneric(frame));
            currentPtr = currentPtr.increment(this.stride);
        }
        return addr;
    }
}

