/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMIntrinsicProvider;
import com.oracle.truffle.llvm.runtime.LLVMLanguage;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.debug.type.LLVMSourceFunctionType;
import com.oracle.truffle.llvm.runtime.interop.LLVMForeignCallNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNode;
import com.oracle.truffle.llvm.runtime.nodes.literals.LLVMSimpleLiteralNodeFactory;
import com.oracle.truffle.llvm.runtime.types.PointerType;
import com.oracle.truffle.llvm.runtime.types.PrimitiveType;
import com.oracle.truffle.llvm.runtime.types.Type;

public class LLVMForeignConstructorCallNode
extends LLVMForeignCallNode {
    @Node.Child
    LLVMExpressionNode malloc;

    public static LLVMForeignConstructorCallNode create(LLVMLanguage language, LLVMFunctionCode function, LLVMInteropType interopType, LLVMSourceFunctionType sourceType, LLVMInteropType.Structured structuredType) {
        Type escapeType = function.getLLVMFunction().getType().getArgumentType(0);
        return new LLVMForeignConstructorCallNode(language, function, interopType, sourceType, structuredType, escapeType);
    }

    protected LLVMForeignConstructorCallNode(LLVMLanguage language, LLVMFunctionCode function, LLVMInteropType interopType, LLVMSourceFunctionType sourceType, LLVMInteropType.Structured structuredType, Type escapeType) {
        super(language, function, interopType, sourceType, structuredType, escapeType);
        NodeFactory factory = language.getActiveConfiguration().createNodeFactory(language, language.getDefaultDataLayout());
        LLVMExpressionNode stack = factory.createGetStackFromFrame();
        LLVMSimpleLiteralNode.LLVMI64LiteralNode size = LLVMSimpleLiteralNodeFactory.LLVMI64LiteralNodeGen.create(this.returnBaseType.getSize());
        this.malloc = language.getCapability(LLVMIntrinsicProvider.class).generateIntrinsicNode("malloc", new LLVMExpressionNode[]{stack, size}, new Type[]{PointerType.VOID, PrimitiveType.I64}, factory);
    }

    @Override
    protected Object doCall(VirtualFrame frame, LLVMStack stack) throws ArityException, Type.TypeOverflowException {
        Object[] rawArguments = frame.getArguments();
        rawArguments[0] = this.malloc.executeGeneric(frame);
        if (this.packArguments.toLLVM.length != rawArguments.length) {
            int arity = this.packArguments.toLLVM.length - 1;
            throw ArityException.create((int)arity, (int)arity, (int)(rawArguments.length - 1));
        }
        Object[] arguments = this.packArguments.execute(rawArguments, stack);
        this.callNode.call(arguments);
        return arguments[1];
    }
}

