/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.except.LLVMLinkerException;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropNonvirtualCallNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMDynAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMInteropNonvirtualCallNode
extends LLVMNode {
    abstract Object execute(LLVMPointer var1, LLVMInteropType.Clazz var2, String var3, LLVMInteropType.Method var4, Object[] var5) throws UnsupportedTypeException, ArityException, UnsupportedMessageException;

    public static LLVMInteropNonvirtualCallNode create() {
        return LLVMInteropNonvirtualCallNodeGen.create();
    }

    @Specialization(guards={"argCount==arguments.length", "llvmFunction!=null", "methodName==method.getName()", "type==method.getObjectClass()", "type==asClazz(receiver)"})
    @GenerateAOT.Exclude
    Object doCached(LLVMPointer receiver, LLVMInteropType.Clazz type, String methodName, LLVMInteropType.Method method, Object[] arguments, @CachedLibrary(limit="5") InteropLibrary interop, @Cached(value="arguments.length", allowUncached=true) int argCount, @Cached(value="getLLVMFunctionUncached(method, type)", allowUncached=true) LLVMFunction llvmFunction, @Cached LLVMDynAccessSymbolNode accessSymbolNode) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        return interop.execute((Object)accessSymbolNode.execute(llvmFunction), arguments);
    }

    @Specialization
    @GenerateAOT.Exclude
    Object doResolve(LLVMPointer receiver, LLVMInteropType.Clazz type, String methodName, LLVMInteropType.Method method, Object[] arguments, @Cached LLVMDynAccessSymbolNode dynAccessSymbolNode, @CachedLibrary(limit="5") InteropLibrary interop, @Cached BranchProfile notFound) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
        LLVMInteropType.Method newMethod = type.findMethodByArgumentsWithSelf(methodName, arguments);
        LLVMFunction newLLVMFunction = this.getLLVMFunction(newMethod, type, notFound);
        LLVMPointer newReceiver = dynAccessSymbolNode.execute(newLLVMFunction);
        return interop.execute((Object)newReceiver, arguments);
    }

    @CompilerDirectives.TruffleBoundary
    private static String mkErrorMessage(LLVMInteropType.Clazz clazz, LLVMInteropType.Method method) {
        String clazzName = clazz.toString().startsWith("class ") ? clazz.toString().substring(6) : clazz.toString();
        return String.format("No implementation of declared method %s::%s (%s) found", clazzName, method.getName(), method.getLinkageName());
    }

    final LLVMFunction getLLVMFunctionUncached(LLVMInteropType.Method method, LLVMInteropType.Clazz clazz) {
        return this.getLLVMFunction(method, clazz, BranchProfile.getUncached());
    }

    final LLVMFunction getLLVMFunction(LLVMInteropType.Method method, LLVMInteropType.Clazz clazz, BranchProfile notFound) {
        LLVMFunction llvmFunction = this.getContext().getGlobalScopeChain().getFunction(method.getLinkageName());
        if (llvmFunction == null) {
            notFound.enter();
            throw new LLVMLinkerException(this, LLVMInteropNonvirtualCallNode.mkErrorMessage(clazz, method));
        }
        return llvmFunction;
    }

    static LLVMInteropType.Clazz asClazz(LLVMPointer receiver) throws UnsupportedTypeException {
        LLVMInteropType type = receiver.getExportType();
        if (type instanceof LLVMInteropType.Clazz) {
            return (LLVMInteropType.Clazz)type;
        }
        throw UnsupportedTypeException.create((Object[])new Object[]{receiver});
    }
}

