/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.library.internal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.FinalBitSet;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary;
import com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibraryDefaults;
import java.lang.invoke.MethodHandles;
import java.util.BitSet;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAsForeignLibrary.class)
final class LLVMAsForeignLibraryGen
extends LibraryFactory<LLVMAsForeignLibrary> {
    private static final Class<LLVMAsForeignLibrary> LIBRARY_CLASS = LLVMAsForeignLibraryGen.lazyLibraryClass();
    private static final Message IS_FOREIGN = new MessageImpl("isForeign", 0, false, Boolean.TYPE, Object.class);
    private static final Message AS_FOREIGN = new MessageImpl("asForeign", 1, false, Object.class, Object.class);
    private static final LLVMAsForeignLibraryGen INSTANCE = new LLVMAsForeignLibraryGen();

    private LLVMAsForeignLibraryGen() {
        super(LIBRARY_CLASS, List.of(IS_FOREIGN, AS_FOREIGN));
    }

    protected Class<?> getDefaultClass(Object receiver) {
        if (receiver instanceof byte[]) {
            return LLVMAsForeignLibraryDefaults.ArrayAsForeignLibrary.class;
        }
        return LLVMAsForeignLibraryDefaults.DefaultAsForeignLibrary.class;
    }

    protected MethodHandles.Lookup getLookup() {
        return MethodHandles.lookup();
    }

    protected LLVMAsForeignLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    protected FinalBitSet createMessageBitSet(Message ... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf((BitSet)bitSet);
    }

    protected LLVMAsForeignLibrary createDelegate(LLVMAsForeignLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        LLVMAsForeignLibrary lib = (LLVMAsForeignLibrary)originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0: {
                return lib.isForeign(receiver);
            }
            case 1: {
                return lib.asForeign(receiver);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    protected LLVMAsForeignLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    protected LLVMAsForeignLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    private static Class<LLVMAsForeignLibrary> lazyLibraryClass() {
        try {
            return Class.forName("com.oracle.truffle.llvm.runtime.library.internal.LLVMAsForeignLibrary", false, LLVMAsForeignLibraryGen.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    static {
        LibraryFactory.register(LIBRARY_CLASS, (LibraryFactory)INSTANCE);
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    private static final class Proxy
    extends LLVMAsForeignLibrary {
        @Node.Child
        private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public boolean isForeign(Object receiver_) {
            try {
                return (Boolean)this.lib.send(receiver_, IS_FOREIGN, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        @Override
        public Object asForeign(Object receiver_) {
            try {
                return this.lib.send(receiver_, AS_FOREIGN, new Object[0]);
            }
            catch (RuntimeException e_) {
                throw e_;
            }
            catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e_);
            }
        }

        public boolean accepts(Object receiver_) {
            return this.lib.accepts(receiver_);
        }
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    private static final class Delegate
    extends LLVMAsForeignLibrary {
        @Node.Child
        private LLVMAsForeignLibrary delegateLibrary;

        Delegate(LLVMAsForeignLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public boolean isForeign(Object receiver_) {
            if (LLVMAsForeignLibraryGen.isDelegated((Library)this.delegateLibrary, (int)0)) {
                Object delegate = LLVMAsForeignLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMAsForeignLibrary)LLVMAsForeignLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).isForeign(delegate);
            }
            return this.delegateLibrary.isForeign(receiver_);
        }

        @Override
        public Object asForeign(Object receiver_) {
            if (LLVMAsForeignLibraryGen.isDelegated((Library)this.delegateLibrary, (int)1)) {
                Object delegate = LLVMAsForeignLibraryGen.readDelegate((Library)this.delegateLibrary, (Object)receiver_);
                return ((LLVMAsForeignLibrary)LLVMAsForeignLibraryGen.getDelegateLibrary((Library)this.delegateLibrary, (Object)delegate)).asForeign(delegate);
            }
            return this.delegateLibrary.asForeign(receiver_);
        }

        public boolean accepts(Object receiver_) {
            return this.delegateLibrary.accepts(receiver_);
        }

        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    private static final class CachedDispatchFirst
    extends CachedDispatch
    implements GenerateAOT.Provider {
        private final int limit_;
        private volatile boolean aot_;

        CachedDispatchFirst(LLVMAsForeignLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        void setAOT(boolean value) {
            this.aot_ = value;
        }

        @Override
        boolean isAOT() {
            return this.aot_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if (this.aot_) {
                return;
            }
            for (LibraryExport export : INSTANCE.getAOTExports()) {
                LLVMAsForeignLibrary exportLibrary = (LLVMAsForeignLibrary)INSTANCE.createAOT(export);
                if (this.library == null) {
                    this.library = (LLVMAsForeignLibrary)this.insert((Node)exportLibrary);
                    continue;
                }
                this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext(exportLibrary, this.next));
            }
            this.aot_ = true;
        }
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    private static abstract class CachedDispatch
    extends LLVMAsForeignLibrary {
        @Node.Child
        LLVMAsForeignLibrary library;
        @Node.Child
        CachedDispatch next;

        CachedDispatch(LLVMAsForeignLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        abstract boolean isAOT();

        abstract void setAOT(boolean var1);

        @Override
        @ExplodeLoop
        public boolean isForeign(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMAsForeignLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.isForeign(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        @Override
        @ExplodeLoop
        public Object asForeign(Object receiver_) {
            if (CompilerDirectives.inInterpreter() && this.isAOT()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
            while (true) {
                CachedDispatch current = this;
                do {
                    LLVMAsForeignLibrary thisLibrary;
                    if ((thisLibrary = current.library) == null || !thisLibrary.accepts(receiver_)) continue;
                    return thisLibrary.asForeign(receiver_);
                } while ((current = current.next) != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.specialize(receiver_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void specialize(Object receiver_) {
            Lock lock = this.getLock();
            lock.lock();
            try {
                if (this.isAOT()) {
                    this.library = null;
                    this.next = null;
                    this.setAOT(false);
                }
                CachedDispatch current = this;
                LLVMAsForeignLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = (LLVMAsForeignLibrary)this.insert((Node)((LLVMAsForeignLibrary)INSTANCE.create(receiver_)));
                } else {
                    int count = 0;
                    do {
                        LLVMAsForeignLibrary currentLibrary;
                        if ((currentLibrary = current.library) != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        ++count;
                    } while ((current = current.next) != null);
                    if (count >= this.getLimit()) {
                        this.library = (LLVMAsForeignLibrary)this.insert((Node)new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = (CachedDispatch)this.insert((Node)new CachedDispatchNext((LLVMAsForeignLibrary)INSTANCE.create(receiver_), this.next));
                    }
                }
            }
            finally {
                lock.unlock();
            }
        }
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch
    extends LLVMAsForeignLibrary
    implements UnadoptableNode {
        private UncachedDispatch() {
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isForeign(Object receiver_) {
            return ((LLVMAsForeignLibrary)INSTANCE.getUncached(receiver_)).isForeign(receiver_);
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object asForeign(Object receiver_) {
            return ((LLVMAsForeignLibrary)INSTANCE.getUncached(receiver_)).asForeign(receiver_);
        }

        @CompilerDirectives.TruffleBoundary
        public boolean accepts(Object receiver_) {
            return true;
        }
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    private static class MessageImpl
    extends Message {
        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?> ... parameters) {
            super(LIBRARY_CLASS, name, index, deprecated, returnType, (Class[])parameters);
        }
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    private static final class CachedDispatchNext
    extends CachedDispatch {
        CachedDispatchNext(LLVMAsForeignLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        void setAOT(boolean value) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        boolean isAOT() {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GeneratedBy(value=LLVMAsForeignLibrary.class)
    private static final class CachedToUncachedDispatch
    extends LLVMAsForeignLibrary {
        private CachedToUncachedDispatch() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public boolean isForeign(Object receiver_) {
            assert (LLVMAsForeignLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                boolean bl = ((LLVMAsForeignLibrary)INSTANCE.getUncached(receiver_)).isForeign(receiver_);
                return bl;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @CompilerDirectives.TruffleBoundary
        public Object asForeign(Object receiver_) {
            assert (LLVMAsForeignLibraryGen.assertAdopted((Node)((Node)this)));
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(this.getParent());
            try {
                Object object = ((LLVMAsForeignLibrary)INSTANCE.getUncached(receiver_)).asForeign(receiver_);
                return object;
            }
            finally {
                encapsulating_.set(prev_);
            }
        }

        public boolean accepts(Object receiver_) {
            return true;
        }
    }
}

