/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.func;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.LLVMFunction;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMCallNode;
import com.oracle.truffle.llvm.runtime.types.FunctionType;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMCallNode.class)
public final class LLVMCallNodeGen
extends LLVMCallNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode dispatchTarget_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMCallNodeGen(FunctionType functionType, LLVMExpressionNode[] argumentNodes, boolean isSourceCall, boolean mustTail, LLVMFunction llvmFunction, LLVMExpressionNode dispatchTarget) {
        super(functionType, argumentNodes, isSourceCall, mustTail, llvmFunction);
        this.dispatchTarget_ = dispatchTarget;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int state_0 = this.state_0_;
        Object dispatchTargetValue_ = this.dispatchTarget_.executeGeneric(frameValue);
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(frameValue, dispatchTargetValue_);
        }
        if ((state_0 & 6) != 0) {
            if ((state_0 & 2) != 0) {
                assert (DSLSupport.assertIdempotence((!this.mustTail ? (byte)1 : 0) != 0));
                return this.doCall(frameValue, dispatchTargetValue_);
            }
            if ((state_0 & 4) != 0) {
                assert (DSLSupport.assertIdempotence((boolean)this.mustTail));
                return this.doTailCall(frameValue, dispatchTargetValue_);
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(frameValue, dispatchTargetValue_);
    }

    private Object executeAndSpecialize(VirtualFrame frameValue, Object dispatchTargetValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (!this.mustTail) {
            this.state_0_ = state_0 |= 2;
            return this.doCall(frameValue, dispatchTargetValue);
        }
        if (this.mustTail) {
            this.state_0_ = state_0 |= 4;
            return this.doTailCall(frameValue, dispatchTargetValue);
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.dispatchTarget_}, new Object[]{dispatchTargetValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        if (!this.mustTail) {
            this.state_0_ |= 2;
        }
        if (this.mustTail) {
            this.state_0_ |= 4;
        }
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMCallNode create(FunctionType functionType, LLVMExpressionNode[] argumentNodes, boolean isSourceCall, boolean mustTail, LLVMFunction llvmFunction, LLVMExpressionNode dispatchTarget) {
        return new LLVMCallNodeGen(functionType, argumentNodes, isSourceCall, mustTail, llvmFunction, dispatchTarget);
    }
}

