/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.memory.store;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMStoreNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMTypes;
import com.oracle.truffle.llvm.runtime.nodes.memory.store.LLVMOffsetStoreNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMOffsetStoreNode.class)
public final class LLVMOffsetStoreNodeFactory {

    @GeneratedBy(value=LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode.class)
    public static final class LLVMGenericOffsetStoreNodeGen
    extends LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode
    implements GenerateAOT.Provider {
        @Node.Child
        private LLVMExpressionNode target_;
        @Node.Child
        private LLVMExpressionNode offset_;
        @Node.Child
        private LLVMExpressionNode value_;
        @CompilerDirectives.CompilationFinal
        private int state_0_;

        private LLVMGenericOffsetStoreNodeGen(LLVMStoreNode store, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            super(store);
            this.target_ = target;
            this.offset_ = offset;
            this.value_ = value;
        }

        @Override
        public void executeWithTarget(VirtualFrame frameValue, LLVMPointer targetValue, long offsetValue) {
            int state_0 = this.state_0_;
            Object valueValue_ = this.value_.executeGeneric(frameValue);
            if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
                this.executeAndSpecialize(frameValue, targetValue, offsetValue, valueValue_);
                return;
            }
            if ((state_0 & 2) != 0) {
                this.doOp(frameValue, targetValue, offsetValue, valueValue_);
                return;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.executeAndSpecialize(frameValue, targetValue, offsetValue, valueValue_);
        }

        private void executeAndSpecialize(VirtualFrame frameValue, Object targetValue, Object offsetValue, Object valueValue) {
            int state_0 = this.state_0_;
            if ((state_0 & 1) != 0) {
                this.resetAOT_();
                state_0 = this.state_0_;
            }
            if (LLVMTypes.isPointer(targetValue)) {
                LLVMPointer targetValue_ = LLVMTypes.asPointer(targetValue);
                if (offsetValue instanceof Long) {
                    long offsetValue_ = (Long)offsetValue;
                    this.state_0_ = state_0 |= 2;
                    this.doOp(frameValue, targetValue_, offsetValue_, valueValue);
                    return;
                }
            }
            throw new UnsupportedSpecializationException((Node)this, new Node[]{this.target_, this.offset_, this.value_}, new Object[]{targetValue, offsetValue, valueValue});
        }

        public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
            assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
            if ((this.state_0_ & 1) != 0) {
                return;
            }
            this.state_0_ |= 2;
            int state_0 = this.state_0_;
            this.state_0_ = state_0 |= 1;
        }

        private void resetAOT_() {
            int state_0 = this.state_0_;
            if ((state_0 & 1) == 0) {
                return;
            }
            this.state_0_ = 0;
        }

        @NeverDefault
        public static LLVMOffsetStoreNode.LLVMGenericOffsetStoreNode create(LLVMStoreNode store, LLVMExpressionNode target, LLVMExpressionNode offset, LLVMExpressionNode value) {
            return new LLVMGenericOffsetStoreNodeGen(store, target, offset, value);
        }
    }
}

