/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.others;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.except.LLVMIllegalSymbolIndexException;
import com.oracle.truffle.llvm.runtime.memory.LLVMStack;
import com.oracle.truffle.llvm.runtime.nodes.func.LLVMRootNode;
import com.oracle.truffle.llvm.runtime.nodes.others.LLVMAccessSymbolNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

public abstract class LLVMAccessGlobalSymbolNode
extends LLVMAccessSymbolNode {
    LLVMAccessGlobalSymbolNode(LLVMSymbol symbol) {
        super(symbol);
    }

    @Specialization(guards={"isSingleContext($node)"})
    @GenerateAOT.Exclude
    public LLVMPointer accessSingleContext(@Cached BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        return this.checkNull(this.getContext().getSymbol(this.symbol, exception), exception);
    }

    protected LLVMStack.LLVMStackAccessHolder createStackAccessHolder() {
        return new LLVMStack.LLVMStackAccessHolder(((LLVMRootNode)this.getRootNode()).getStackAccess());
    }

    @Specialization
    public LLVMPointer accessMultiContext(VirtualFrame frame, @Cached(value="createStackAccessHolder()") LLVMStack.LLVMStackAccessHolder stackAccessHolder, @Cached BranchProfile exception) throws LLVMIllegalSymbolIndexException {
        return this.checkNull(stackAccessHolder.stackAccess.executeGetStack(frame).getContext().getSymbol(this.symbol, exception), exception);
    }
}

