/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.binary;

import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.ExportSymbolsMapper;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.graalvm.polyglot.io.ByteSequence;

public final class BinaryParserResult {
    private final ArrayList<String> libraries;
    private final ArrayList<String> paths;
    private final ByteSequence bitcode;
    private final LibraryLocator locator;
    private final ExportSymbolsMapper exportSymbolsMapper;
    private final Source source;
    private final String libraryName;

    BinaryParserResult(ArrayList<String> libraries, ArrayList<String> paths, ByteSequence bitcode, LibraryLocator locator, ExportSymbolsMapper exportSymbolsMapper, Source source, String libraryName) {
        this.libraries = libraries;
        this.paths = paths;
        this.bitcode = bitcode;
        this.locator = locator;
        this.exportSymbolsMapper = exportSymbolsMapper;
        this.source = source;
        this.libraryName = libraryName;
    }

    public List<String> getLibraries() {
        return Collections.unmodifiableList(this.libraries);
    }

    public List<String> getLibraryPaths() {
        return Collections.unmodifiableList(this.paths);
    }

    public ByteSequence getBitcode() {
        return this.bitcode;
    }

    public LibraryLocator getLocator() {
        return this.locator;
    }

    public ExportSymbolsMapper getExportSymbolsMapper() {
        return this.exportSymbolsMapper;
    }

    public Source getSource() {
        return this.source;
    }

    public String getLibraryName() {
        return this.libraryName;
    }
}

