/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.coff;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.llvm.runtime.DefaultLibraryLocator;
import com.oracle.truffle.llvm.runtime.LLVMContext;
import com.oracle.truffle.llvm.runtime.LibraryLocator;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class WindowsLibraryLocator
extends LibraryLocator {
    Path libraryPath;

    public WindowsLibraryLocator(Source source) {
        this.libraryPath = source == null || source.isInternal() ? null : Paths.get(source.getPath(), new String[0]).getParent();
    }

    @Override
    public Object locateLibrary(LLVMContext context, String lib, Object reason) {
        TruffleFile file;
        Path libPath = Paths.get(lib, new String[0]);
        if (libPath.isAbsolute()) {
            return DefaultLibraryLocator.locateAbsolute(context, libPath);
        }
        if (this.libraryPath != null && (file = DefaultLibraryLocator.locateAbsolute(context, this.libraryPath.resolve(libPath))) != null) {
            return file;
        }
        Path path = Paths.get(context.getEnv().getCurrentWorkingDirectory().getPath(), new String[0]);
        file = DefaultLibraryLocator.locateAbsolute(context, path.resolve(libPath));
        if (file != null) {
            return file;
        }
        return DefaultLibraryLocator.locateGlobal(context, lib);
    }
}

