/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.parser.util;

import com.oracle.truffle.llvm.parser.model.enums.BinaryOperator;
import com.oracle.truffle.llvm.parser.model.enums.CastOperator;
import com.oracle.truffle.llvm.parser.model.enums.UnaryOperator;
import com.oracle.truffle.llvm.runtime.ArithmeticOperation;
import com.oracle.truffle.llvm.runtime.CommonNodeFactory;
import com.oracle.truffle.llvm.runtime.NodeFactory;
import com.oracle.truffle.llvm.runtime.UnaryOperation;
import com.oracle.truffle.llvm.runtime.except.LLVMParserException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.types.Type;

public final class LLVMBitcodeTypeHelper {
    public static LLVMExpressionNode createArithmeticInstruction(LLVMExpressionNode lhs, LLVMExpressionNode rhs, BinaryOperator operator, Type type, NodeFactory nodeFactory) {
        return nodeFactory.createArithmeticOp(LLVMBitcodeTypeHelper.getArithmeticOperation(operator), type, lhs, rhs);
    }

    private static ArithmeticOperation getArithmeticOperation(BinaryOperator operator) {
        switch (operator) {
            case INT_ADD: 
            case FP_ADD: {
                return ArithmeticOperation.ADD;
            }
            case INT_SUBTRACT: 
            case FP_SUBTRACT: {
                return ArithmeticOperation.SUB;
            }
            case INT_MULTIPLY: 
            case FP_MULTIPLY: {
                return ArithmeticOperation.MUL;
            }
            case INT_UNSIGNED_DIVIDE: {
                return ArithmeticOperation.UDIV;
            }
            case INT_SIGNED_DIVIDE: 
            case FP_DIVIDE: {
                return ArithmeticOperation.DIV;
            }
            case INT_UNSIGNED_REMAINDER: {
                return ArithmeticOperation.UREM;
            }
            case INT_SIGNED_REMAINDER: 
            case FP_REMAINDER: {
                return ArithmeticOperation.REM;
            }
            case INT_SHIFT_LEFT: {
                return ArithmeticOperation.SHL;
            }
            case INT_LOGICAL_SHIFT_RIGHT: {
                return ArithmeticOperation.LSHR;
            }
            case INT_ARITHMETIC_SHIFT_RIGHT: {
                return ArithmeticOperation.ASHR;
            }
            case INT_AND: {
                return ArithmeticOperation.AND;
            }
            case INT_OR: {
                return ArithmeticOperation.OR;
            }
            case INT_XOR: {
                return ArithmeticOperation.XOR;
            }
        }
        throw new LLVMParserException("Unknown binary operator: " + String.valueOf((Object)operator));
    }

    public static LLVMExpressionNode createCast(LLVMExpressionNode fromNode, Type targetType, Type fromType, CastOperator operator, NodeFactory nodeFactory) {
        switch (operator) {
            case ZERO_EXTEND: 
            case UNSIGNED_INT_TO_FP: 
            case INT_TO_PTR: 
            case FP_TO_UNSIGNED_INT: {
                return CommonNodeFactory.createUnsignedCast(fromNode, targetType);
            }
            case SIGN_EXTEND: 
            case TRUNCATE: 
            case FP_TO_SIGNED_INT: 
            case FP_EXTEND: 
            case FP_TRUNCATE: 
            case PTR_TO_INT: 
            case SIGNED_INT_TO_FP: {
                return CommonNodeFactory.createSignedCast(fromNode, targetType);
            }
            case BITCAST: {
                return nodeFactory.createBitcast(fromNode, targetType, fromType);
            }
        }
        return null;
    }

    public static LLVMExpressionNode createUnaryInstruction(LLVMExpressionNode operand, UnaryOperator operator, Type type, NodeFactory nodeFactory) {
        return nodeFactory.createUnaryOp(LLVMBitcodeTypeHelper.getUnaryOperation(operator), type, operand);
    }

    private static UnaryOperation getUnaryOperation(UnaryOperator operator) {
        switch (operator) {
            case FP_NEG: {
                return UnaryOperation.NEG;
            }
        }
        return null;
    }
}

