/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.llvm.runtime.IDGenerater;
import com.oracle.truffle.llvm.runtime.LLVMElemPtrSymbol;
import com.oracle.truffle.llvm.runtime.LLVMFunctionCode;
import com.oracle.truffle.llvm.runtime.LLVMFunctionDescriptor;
import com.oracle.truffle.llvm.runtime.LLVMSymbol;
import com.oracle.truffle.llvm.runtime.LLVMThreadLocalSymbol;
import com.oracle.truffle.llvm.runtime.debug.scope.LLVMSourceLocation;
import com.oracle.truffle.llvm.runtime.global.LLVMGlobal;
import com.oracle.truffle.llvm.runtime.pointer.LLVMManagedPointer;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;
import com.oracle.truffle.llvm.runtime.types.FunctionType;

public final class LLVMFunction
extends LLVMSymbol {
    public static final LLVMFunction[] EMPTY = new LLVMFunction[0];
    private final FunctionType type;
    private final LLVMFunctionCode.Function function;
    private final String path;
    private LLVMSourceLocation sourceLocation;
    private final Assumption fixedCodeAssumption = Truffle.getRuntime().createAssumption();
    @CompilerDirectives.CompilationFinal
    private LLVMFunctionCode fixedCode;
    @CompilerDirectives.CompilationFinal
    private Object nfiSymbol;

    public static LLVMFunction create(String name, LLVMFunctionCode.Function function, FunctionType type, IDGenerater.BitcodeID bitcodeID, int symbolIndex, boolean exported, String path, boolean externalWeak) {
        return new LLVMFunction(name, function, type, bitcodeID, symbolIndex, exported, path, externalWeak);
    }

    public LLVMFunction(String name, LLVMFunctionCode.Function function, FunctionType type, IDGenerater.BitcodeID bitcodeID, int symbolIndex, boolean exported, String path, boolean externalWeak) {
        super(name, bitcodeID, symbolIndex, exported, externalWeak);
        this.type = type;
        this.function = function;
        this.path = path;
    }

    public LLVMSourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(LLVMSourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public String getStringPath() {
        return this.path;
    }

    public FunctionType getType() {
        return this.type;
    }

    public LLVMFunctionCode.Function getFunction() {
        return this.function;
    }

    @Override
    public boolean isFunction() {
        return true;
    }

    @Override
    public boolean isGlobalVariable() {
        return false;
    }

    @Override
    public boolean isAlias() {
        return false;
    }

    @Override
    public LLVMFunction asFunction() {
        return this;
    }

    @Override
    public LLVMGlobal asGlobalVariable() {
        throw new IllegalStateException("Function " + this.getName() + " is not a global variable.");
    }

    public Assumption getFixedCodeAssumption() {
        return this.fixedCodeAssumption;
    }

    @Idempotent
    public LLVMFunctionCode getFixedCode() {
        return this.fixedCode;
    }

    public void setValue(LLVMPointer pointer) {
        if (this.fixedCodeAssumption.isValid()) {
            Object value;
            if (LLVMManagedPointer.isInstance(pointer) && (value = LLVMManagedPointer.cast(pointer).getObject()) instanceof LLVMFunctionDescriptor) {
                LLVMFunctionDescriptor descriptor = (LLVMFunctionDescriptor)value;
                LLVMFunctionCode code = descriptor.getFunctionCode();
                if (this.fixedCode == null) {
                    this.fixedCode = code;
                    return;
                }
                if (this.fixedCode == code) {
                    return;
                }
            }
            this.fixedCode = null;
            this.fixedCodeAssumption.invalidate();
        }
    }

    @Override
    public boolean isElemPtrExpression() {
        return false;
    }

    @Override
    public LLVMElemPtrSymbol asElemPtrExpression() {
        throw new IllegalStateException("Function " + this.getName() + " is not a getElementPointer symbol.");
    }

    public void setNFISymbol(Object symbol) {
        this.nfiSymbol = symbol;
    }

    public Object getNFISymbol() {
        return this.nfiSymbol;
    }

    @Override
    public boolean isThreadLocalSymbol() {
        return false;
    }

    @Override
    public LLVMThreadLocalSymbol asThreadLocalSymbol() {
        throw new IllegalStateException("GetElementPointerConstant " + this.getName() + " has to be resolved and might not be a thread local global variable.");
    }
}

