/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.interop.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropInvokeNodeGen;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropMethodInvokeNode;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMInteropType;
import com.oracle.truffle.llvm.runtime.interop.access.LLVMSelfArgumentPackNode;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMNode;
import com.oracle.truffle.llvm.runtime.pointer.LLVMPointer;

@GenerateUncached
public abstract class LLVMInteropInvokeNode
extends LLVMNode {
    public abstract Object execute(LLVMPointer var1, LLVMInteropType var2, String var3, Object[] var4) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException;

    public static LLVMInteropInvokeNode create() {
        return LLVMInteropInvokeNodeGen.create();
    }

    @Specialization
    @GenerateAOT.Exclude
    Object doClazz(LLVMPointer receiver, LLVMInteropType.Clazz type, String method, Object[] arguments, @Cached LLVMInteropMethodInvokeNode invoke, @Cached LLVMSelfArgumentPackNode selfPackNode, @CachedLibrary(limit="5") InteropLibrary interop) throws ArityException, UnknownIdentifierException, UnsupportedTypeException, UnsupportedMessageException {
        Object[] selfArgs = selfPackNode.execute(receiver, arguments);
        LLVMInteropType.Method methodObject = type.findMethodByArgumentsWithSelf(method, selfArgs);
        if (methodObject == null) {
            return this.doStruct(receiver, type, method, arguments, interop);
        }
        long virtualIndex = methodObject.getVirtualIndex();
        return invoke.execute(receiver, method, type, methodObject, virtualIndex, selfArgs);
    }

    @Specialization(guards={"!isClass(type)"})
    @GenerateAOT.Exclude
    Object doStruct(LLVMPointer receiver, LLVMInteropType.Struct type, String member, Object[] arguments, @CachedLibrary(limit="5") InteropLibrary interop) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException, ArityException {
        Object readMember = interop.readMember((Object)receiver, member);
        return interop.execute(readMember, arguments);
    }

    protected static boolean isClass(Object o) {
        return o instanceof LLVMInteropType.Clazz;
    }

    @Fallback
    Object doError(LLVMPointer receiver, LLVMInteropType type, String member, Object[] arguments) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create();
    }
}

