/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.runtime.nodes.asm;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateAOT;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.llvm.runtime.nodes.api.LLVMExpressionNode;
import com.oracle.truffle.llvm.runtime.nodes.asm.LLVMAMD64ModNode;
import java.util.concurrent.locks.ReentrantLock;

@GeneratedBy(value=LLVMAMD64ModNode.class)
public final class LLVMAMD64ModNodeGen
extends LLVMAMD64ModNode
implements GenerateAOT.Provider {
    @Node.Child
    private LLVMExpressionNode left_;
    @Node.Child
    private LLVMExpressionNode rightAX_;
    @Node.Child
    private LLVMExpressionNode rightDX_;
    @CompilerDirectives.CompilationFinal
    private int state_0_;

    private LLVMAMD64ModNodeGen(LLVMExpressionNode left, LLVMExpressionNode rightAX, LLVMExpressionNode rightDX) {
        this.left_ = left;
        this.rightAX_ = rightAX;
        this.rightDX_ = rightDX;
    }

    @Override
    public Object executeGeneric(VirtualFrame frameValue) {
        int rightDXValue_;
        int rightAXValue_;
        int leftValue_;
        int state_0 = this.state_0_;
        try {
            leftValue_ = this.left_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightAXValue = this.rightAX_.executeGeneric(frameValue);
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightAXValue, rightDXValue);
        }
        try {
            rightAXValue_ = this.rightAX_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return this.executeAndSpecialize(leftValue_, ex.getResult(), rightDXValue);
        }
        try {
            rightDXValue_ = this.rightDX_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightAXValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
        }
        if ((state_0 & 2) != 0) {
            return this.doI32(leftValue_, rightAXValue_, rightDXValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
    }

    @Override
    public int executeI32(VirtualFrame frameValue) {
        int rightDXValue_;
        int rightAXValue_;
        int leftValue_;
        int state_0 = this.state_0_;
        try {
            leftValue_ = this.left_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightAXValue = this.rightAX_.executeGeneric(frameValue);
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return this.executeAndSpecialize(ex.getResult(), rightAXValue, rightDXValue);
        }
        try {
            rightAXValue_ = this.rightAX_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Object rightDXValue = this.rightDX_.executeGeneric(frameValue);
            return this.executeAndSpecialize(leftValue_, ex.getResult(), rightDXValue);
        }
        try {
            rightDXValue_ = this.rightDX_.executeI32(frameValue);
        }
        catch (UnexpectedResultException ex) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.executeAndSpecialize(leftValue_, rightAXValue_, ex.getResult());
        }
        if (CompilerDirectives.inInterpreter() && (state_0 & 1) != 0) {
            return this.executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
        }
        if ((state_0 & 2) != 0) {
            return this.doI32(leftValue_, rightAXValue_, rightDXValue_);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        return this.executeAndSpecialize(leftValue_, rightAXValue_, rightDXValue_);
    }

    private int executeAndSpecialize(Object leftValue, Object rightAXValue, Object rightDXValue) {
        int state_0 = this.state_0_;
        if ((state_0 & 1) != 0) {
            this.resetAOT_();
            state_0 = this.state_0_;
        }
        if (leftValue instanceof Integer) {
            int leftValue_ = (Integer)leftValue;
            if (rightAXValue instanceof Integer) {
                int rightAXValue_ = (Integer)rightAXValue;
                if (rightDXValue instanceof Integer) {
                    int rightDXValue_ = (Integer)rightDXValue;
                    this.state_0_ = state_0 |= 2;
                    return this.doI32(leftValue_, rightAXValue_, rightDXValue_);
                }
            }
        }
        throw new UnsupportedSpecializationException((Node)this, new Node[]{this.left_, this.rightAX_, this.rightDX_}, new Object[]{leftValue, rightAXValue, rightDXValue});
    }

    public void prepareForAOT(TruffleLanguage<?> language, RootNode root) {
        assert (!this.isAdoptable() || ((ReentrantLock)this.getLock()).isHeldByCurrentThread()) : "During prepare AST lock must be held.";
        if ((this.state_0_ & 1) != 0) {
            return;
        }
        this.state_0_ |= 2;
        int state_0 = this.state_0_;
        this.state_0_ = state_0 |= 1;
    }

    private void resetAOT_() {
        int state_0 = this.state_0_;
        if ((state_0 & 1) == 0) {
            return;
        }
        this.state_0_ = 0;
    }

    @NeverDefault
    public static LLVMAMD64ModNode create(LLVMExpressionNode left, LLVMExpressionNode rightAX, LLVMExpressionNode rightDX) {
        return new LLVMAMD64ModNodeGen(left, rightAX, rightDX);
    }
}

